/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.jdi.ArrayReferenceImpl;
import com.jetbrains.jdi.ClassTypeImpl;
import com.jetbrains.jdi.InterfaceTypeImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.StringReferenceImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerUtilsAsync {
    private static final Logger LOG = Logger.getInstance(DebuggerUtilsAsync.class);

    public static CompletableFuture<String> getStringValue(StringReference value2) {
        if (value2 instanceof StringReferenceImpl && Registry.is((String)"debugger.async.jdi")) {
            return DebuggerUtilsAsync.reschedule(((StringReferenceImpl)value2).valueAsync());
        }
        return CompletableFuture.completedFuture(value2.value());
    }

    public static CompletableFuture<List<Field>> allFields(ReferenceType type2) {
        if (type2 instanceof ReferenceTypeImpl && Registry.is((String)"debugger.async.jdi")) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type2).allFieldsAsync());
        }
        return CompletableFuture.completedFuture(type2.allFields());
    }

    public static CompletableFuture<List<Field>> fields(ReferenceType type2) {
        if (type2 instanceof ReferenceTypeImpl && Registry.is((String)"debugger.async.jdi")) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type2).fieldsAsync());
        }
        return CompletableFuture.completedFuture(type2.fields());
    }

    public static CompletableFuture<? extends Type> type(@Nullable Value value2) {
        if (value2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (value2 instanceof ObjectReferenceImpl && Registry.is((String)"debugger.async.jdi")) {
            return DebuggerUtilsAsync.reschedule(((ObjectReferenceImpl)value2).typeAsync());
        }
        return CompletableFuture.completedFuture(value2.type());
    }

    public static CompletableFuture<Value> getValue(ObjectReference ref, Field field) {
        if (ref instanceof ObjectReferenceImpl && Registry.is((String)"debugger.async.jdi")) {
            return DebuggerUtilsAsync.reschedule(((ObjectReferenceImpl)ref).getValueAsync(field));
        }
        return CompletableFuture.completedFuture(ref.getValue(field));
    }

    public static CompletableFuture<Map<Field, Value>> getValues(ObjectReference ref, List<Field> fields) {
        if (ref instanceof ObjectReferenceImpl && Registry.is((String)"debugger.async.jdi")) {
            return DebuggerUtilsAsync.reschedule(((ObjectReferenceImpl)ref).getValuesAsync(fields));
        }
        return CompletableFuture.completedFuture(ref.getValues(fields));
    }

    public static CompletableFuture<Map<Field, Value>> getValues(ReferenceType type2, List<Field> fields) {
        if (type2 instanceof ReferenceTypeImpl && Registry.is((String)"debugger.async.jdi")) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type2).getValuesAsync(fields));
        }
        return CompletableFuture.completedFuture(type2.getValues(fields));
    }

    public static CompletableFuture<List<Value>> getValues(ArrayReference ref, int index, int length) {
        if (ref instanceof ArrayReferenceImpl && Registry.is((String)"debugger.async.jdi")) {
            return DebuggerUtilsAsync.reschedule(((ArrayReferenceImpl)ref).getValuesAsync(index, length));
        }
        return CompletableFuture.completedFuture(ref.getValues(index, length));
    }

    public static CompletableFuture<Integer> length(ArrayReference ref) {
        if (ref instanceof ArrayReferenceImpl && Registry.is((String)"debugger.async.jdi")) {
            return DebuggerUtilsAsync.reschedule(((ArrayReferenceImpl)ref).lengthAsync());
        }
        return CompletableFuture.completedFuture(ref.length());
    }

    public static CompletableFuture<Boolean> instanceOf(@Nullable Type subType, @NotNull String superType) {
        if (superType == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(0);
        }
        return DebuggerUtilsAsync.instanceOf(subType, superType, true);
    }

    private static CompletableFuture<Boolean> instanceOf(@Nullable Type subType, @NotNull String superType, boolean reschedule) {
        if (superType == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"debugger.async.jdi")) {
            return CompletableFuture.completedFuture(DebuggerUtils.instanceOf((Type)subType, (String)superType));
        }
        if (subType == null || subType instanceof VoidType) {
            return CompletableFuture.completedFuture(false);
        }
        if (subType instanceof PrimitiveType) {
            return CompletableFuture.completedFuture(superType.equals(subType.name()));
        }
        if ("java.lang.Object".equals(superType)) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<Boolean> res = new CompletableFuture<Boolean>();
        DebuggerUtilsAsync.instanceOfObject(subType, superType, res).thenRun(() -> res.complete(false));
        if (!reschedule) {
            return res;
        }
        return DebuggerUtilsAsync.reschedule(res);
    }

    private static CompletableFuture<Void> instanceOfObject(@Nullable Type subType, @NotNull String superType, CompletableFuture<Boolean> res) {
        if (superType == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(2);
        }
        if (subType == null || res.isDone()) {
            return CompletableFuture.completedFuture(null);
        }
        if (DebuggerUtilsAsync.typeEquals(subType, superType)) {
            res.complete(true);
            return CompletableFuture.completedFuture(null);
        }
        if (subType instanceof ClassType) {
            return CompletableFuture.allOf(new CompletableFuture[]{DebuggerUtilsAsync.superclass((ClassType)subType).thenCompose(s -> DebuggerUtilsAsync.instanceOfObject(s, superType, res)), DebuggerUtilsAsync.interfaces((ClassType)subType).thenCompose(interfaces -> CompletableFuture.allOf((CompletableFuture[])interfaces.stream().map(i -> DebuggerUtilsAsync.instanceOfObject(i, superType, res)).toArray(CompletableFuture[]::new)))});
        }
        if (subType instanceof InterfaceType) {
            return CompletableFuture.allOf(new CompletableFuture[]{DebuggerUtilsAsync.superinterfaces((InterfaceType)subType).thenCompose(interfaces -> CompletableFuture.allOf((CompletableFuture[])interfaces.stream().map(i -> DebuggerUtilsAsync.instanceOfObject(i, superType, res)).toArray(CompletableFuture[]::new)))});
        }
        if (subType instanceof ArrayType && superType.endsWith("[]")) {
            try {
                String superTypeItem = superType.substring(0, superType.length() - 2);
                Type subTypeItem = ((ArrayType)subType).componentType();
                return DebuggerUtilsAsync.instanceOf(subTypeItem, superTypeItem, false).thenAccept(r -> {
                    if (r.booleanValue()) {
                        res.complete(true);
                    }
                });
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                // empty catch block
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    private static boolean typeEquals(@NotNull Type type2, @NotNull String typeName) {
        int genericPos;
        if (type2 == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(3);
        }
        if (typeName == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(4);
        }
        if ((genericPos = typeName.indexOf(60)) > -1) {
            typeName = typeName.substring(0, genericPos);
        }
        return type2.name().replace('$', '.').equals(typeName.replace('$', '.'));
    }

    public static CompletableFuture<Type> findAnyBaseType(@NotNull Type subType, Function<Type, CompletableFuture<Boolean>> checker) {
        if (subType == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(5);
        }
        CompletableFuture<Type> res = new CompletableFuture<Type>();
        DebuggerUtilsAsync.findAnyBaseType(subType, checker, res).thenRun(() -> res.complete(null));
        return DebuggerUtilsAsync.reschedule(res);
    }

    private static CompletableFuture<Void> findAnyBaseType(@Nullable Type type2, Function<Type, CompletableFuture<Boolean>> checker, CompletableFuture<Type> res) {
        if (type2 == null || res.isDone()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage self = checker.apply(type2).thenAccept(r -> {
            if (r.booleanValue()) {
                res.complete(type2);
            }
        });
        if (type2 instanceof ClassType) {
            return CompletableFuture.allOf(new CompletableFuture[]{self, DebuggerUtilsAsync.superclass((ClassType)type2).thenCompose(s -> DebuggerUtilsAsync.findAnyBaseType(s, checker, res)), DebuggerUtilsAsync.interfaces((ClassType)type2).thenCompose(interfaces -> CompletableFuture.allOf((CompletableFuture[])interfaces.stream().map(i -> DebuggerUtilsAsync.findAnyBaseType(i, checker, res)).toArray(CompletableFuture[]::new)))});
        }
        if (type2 instanceof InterfaceType) {
            return CompletableFuture.allOf(new CompletableFuture[]{self, DebuggerUtilsAsync.superinterfaces((InterfaceType)type2).thenCompose(interfaces -> CompletableFuture.allOf((CompletableFuture[])interfaces.stream().map(i -> DebuggerUtilsAsync.findAnyBaseType(i, checker, res)).toArray(CompletableFuture[]::new)))});
        }
        return self;
    }

    public static CompletableFuture<List<Method>> methods(ReferenceType type2) {
        if (type2 instanceof ReferenceTypeImpl && Registry.is((String)"debugger.async.jdi")) {
            return ((ReferenceTypeImpl)type2).methodsAsync();
        }
        return CompletableFuture.completedFuture(type2.methods());
    }

    public static CompletableFuture<List<InterfaceType>> superinterfaces(InterfaceType iface) {
        if (iface instanceof InterfaceTypeImpl && Registry.is((String)"debugger.async.jdi")) {
            return ((InterfaceTypeImpl)iface).superinterfacesAsync();
        }
        return CompletableFuture.completedFuture(iface.superinterfaces());
    }

    public static CompletableFuture<ClassType> superclass(ClassType cls) {
        if (cls instanceof ClassTypeImpl && Registry.is((String)"debugger.async.jdi")) {
            return ((ClassTypeImpl)cls).superclassAsync();
        }
        return CompletableFuture.completedFuture(cls.superclass());
    }

    public static CompletableFuture<List<InterfaceType>> interfaces(ClassType cls) {
        if (cls instanceof ClassTypeImpl && Registry.is((String)"debugger.async.jdi")) {
            return ((ClassTypeImpl)cls).interfacesAsync();
        }
        return CompletableFuture.completedFuture(cls.interfaces());
    }

    public static CompletableFuture<Stream<? extends ReferenceType>> supertypes(ReferenceType type2) {
        if (!Registry.is((String)"debugger.async.jdi")) {
            return CompletableFuture.completedFuture(DebuggerUtilsImpl.supertypes(type2));
        }
        if (type2 instanceof InterfaceType) {
            return DebuggerUtilsAsync.superinterfaces((InterfaceType)type2).thenApply(Collection::stream);
        }
        if (type2 instanceof ClassType) {
            return DebuggerUtilsAsync.superclass((ClassType)type2).thenCombine(DebuggerUtilsAsync.interfaces((ClassType)type2), (superclass, interfaces) -> StreamEx.ofNullable((Object)superclass).prepend((Collection)interfaces));
        }
        return CompletableFuture.completedFuture(StreamEx.empty());
    }

    public static <T> CompletableFuture<T> reschedule(CompletableFuture<T> future) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebuggerManagerThreadImpl thread = (DebuggerManagerThreadImpl)InvokeThread.currentThread();
        LOG.assertTrue(thread != null);
        DebuggerCommandImpl event = DebuggerManagerThreadImpl.getCurrentCommand();
        LOG.assertTrue(event != null);
        final PrioritizedTask.Priority priority = event.getPriority();
        SuspendContextImpl suspendContext = event instanceof SuspendContextCommandImpl ? ((SuspendContextCommandImpl)event).getSuspendContext() : null;
        CompletableFuture res = new CompletableFuture();
        future.whenComplete((r, ex) -> {
            if (DebuggerManagerThreadImpl.isManagerThread()) {
                DebuggerUtilsAsync.completeFuture(r, ex, res);
            } else if (suspendContext != null) {
                thread.schedule(new SuspendContextCommandImpl(suspendContext, (Throwable)ex, res){
                    final /* synthetic */ Throwable val$ex;
                    final /* synthetic */ CompletableFuture val$res;
                    {
                        this.val$ex = throwable;
                        this.val$res = completableFuture;
                        super(suspendContext);
                    }

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return priority;
                    }

                    @Override
                    public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                        if (suspendContext == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DebuggerUtilsAsync.completeFuture(r, this.val$ex, this.val$res);
                    }

                    @Override
                    protected void commandCancelled() {
                        this.val$res.cancel(false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerUtilsAsync$1", "contextAction"));
                    }
                });
            } else {
                thread.schedule(new DebuggerCommandImpl(priority, (Throwable)ex, res){
                    final /* synthetic */ Throwable val$ex;
                    final /* synthetic */ CompletableFuture val$res;
                    {
                        this.val$ex = throwable;
                        this.val$res = completableFuture;
                        super(priority);
                    }

                    @Override
                    protected void action() {
                        DebuggerUtilsAsync.completeFuture(r, this.val$ex, this.val$res);
                    }

                    @Override
                    protected void commandCancelled() {
                        this.val$res.cancel(false);
                    }
                });
            }
        });
        return res;
    }

    public static Throwable unwrap(Throwable throwable) {
        return throwable instanceof CompletionException ? throwable.getCause() : throwable;
    }

    private static <T> void completeFuture(T res, Throwable ex, CompletableFuture<T> future) {
        if (ex != null) {
            future.completeExceptionally(ex);
        } else {
            future.complete(res);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsAsync";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceOf";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceOfObject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "typeEquals";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findAnyBaseType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

