/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.memory.agent.MemoryAgentUtil;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.GetJPDADialog;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteConnectionBuilder {
    private static final Logger LOG = Logger.getInstance(RemoteConnectionBuilder.class);
    private final int myTransport;
    private final boolean myServer;
    private final String myAddress;
    private boolean myCheckValidity;
    private boolean myAsyncAgent;
    private boolean myMemoryAgent;
    private boolean myQuiet;
    private boolean mySuspend = true;
    private Project myProject;
    private static final String AGENT_FILE_NAME = "debugger-agent.jar";
    @NonNls
    private static final String DEBUG_KEY_NAME = "idea.xdebug.key";

    public RemoteConnectionBuilder(boolean server, int transport, String address) {
        this.myTransport = transport;
        this.myServer = server;
        this.myAddress = address;
    }

    public RemoteConnectionBuilder checkValidity(boolean check) {
        this.myCheckValidity = check;
        return this;
    }

    public RemoteConnectionBuilder asyncAgent(boolean useAgent) {
        this.myAsyncAgent = useAgent;
        return this;
    }

    public RemoteConnectionBuilder project(Project project) {
        this.myProject = project;
        return this;
    }

    public RemoteConnectionBuilder memoryAgent(boolean useAgent) {
        this.myMemoryAgent = useAgent;
        return this;
    }

    public RemoteConnectionBuilder quiet() {
        this.myQuiet = true;
        return this;
    }

    public RemoteConnectionBuilder suspend(boolean suspend) {
        this.mySuspend = suspend;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public RemoteConnection create(JavaParameters parameters) throws ExecutionException {
        if (this.myCheckValidity) {
            RemoteConnectionBuilder.checkTargetJPDAInstalled(parameters);
        }
        useSockets = this.myTransport == 0;
        address = "";
        if (StringUtil.isEmptyOrSpaces((String)this.myAddress)) {
            try {
                address = DebuggerUtils.getInstance().findAvailableDebugAddress(useSockets);
            }
            catch (ExecutionException e) {
                if (!this.myCheckValidity) ** GOTO lbl13
                throw e;
            }
        } else {
            address = this.myAddress;
        }
lbl13:
        // 3 sources

        debugAddress = this.myServer != false && useSockets != false ? "127.0.0.1:" + address : address;
        debuggeeRunProperties = new StringBuilder();
        debuggeeRunProperties.append("transport=").append(DebugProcessImpl.findConnector(useSockets, this.myServer).transport().name());
        debuggeeRunProperties.append(",address=").append(debugAddress);
        debuggeeRunProperties.append(this.mySuspend != false ? ",suspend=y" : ",suspend=n");
        debuggeeRunProperties.append(this.myServer != false ? ",server=n" : ",server=y");
        if (StringUtil.containsWhitespaces((CharSequence)debuggeeRunProperties)) {
            debuggeeRunProperties.append("\"").append((CharSequence)debuggeeRunProperties).append("\"");
        }
        if (this.myQuiet) {
            debuggeeRunProperties.append(",quiet=y");
        }
        _debuggeeRunProperties = debuggeeRunProperties.toString();
        ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$create$0(com.intellij.execution.configurations.JavaParameters java.lang.String ), ()V)((RemoteConnectionBuilder)this, (JavaParameters)parameters, (String)_debuggeeRunProperties));
        return new RemoteConnection(useSockets, "127.0.0.1", address, this.myServer);
    }

    private static void addRtJar(@NotNull PathsList pathsList) {
        if (pathsList == null) {
            RemoteConnectionBuilder.$$$reportNull$$$0(0);
        }
        if (PluginManagerCore.isRunningFromSources()) {
            String path = DebuggerUtilsImpl.getIdeaRtPath();
            pathsList.remove(JavaSdkUtil.getIdeaRtJarPath());
            pathsList.addTail(path);
        } else {
            JavaSdkUtil.addRtJar(pathsList);
        }
    }

    private static void checkTargetJPDAInstalled(@NotNull JavaParameters parameters2) throws ExecutionException {
        Sdk jdk;
        if (parameters2 == null) {
            RemoteConnectionBuilder.$$$reportNull$$$0(1);
        }
        if ((jdk = parameters2.getJdk()) == null) {
            throw new ExecutionException(JavaDebuggerBundle.message((String)"error.jdk.not.specified", (Object[])new Object[0]));
        }
        JavaSdkVersion version = JavaSdk.getInstance().getVersion(jdk);
        if (version == JavaSdkVersion.JDK_1_0 || version == JavaSdkVersion.JDK_1_1) {
            String versionString = jdk.getVersionString();
            throw new ExecutionException(JavaDebuggerBundle.message((String)"error.unsupported.jdk.version", (Object[])new Object[]{versionString}));
        }
        if (SystemInfo.isWindows && version == JavaSdkVersion.JDK_1_2) {
            VirtualFile homeDirectory = jdk.getHomeDirectory();
            if (homeDirectory == null || !homeDirectory.isValid()) {
                String versionString = jdk.getVersionString();
                throw new ExecutionException(JavaDebuggerBundle.message((String)"error.invalid.jdk.home", (Object[])new Object[]{versionString}));
            }
            File dllFile = new File(homeDirectory.getPath().replace('/', File.separatorChar) + File.separator + "bin" + File.separator + "jdwp.dll");
            if (!dllFile.exists()) {
                GetJPDADialog dialog = new GetJPDADialog();
                dialog.show();
                throw new ExecutionException(JavaDebuggerBundle.message((String)"error.debug.libraries.missing", (Object[])new Object[0]));
            }
        }
    }

    private static void addDebuggerAgent(JavaParameters parameters2, @Nullable Project project) {
        if (AsyncStacksUtils.isAgentEnabled()) {
            String prefix = "-javaagent:";
            ParametersList parametersList = parameters2.getVMParametersList();
            if (parametersList.getParameters().stream().noneMatch(p -> p.startsWith(prefix) && p.contains(AGENT_FILE_NAME))) {
                String version;
                Sdk jdk = parameters2.getJdk();
                String string = version = jdk != null ? JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION) : null;
                if (version != null) {
                    JavaSdkVersion sdkVersion = JavaSdkVersion.fromVersionString((String)version);
                    if (sdkVersion != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_6)) {
                        File artifactsInBuildScripts;
                        File classesRoot = new File(PathUtil.getJarPathForClass(DebuggerManagerImpl.class));
                        File agentFile = classesRoot.isFile() ? new File(classesRoot.getParentFile(), "rt/debugger-agent.jar") : ((artifactsInBuildScripts = new File(classesRoot.getParentFile().getParentFile().getParentFile(), "project-artifacts")).exists() ? new File(artifactsInBuildScripts, "debugger_agent/debugger-agent.jar") : new File(classesRoot.getParentFile().getParentFile(), "/artifacts/debugger_agent/debugger-agent.jar"));
                        if (agentFile.exists()) {
                            String agentPath = JavaExecutionUtil.handleSpacesInAgentPath((String)agentFile.getAbsolutePath(), (String)"captureAgent", null, f -> f.getName().startsWith("debugger-agent"));
                            if (agentPath != null) {
                                parametersList.add(prefix + agentPath + RemoteConnectionBuilder.generateAgentSettings(project));
                            }
                        } else {
                            LOG.warn("Capture agent not found: " + agentFile);
                        }
                    } else {
                        LOG.warn("Capture agent is not supported for jre " + version);
                    }
                }
            }
        }
    }

    private static String generateAgentSettings(@Nullable Project project) {
        Properties properties = CaptureSettingsProvider.getPointsProperties(project);
        if (!properties.isEmpty()) {
            String string;
            File file = FileUtil.createTempFile((String)"capture", (String)".props");
            FileOutputStream out = new FileOutputStream(file);
            try {
                properties.store(out, null);
                string = "=" + file.toURI().toASCIIString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            out.close();
            return string;
        }
        return "";
    }

    private static boolean shouldForceClassicVM(Sdk jdk) {
        if (SystemInfo.isMac) {
            return false;
        }
        if (jdk == null) {
            return false;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null || StringUtil.compareVersionNumbers((String)version, (String)"1.4") >= 0) {
            return false;
        }
        if (version.startsWith("1.2") && SystemInfo.isWindows) {
            return true;
        }
        if ((version = version + ".0").startsWith("1.3.0") && SystemInfo.isWindows) {
            return true;
        }
        if ((version.startsWith("1.3.1_07") || version.startsWith("1.3.1_08")) && SystemInfo.isWindows) {
            return false;
        }
        return DebuggerSettings.getInstance().FORCE_CLASSIC_VM;
    }

    private static boolean shouldForceNoJIT(Sdk jdk) {
        String version;
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        return jdk != null && (version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION)) != null && (version.startsWith("1.2") || version.startsWith("1.3"));
    }

    private static boolean shouldAddXdebugKey(Sdk jdk) {
        if (jdk == null) {
            return true;
        }
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        return version == null || version.startsWith("1.4") || version.startsWith("1.3") || version.startsWith("1.2") || version.startsWith("1.1") || version.startsWith("1.0");
    }

    private static boolean isJVMTIAvailable(Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            return false;
        }
        return !version.startsWith("1.4") && !version.startsWith("1.3") && !version.startsWith("1.2") && !version.startsWith("1.1") && !version.startsWith("1.0");
    }

    private /* synthetic */ void lambda$create$0(JavaParameters parameters2, String _debuggeeRunProperties) {
        boolean needDebugKey;
        RemoteConnectionBuilder.addRtJar(parameters2.getClassPath());
        if (this.myAsyncAgent) {
            RemoteConnectionBuilder.addDebuggerAgent(parameters2, this.myProject);
        }
        if (this.myMemoryAgent) {
            MemoryAgentUtil.addMemoryAgent(parameters2);
        }
        Sdk jdk = parameters2.getJdk();
        boolean forceClassicVM = RemoteConnectionBuilder.shouldForceClassicVM(jdk);
        boolean forceNoJIT = RemoteConnectionBuilder.shouldForceNoJIT(jdk);
        String debugKey = System.getProperty(DEBUG_KEY_NAME, "-Xdebug");
        boolean bl = needDebugKey = RemoteConnectionBuilder.shouldAddXdebugKey(jdk) || !"-Xdebug".equals(debugKey);
        if (forceClassicVM || forceNoJIT || needDebugKey || !RemoteConnectionBuilder.isJVMTIAvailable(jdk)) {
            parameters2.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "-Xrunjdwp:" + _debuggeeRunProperties);
        } else {
            parameters2.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "");
            parameters2.getVMParametersList().replaceOrPrepend("-agentlib:jdwp=", "-agentlib:jdwp=" + _debuggeeRunProperties);
        }
        if (forceNoJIT) {
            parameters2.getVMParametersList().replaceOrPrepend("-Djava.compiler=", "-Djava.compiler=NONE");
            parameters2.getVMParametersList().replaceOrPrepend("-Xnoagent", "-Xnoagent");
        }
        if (needDebugKey) {
            parameters2.getVMParametersList().replaceOrPrepend(debugKey, debugKey);
        } else {
            parameters2.getVMParametersList().replaceOrPrepend("-Xdebug", "");
        }
        parameters2.getVMParametersList().replaceOrPrepend("-classic", forceClassicVM ? "-classic" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/impl/RemoteConnectionBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addRtJar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTargetJPDAInstalled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

