/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.debugger.impl.attach.JavaAttachDebuggerProvider;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerConsoleFilterProvider
implements ConsoleFilterProvider {
    public Filter @NotNull [] getDefaultFilters(@NotNull Project project) {
        if (project == null) {
            JavaDebuggerConsoleFilterProvider.$$$reportNull$$$0(0);
        }
        Filter[] filterArray = new Filter[]{new JavaDebuggerAttachFilter()};
        if (filterArray == null) {
            JavaDebuggerConsoleFilterProvider.$$$reportNull$$$0(1);
        }
        return filterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/attach/JavaDebuggerConsoleFilterProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/attach/JavaDebuggerConsoleFilterProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFilters";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AttachInlayResult
    extends Filter.ResultItem
    implements InlayProvider {
        private final String myTransport;
        private final String myAddress;

        AttachInlayResult(int highlightStartOffset, int highlightEndOffset, String transport, String address) {
            super(highlightStartOffset, highlightEndOffset, null);
            this.myTransport = transport;
            this.myAddress = address;
        }

        public EditorCustomElementRenderer createInlayRenderer(Editor editor) {
            PresentationFactory factory = new PresentationFactory((EditorImpl)editor);
            InlayPresentation presentation = factory.referenceOnHover(factory.roundWithBackground(factory.smallText("Attach debugger")), (event, point) -> JavaAttachDebuggerProvider.attach(this.myTransport, this.myAddress, null, editor.getProject()));
            return new PresentationRenderer(presentation);
        }
    }

    private static class JavaDebuggerAttachFilter
    implements Filter {
        static final Pattern PATTERN = Pattern.compile("Listening for transport (\\S+) at address: (\\S+)");

        private JavaDebuggerAttachFilter() {
        }

        @Nullable
        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            Matcher matcher;
            if (line == null) {
                JavaDebuggerAttachFilter.$$$reportNull$$$0(0);
            }
            if (!(matcher = PATTERN.matcher(line)).find()) {
                return null;
            }
            String transport = matcher.group(1);
            String address = matcher.group(2);
            int start = entireLength - line.length();
            return new Filter.Result(Arrays.asList(new Filter.ResultItem[]{new AttachInlayResult(start + matcher.start(), start + matcher.end(), transport, address), new Filter.ResultItem(0, 0, null)}));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/debugger/impl/attach/JavaDebuggerConsoleFilterProvider$JavaDebuggerAttachFilter", "applyFilter"));
        }
    }
}

