/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GeneratedLocation
implements Location {
    private final VirtualMachine myVirtualMachine;
    private final int myLineNumber;
    private final ReferenceType myReferenceType;
    private final Method myMethod;

    public GeneratedLocation(DebugProcessImpl debugProcess, ReferenceType type2, String methodName, int lineNumber) {
        this.myVirtualMachine = debugProcess.getVirtualMachineProxy().getVirtualMachine();
        this.myLineNumber = lineNumber;
        this.myReferenceType = type2;
        this.myMethod = DebuggerUtils.findMethod((ReferenceType)this.myReferenceType, (String)methodName, null);
    }

    @Override
    public ReferenceType declaringType() {
        return this.myReferenceType;
    }

    @Override
    public Method method() {
        return this.myMethod;
    }

    @Override
    public long codeIndex() {
        return -2L;
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public String sourceName(String s) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public String sourcePath() throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public String sourcePath(String s) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public int lineNumber() {
        return this.myLineNumber;
    }

    @Override
    public int lineNumber(String s) {
        return this.myLineNumber;
    }

    @Override
    public VirtualMachine virtualMachine() {
        return this.myVirtualMachine;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratedLocation location = (GeneratedLocation)o;
        return Objects.equals(this.myMethod, location.myMethod) && this.myLineNumber == location.myLineNumber && Objects.equals(this.myVirtualMachine, location.myVirtualMachine);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.myMethod, this.myLineNumber);
    }

    @Override
    public int compareTo(@NotNull Location o) {
        int res;
        if (o == null) {
            GeneratedLocation.$$$reportNull$$$0(0);
        }
        if ((res = this.method().compareTo(o.method())) != 0) {
            return res;
        }
        return Long.compare(this.codeIndex(), o.codeIndex());
    }

    @Override
    public String toString() {
        return this.myReferenceType.name() + ":" + this.myLineNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/debugger/jdi/GeneratedLocation", "compareTo"));
    }
}

