/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.memory.action.ActionUtil;
import com.intellij.debugger.memory.action.ClassesActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JumpToTypeSourceAction
extends ClassesActionBase {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        PsiClass psiClass = JumpToTypeSourceAction.getPsiClass(e);
        return super.isEnabled(e) && psiClass != null && psiClass.isPhysical();
    }

    @Override
    protected void perform(AnActionEvent e) {
        PsiClass psiClass = JumpToTypeSourceAction.getPsiClass(e);
        if (psiClass != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)psiClass);
        }
    }

    @Nullable
    private static PsiClass getPsiClass(AnActionEvent e) {
        ReferenceType selectedClass = ActionUtil.getSelectedClass(e);
        Project project = e.getProject();
        if (selectedClass == null || project == null) {
            return null;
        }
        ReferenceType targetClass = JumpToTypeSourceAction.getObjectType(selectedClass);
        if (targetClass != null) {
            return DebuggerUtils.findClass((String)targetClass.name(), (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    @Nullable
    private static ReferenceType getObjectType(@NotNull ReferenceType ref) {
        if (ref == null) {
            JumpToTypeSourceAction.$$$reportNull$$$0(0);
        }
        if (!(ref instanceof ArrayType)) {
            return ref;
        }
        String elementTypeName = ref.name().replace("[]", "");
        VirtualMachine vm = ref.virtualMachine();
        List<ReferenceType> referenceTypes = vm.classesByName(elementTypeName);
        if (referenceTypes.size() == 1) {
            return referenceTypes.get(0);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/debugger/memory/action/JumpToTypeSourceAction", "getObjectType"));
    }
}

