/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.debugger.memory.agent.MemoryAgentImpl;
import com.intellij.debugger.memory.agent.MemoryAgentOperations;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.settings.DebuggerSettings;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface MemoryAgent {
    public static final int DEFAULT_GC_ROOTS_OBJECTS_LIMIT = 1000;

    @NotNull
    public static MemoryAgent get(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            MemoryAgent.$$$reportNull$$$0(0);
        }
        if (!DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT) {
            MemoryAgent memoryAgent = MemoryAgentImpl.DISABLED;
            if (memoryAgent == null) {
                MemoryAgent.$$$reportNull$$$0(1);
            }
            return memoryAgent;
        }
        MemoryAgent memoryAgent = MemoryAgentOperations.getAgent(debugProcess);
        if (memoryAgent == null) {
            MemoryAgent.$$$reportNull$$$0(2);
        }
        return memoryAgent;
    }

    @NotNull
    public MemoryAgentCapabilities capabilities();

    public long estimateObjectSize(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2) throws EvaluateException;

    public long[] estimateObjectsSizes(@NotNull EvaluationContextImpl var1, @NotNull List<ObjectReference> var2) throws EvaluateException;

    @NotNull
    public ReferringObjectsInfo findReferringObjects(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2, int var3) throws EvaluateException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

