/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameItem {
    private static final Logger LOG = Logger.getInstance(StackFrameItem.class);
    private static final List<XNamedValue> VARS_CAPTURE_DISABLED = Collections.singletonList(JavaStackFrame.createMessageNode(JavaDebuggerBundle.message((String)"message.node.local.variables.capture.disabled", (Object[])new Object[0]), null));
    private static final List<XNamedValue> VARS_NOT_CAPTURED = Collections.singletonList(JavaStackFrame.createMessageNode(JavaDebuggerBundle.message((String)"message.node.local.variables.not.captured", (Object[])new Object[0]), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON));
    public static final XDebuggerTreeNodeHyperlink CAPTURE_SETTINGS_OPENER = new XDebuggerTreeNodeHyperlink(" settings"){

        public void onClick(MouseEvent event) {
            ShowSettingsUtil.getInstance().showSettingsDialog((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(event.getComponent())), CaptureConfigurable.class);
            event.consume();
        }
    };
    private final Location myLocation;
    private final List<XNamedValue> myVariables;

    public StackFrameItem(@NotNull Location location, List<XNamedValue> variables) {
        if (location == null) {
            StackFrameItem.$$$reportNull$$$0(0);
        }
        this.myLocation = location;
        this.myVariables = variables;
    }

    public Location location() {
        return this.myLocation;
    }

    @NotNull
    public String path() {
        String string = this.myLocation.declaringType().name();
        if (string == null) {
            StackFrameItem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String method() {
        String string = this.myLocation.method().name();
        if (string == null) {
            StackFrameItem.$$$reportNull$$$0(2);
        }
        return string;
    }

    public int line() {
        return DebuggerUtilsEx.getLineNumber(this.myLocation, false);
    }

    @NotNull
    public static List<StackFrameItem> createFrames(@NotNull SuspendContextImpl suspendContext, boolean withVars) throws EvaluateException {
        ThreadReferenceProxyImpl threadReferenceProxy;
        if (suspendContext == null) {
            StackFrameItem.$$$reportNull$$$0(3);
        }
        if ((threadReferenceProxy = suspendContext.getThread()) != null) {
            List<StackFrameProxyImpl> frameProxies = threadReferenceProxy.forceFrames();
            ArrayList<StackFrameItem> res = new ArrayList<StackFrameItem>(frameProxies.size());
            for (StackFrameProxyImpl frame : frameProxies) {
                try {
                    Location location;
                    List<XNamedValue> vars;
                    block24: {
                        vars = null;
                        location = frame.location();
                        Method method = location.method();
                        if (withVars) {
                            if (!DebuggerSettings.getInstance().CAPTURE_VARIABLES) {
                                vars = VARS_CAPTURE_DISABLED;
                            } else if (method.isNative() || method.isBridge() || DebuggerUtils.isSynthetic((TypeComponent)method)) {
                                vars = VARS_NOT_CAPTURED;
                            } else {
                                vars = new ArrayList<XNamedValue>();
                                try {
                                    ObjectReference thisObject = frame.thisObject();
                                    if (thisObject != null) {
                                        vars.add(StackFrameItem.createVariable(thisObject, "this", VariableItem.VarType.OBJECT));
                                    }
                                }
                                catch (EvaluateException e) {
                                    LOG.debug((Throwable)e);
                                }
                                try {
                                    for (LocalVariableProxyImpl localVariableProxyImpl : frame.visibleVariables()) {
                                        try {
                                            VariableItem.VarType varType = localVariableProxyImpl.getVariable().isArgument() ? VariableItem.VarType.PARAM : VariableItem.VarType.OBJECT;
                                            vars.add(StackFrameItem.createVariable(frame.getValue(localVariableProxyImpl), localVariableProxyImpl.name(), varType));
                                        }
                                        catch (EvaluateException e) {
                                            LOG.debug((Throwable)e);
                                        }
                                    }
                                }
                                catch (EvaluateException e) {
                                    if (e.getCause() instanceof AbsentInformationException) {
                                        vars.add(JavaStackFrame.LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE);
                                        try {
                                            for (Map.Entry<DecompiledLocalVariable, Value> entry : LocalVariablesUtil.fetchValues(frame, suspendContext.getDebugProcess(), false).entrySet()) {
                                                vars.add(StackFrameItem.createVariable(entry.getValue(), entry.getKey().getDisplayName(), VariableItem.VarType.PARAM));
                                            }
                                        }
                                        catch (Exception exception) {
                                            LOG.info((Throwable)exception);
                                            break block24;
                                        }
                                    }
                                    LOG.debug((Throwable)e);
                                }
                            }
                        }
                    }
                    StackFrameItem frameItem = new StackFrameItem(location, vars);
                    res.add(frameItem);
                    List<StackFrameItem> list = StackCapturingLineBreakpoint.getRelatedStack(frame, suspendContext);
                    if (ContainerUtil.isEmpty(list)) continue;
                    res.add(null);
                    res.addAll(list);
                    break;
                }
                catch (EvaluateException e) {
                    LOG.debug((Throwable)e);
                }
            }
            ArrayList<StackFrameItem> arrayList = res;
            if (arrayList == null) {
                StackFrameItem.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        List<StackFrameItem> list = Collections.emptyList();
        if (list == null) {
            StackFrameItem.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static VariableItem createVariable(Value value2, String name2, VariableItem.VarType varType) {
        String type2 = null;
        String valueText = "null";
        if (value2 instanceof ObjectReference) {
            valueText = value2 instanceof StringReference ? ((StringReference)value2).value() : "";
            type2 = value2.type().name() + "@" + ((ObjectReference)value2).uniqueID();
        } else if (value2 != null) {
            valueText = value2.toString();
        }
        return new VariableItem(name2, type2, valueText, varType);
    }

    public String toString() {
        return this.myLocation.toString();
    }

    public XStackFrame createFrame(DebugProcessImpl debugProcess) {
        return new CapturedStackFrame(debugProcess, this);
    }

    public static void setWithSeparator(XStackFrame frame, boolean withSeparator) {
        if (frame instanceof CapturedStackFrame) {
            ((CapturedStackFrame)frame).setWithSeparator(withSeparator);
        }
    }

    public static String getAsyncStacktraceMessage() {
        return JavaDebuggerBundle.message((String)"frame.panel.async.stacktrace", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/utils/StackFrameItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/utils/StackFrameItem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "path";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "method";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFrames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CapturedStackFrame
    extends XStackFrame
    implements JVMStackFrameInfoProvider,
    XDebuggerFramesList.ItemWithSeparatorAbove {
        private final XSourcePosition mySourcePosition;
        private final boolean myIsSynthetic;
        private final boolean myIsInLibraryContent;
        private final String myPath;
        private final String myMethodName;
        private final int myLineNumber;
        private final List<XNamedValue> myVariables;
        private volatile boolean myWithSeparator;

        public CapturedStackFrame(DebugProcessImpl debugProcess, StackFrameItem item) {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.myPath = item.path();
            this.myMethodName = item.method();
            this.myLineNumber = item.line();
            this.myVariables = item.myVariables;
            Location location = item.myLocation;
            this.mySourcePosition = DebuggerUtilsEx.toXSourcePosition(debugProcess.getPositionManager().getSourcePosition(location));
            this.myIsSynthetic = DebuggerUtils.isSynthetic((TypeComponent)location.method());
            this.myIsInLibraryContent = DebuggerUtilsEx.isInLibraryContent(this.mySourcePosition != null ? this.mySourcePosition.getFile() : null, debugProcess.getProject());
        }

        @Nullable
        public XSourcePosition getSourcePosition() {
            return this.mySourcePosition;
        }

        @Override
        public boolean isSynthetic() {
            return this.myIsSynthetic;
        }

        @Override
        public boolean isInLibraryContent() {
            return this.myIsInLibraryContent;
        }

        public void customizePresentation(@NotNull ColoredTextContainer component) {
            if (component == null) {
                CapturedStackFrame.$$$reportNull$$$0(0);
            }
            component.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)6)));
            component.append(String.format("%s:%d", this.myMethodName, this.myLineNumber), this.getAttributes());
            ThreadsViewSettings settings = ThreadsViewSettings.getInstance();
            if (settings.SHOW_CLASS_NAME) {
                component.append(String.format(", %s", StringUtil.getShortName((String)this.myPath)), this.getAttributes());
                String packageName = StringUtil.getPackageName((String)this.myPath);
                if (settings.SHOW_PACKAGE_NAME && !packageName.trim().isEmpty()) {
                    component.append(String.format(" (%s)", packageName), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                }
            }
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                CapturedStackFrame.$$$reportNull$$$0(1);
            }
            XValueChildrenList children = XValueChildrenList.EMPTY;
            if (this.myVariables == VARS_CAPTURE_DISABLED) {
                node.setMessage(JavaDebuggerBundle.message((String)"message.node.local.variables.capture.disabled", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, CAPTURE_SETTINGS_OPENER);
            } else if (this.myVariables != null) {
                children = new XValueChildrenList(this.myVariables.size());
                this.myVariables.forEach(arg_0 -> ((XValueChildrenList)children).add(arg_0));
            }
            node.addChildren(children, true);
        }

        private SimpleTextAttributes getAttributes() {
            if (this.isSynthetic() || this.isInLibraryContent()) {
                return SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }

        public String getCaptionAboveOf() {
            return StackFrameItem.getAsyncStacktraceMessage();
        }

        public boolean hasSeparatorAbove() {
            return this.myWithSeparator;
        }

        public void setWithSeparator(boolean withSeparator) {
            this.myWithSeparator = withSeparator;
        }

        public String toString() {
            if (this.mySourcePosition != null) {
                return this.mySourcePosition.getFile().getName() + ":" + (this.mySourcePosition.getLine() + 1);
            }
            return "<position unknown>";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/utils/StackFrameItem$CapturedStackFrame";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizePresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableItem
    extends XNamedValue {
        private final String myType;
        private final String myValue;
        private final VarType myVarType;

        VariableItem(String name2, String type2, String value2, VarType varType) {
            super(name2);
            this.myType = type2;
            this.myValue = value2;
            this.myVarType = varType;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Icon icon;
            if (node == null) {
                VariableItem.$$$reportNull$$$0(0);
            }
            if (place == null) {
                VariableItem.$$$reportNull$$$0(1);
            }
            final ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
            final String type2 = Registry.is((String)"debugger.showTypes") ? classRenderer.renderTypeName(this.myType) : null;
            Icon icon2 = icon = this.myVarType == VarType.PARAM ? PlatformIcons.PARAMETER_ICON : AllIcons.Debugger.Value;
            if (this.myType != null && this.myType.startsWith("java.lang.String@")) {
                node.setPresentation(icon, (XValuePresentation)new XStringValuePresentation(this.myValue){

                    @Nullable
                    public String getType() {
                        return classRenderer.SHOW_STRINGS_TYPE ? type2 : null;
                    }
                }, false);
                return;
            }
            node.setPresentation(icon, type2, this.myValue, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/memory/utils/StackFrameItem$VariableItem";
            objectArray[2] = "computePresentation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static enum VarType {
            PARAM,
            OBJECT;

        }
    }
}

