/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.settings.DataBinding;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NonNls;

public abstract class FieldDataBinding
implements DataBinding {
    private final String myFieldName;

    protected FieldDataBinding(@NonNls String fieldName) {
        this.myFieldName = fieldName;
    }

    @Override
    public final void loadData(Object from) {
        try {
            Field field = this.findField(from);
            this.doLoadData(from, field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public final void saveData(Object to) {
        try {
            Field field = this.findField(to);
            this.doSaveData(to, field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isModified(Object obj) {
        try {
            Field field = this.findField(obj);
            return this.isModified(obj, field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected abstract void doLoadData(Object var1, Field var2) throws IllegalAccessException;

    protected abstract void doSaveData(Object var1, Field var2) throws IllegalAccessException;

    protected abstract boolean isModified(Object var1, Field var2) throws IllegalAccessException;

    private Field findField(Object from) {
        try {
            return ReflectionUtil.findField(from.getClass(), null, (String)this.myFieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(JavaDebuggerBundle.message((String)"error.field.not.found.in.class", (Object[])new Object[]{this.myFieldName, from.getClass().getName()}));
        }
    }
}

