/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Value;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public abstract class CompilingEvaluator
implements ExpressionEvaluator {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final PsiElement myPsiContext;
    @NotNull
    protected final ExtractLightMethodObjectHandler.ExtractedData myData;
    private static final String GEN_CLASS_NAME = "GeneratedEvaluationClass";

    public CompilingEvaluator(@NotNull Project project, @NotNull PsiElement context, @NotNull ExtractLightMethodObjectHandler.ExtractedData data) {
        if (project == null) {
            CompilingEvaluator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CompilingEvaluator.$$$reportNull$$$0(1);
        }
        if (data == null) {
            CompilingEvaluator.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myPsiContext = context;
        this.myData = data;
    }

    public Modifier getModifier() {
        return null;
    }

    private TextWithImports getCallCode() {
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, this.myData.getGeneratedCallText());
    }

    public Value evaluate(EvaluationContext evaluationContext) throws EvaluateException {
        DebugProcess process2 = evaluationContext.getDebugProcess();
        EvaluationContextImpl autoLoadContext = ((EvaluationContextImpl)evaluationContext).withAutoLoadClasses(true);
        ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(autoLoadContext, process2);
        autoLoadContext.setClassLoader(classLoader);
        JavaSdkVersion version = JavaSdkVersion.fromVersionString((String)((VirtualMachineProxyImpl)process2.getVirtualMachineProxy()).version());
        Collection<ClassObject> classes2 = this.compile(version);
        this.defineClasses(classes2, autoLoadContext, process2, classLoader);
        try {
            ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, new EvaluatingComputable<ExpressionEvaluator>(){

                @Override
                public ExpressionEvaluator compute() throws EvaluateException {
                    TextWithImports callCode = CompilingEvaluator.this.getCallCode();
                    PsiElement copyContext = CompilingEvaluator.this.myData.getAnchor();
                    CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(callCode, copyContext);
                    return factory.getEvaluatorBuilder().build((PsiElement)factory.createCodeFragment(callCode, copyContext, CompilingEvaluator.this.myProject), SourcePosition.createFromElement((PsiElement)copyContext));
                }
            });
            return evaluator.evaluate((EvaluationContext)autoLoadContext);
        }
        catch (Exception e) {
            throw new EvaluateException("Error during generated code invocation " + e, (Throwable)e);
        }
    }

    private void defineClasses(Collection<ClassObject> classes2, EvaluationContext context, DebugProcess process2, ClassLoaderReference classLoader) throws EvaluateException {
        boolean useMagicAccessorImpl = this.myData.useMagicAccessor();
        for (ClassObject cls : classes2) {
            byte[] bytes;
            if (!cls.getPath().contains(GEN_CLASS_NAME) || (bytes = cls.getContent()) == null) continue;
            if (useMagicAccessorImpl) {
                bytes = CompilingEvaluator.changeSuperToMagicAccessor(bytes);
            }
            ClassLoadingUtils.defineClass(cls.getClassName(), bytes, context, process2, classLoader);
        }
        process2.findClass(context, this.getGenClassQName(), classLoader);
    }

    private static byte[] changeSuperToMagicAccessor(byte[] bytes) {
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(524288, (ClassVisitor)classWriter){

            public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
                if ("java/lang/Object".equals(superName)) {
                    superName = "sun/reflect/MagicAccessorImpl";
                }
                super.visit(version, access, name2, signature, superName, interfaces);
            }
        };
        new ClassReader(bytes).accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    @NotNull
    public static String getGeneratedClassName() {
        return GEN_CLASS_NAME;
    }

    protected String getGenClassQName() {
        return (String)ReadAction.compute(() -> JVMNameUtil.getNonAnonymousClassName(this.myData.getGeneratedInnerClass()));
    }

    @NotNull
    protected abstract Collection<ClassObject> compile(@Nullable JavaSdkVersion var1) throws EvaluateException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

