/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.debugger.BatchEvaluatorServer;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class BatchEvaluator {
    private static final Logger LOG = Logger.getInstance(BatchEvaluator.class);
    private final DebugProcess myDebugProcess;
    private boolean myBatchEvaluatorChecked;
    private ClassType myBatchEvaluatorClass;
    private Method myBatchEvaluatorMethod;
    private static final Key<BatchEvaluator> BATCH_EVALUATOR_KEY = new Key("BatchEvaluator");
    public static final Key<Boolean> REMOTE_SESSION_KEY = new Key("is_remote_session_key");
    private final HashMap<SuspendContext, List<ToStringCommand>> myBuffer = new HashMap();

    private BatchEvaluator(DebugProcess process2) {
        this.myDebugProcess = process2;
        this.myDebugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(@NotNull DebugProcess process2, boolean closedByUser) {
                if (process2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                BatchEvaluator.this.myBatchEvaluatorChecked = false;
                BatchEvaluator.this.myBatchEvaluatorClass = null;
                BatchEvaluator.this.myBatchEvaluatorMethod = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/debugger/ui/tree/render/BatchEvaluator$1", "processDetached"));
            }
        });
    }

    public boolean hasBatchEvaluator(EvaluationContext evaluationContext) {
        if (!this.myBatchEvaluatorChecked) {
            this.myBatchEvaluatorChecked = true;
            if (DebuggerUtilsImpl.isRemote(this.myDebugProcess)) {
                return false;
            }
            ThreadReferenceProxy thread = evaluationContext.getSuspendContext().getThread();
            if (thread == null) {
                return false;
            }
            ThreadReference threadReference = thread.getThreadReference();
            if (threadReference == null) {
                return false;
            }
            try {
                this.myBatchEvaluatorClass = (ClassType)this.myDebugProcess.findClass(evaluationContext, BatchEvaluatorServer.class.getName(), evaluationContext.getClassLoader());
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
            if (this.myBatchEvaluatorClass != null) {
                this.myBatchEvaluatorMethod = DebuggerUtils.findMethod((ReferenceType)this.myBatchEvaluatorClass, (String)"evaluate", (String)"([Ljava/lang/Object;)Ljava/lang/String;");
            }
        }
        return this.myBatchEvaluatorMethod != null;
    }

    public void invoke(ToStringCommand command) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        final EvaluationContext evaluationContext = command.getEvaluationContext();
        final SuspendContext suspendContext = evaluationContext.getSuspendContext();
        if (!(Registry.is((String)"debugger.batch.evaluation.force") || Registry.is((String)"debugger.batch.evaluation") && this.hasBatchEvaluator(evaluationContext))) {
            this.myDebugProcess.getManagerThread().invokeCommand((DebuggerCommand)command);
        } else {
            List<ToStringCommand> toStringCommands = this.myBuffer.get(suspendContext);
            if (toStringCommands == null) {
                final ArrayList<ToStringCommand> commands = new ArrayList<ToStringCommand>();
                toStringCommands = commands;
                this.myBuffer.put(suspendContext, commands);
                this.myDebugProcess.getManagerThread().invokeCommand((DebuggerCommand)new SuspendContextCommand(){

                    public SuspendContext getSuspendContext() {
                        return suspendContext;
                    }

                    public void action() {
                        BatchEvaluator.this.myBuffer.remove(suspendContext);
                        if (commands.size() == 1 && !Registry.is((String)"debugger.batch.evaluation.force") || !BatchEvaluator.this.doEvaluateBatch(commands, evaluationContext)) {
                            commands.forEach(ToStringCommand::action);
                        }
                    }

                    public void commandCancelled() {
                        BatchEvaluator.this.myBuffer.remove(suspendContext);
                    }
                });
            }
            toStringCommands.add(command);
        }
    }

    public static BatchEvaluator getBatchEvaluator(DebugProcess debugProcess) {
        BatchEvaluator batchEvaluator = (BatchEvaluator)debugProcess.getUserData(BATCH_EVALUATOR_KEY);
        if (batchEvaluator == null) {
            batchEvaluator = new BatchEvaluator(debugProcess);
            debugProcess.putUserData(BATCH_EVALUATOR_KEY, (Object)batchEvaluator);
        }
        return batchEvaluator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doEvaluateBatch(List<ToStringCommand> requests, EvaluationContext evaluationContext) {
        try {
            if (!this.hasBatchEvaluator(evaluationContext)) {
                return false;
            }
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            List values = StreamEx.of(requests).map(ToStringCommand::getValue).toList();
            ArrayType objectArrayClass = (ArrayType)debugProcess.findClass(evaluationContext, "java.lang.Object[]", evaluationContext.getClassLoader());
            if (objectArrayClass == null) {
                return false;
            }
            ArrayReference argArray = DebuggerUtilsEx.mirrorOfArray(objectArrayClass, values.size(), evaluationContext);
            DebuggerUtilsEx.setValuesNoCheck(argArray, values);
            String value2 = (String)DebuggerUtils.processCollectibleValue(() -> ((DebugProcessImpl)debugProcess).invokeMethod(evaluationContext, this.myBatchEvaluatorClass, this.myBatchEvaluatorMethod, Collections.singletonList(argArray), 1024, true), result -> result instanceof StringReference ? ((StringReference)result).value() : null);
            if (value2 == null) return false;
            byte[] bytes = value2.getBytes(StandardCharsets.ISO_8859_1);
            try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));){
                int count = 0;
                while (dis.available() > 0) {
                    boolean error = dis.readBoolean();
                    String message2 = dis.readUTF();
                    if (count >= requests.size()) {
                        LOG.error("Invalid number of results: required " + requests.size() + ", reply = " + Arrays.toString(bytes));
                        boolean bl = false;
                        return bl;
                    }
                    ToStringCommand command = requests.get(count++);
                    if (error) {
                        command.evaluationError(JavaDebuggerBundle.message((String)"evaluation.error.method.exception", (Object[])new Object[]{message2}));
                        continue;
                    }
                    command.evaluationResult(message2);
                }
                return true;
            }
            catch (IOException e) {
                LOG.error("Failed to read batch response", (Throwable)e, new String[]{"reply was " + Arrays.toString(bytes)});
                return false;
            }
        }
        catch (EvaluateException | ClassNotLoadedException | InvalidTypeException | ObjectCollectedException e) {
            LOG.debug(e);
        }
        return false;
    }
}

