/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BasicRendererProperties;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeRendererImpl
implements NodeRenderer {
    public static final String DEFAULT_NAME = "unnamed";
    protected BasicRendererProperties myProperties;
    private final String myDefaultName;
    private Function<Type, CompletableFuture<Boolean>> myIsApplicableChecker;
    private static final String DEPRECATED_VALUE = "DEPRECATED_VALUE";

    protected NodeRendererImpl() {
        this(DEFAULT_NAME, false);
    }

    protected NodeRendererImpl(@NotNull String presentableName) {
        if (presentableName == null) {
            NodeRendererImpl.$$$reportNull$$$0(0);
        }
        this(presentableName, false);
    }

    protected NodeRendererImpl(@NotNull String presentableName, boolean enabledDefaultValue) {
        if (presentableName == null) {
            NodeRendererImpl.$$$reportNull$$$0(1);
        }
        this.myIsApplicableChecker = null;
        this.myDefaultName = presentableName;
        this.myProperties = new BasicRendererProperties(enabledDefaultValue);
        this.myProperties.setName(presentableName);
        this.myProperties.setEnabled(enabledDefaultValue);
    }

    @Override
    public String getName() {
        return this.myProperties.getName();
    }

    @Override
    public void setName(String name2) {
        this.myProperties.setName(name2);
    }

    @Override
    public boolean isEnabled() {
        return this.myProperties.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myProperties.setEnabled(enabled);
    }

    public boolean isShowType() {
        return this.myProperties.isShowType();
    }

    public void setShowType(boolean showType) {
        this.myProperties.setShowType(showType);
    }

    @Override
    public void buildChildren(Value value2, ChildrenBuilder builder, EvaluationContext evaluationContext) {
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return null;
    }

    @ApiStatus.Internal
    public void setIsApplicableChecker(@NotNull Function<Type, CompletableFuture<Boolean>> isApplicableAsync) {
        if (isApplicableAsync == null) {
            NodeRendererImpl.$$$reportNull$$$0(2);
        }
        this.myIsApplicableChecker = isApplicableAsync;
    }

    @Override
    public final CompletableFuture<Boolean> isApplicableAsync(Type type2) {
        if (this.myIsApplicableChecker != null) {
            return this.myIsApplicableChecker.apply(type2);
        }
        return NodeRenderer.super.isApplicableAsync(type2);
    }

    @Override
    public boolean isExpandable(Value value2, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return false;
    }

    @Override
    public NodeRendererImpl clone() {
        try {
            NodeRendererImpl cloned = (NodeRendererImpl)super.clone();
            cloned.myProperties = this.myProperties.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void readExternal(Element element) {
        this.myProperties.readExternal(element, this.myDefaultName);
    }

    public void writeExternal(Element element) {
        this.myProperties.writeExternal(element, this.myDefaultName);
    }

    public String toString() {
        return this.getName();
    }

    @Deprecated
    @Nullable
    public String getIdLabel(Value value2, DebugProcess process2) {
        return DEPRECATED_VALUE;
    }

    @Nullable
    public String calcIdLabel(ValueDescriptor descriptor, DebugProcess process2, DescriptorLabelListener labelListener) {
        Value value2 = descriptor.getValue();
        String id = this.getIdLabel(value2, process2);
        if (DEPRECATED_VALUE != id) {
            return id;
        }
        if (!(value2 instanceof ObjectReference) || !this.isShowType()) {
            return null;
        }
        return ValueDescriptorImpl.calcIdLabel(descriptor, labelListener);
    }

    public boolean hasOverhead() {
        return false;
    }

    public static String calcLabel(CompletableFuture<NodeRenderer> renderer, ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) {
        return ((CompletableFuture)renderer.thenApply(r -> {
            try {
                return r.calcLabel(descriptor, evaluationContext, listener);
            }
            catch (EvaluateException e) {
                descriptor.setValueLabelFailed(e);
                listener.labelChanged();
                return "";
            }
        })).getNow(XDebuggerUIConstants.getCollectingDataMessage());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isApplicableAsync";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/tree/render/NodeRendererImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setIsApplicableChecker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Overhead
    implements OverheadProducer {
        private final NodeRendererImpl myRenderer;

        public Overhead(@NotNull NodeRendererImpl renderer) {
            if (renderer == null) {
                Overhead.$$$reportNull$$$0(0);
            }
            this.myRenderer = renderer;
        }

        @Override
        public boolean isEnabled() {
            return this.myRenderer.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myRenderer.setEnabled(enabled);
            NodeRendererSettings.getInstance().fireRenderersChanged();
        }

        @Override
        public void customizeRenderer(SimpleColoredComponent renderer) {
            renderer.append(this.myRenderer.getName() + " renderer");
        }

        public int hashCode() {
            return this.myRenderer.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Overhead && this.myRenderer.equals(((Overhead)obj).myRenderer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/debugger/ui/tree/render/NodeRendererImpl$Overhead", "<init>"));
        }
    }
}

