/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class UnboxableTypeRenderer
extends CompoundRendererProvider {
    private static final Logger LOG = Logger.getInstance(UnboxableTypeRenderer.class);
    private final String myClassName;

    protected UnboxableTypeRenderer(String className2) {
        LOG.assertTrue(UnBoxingEvaluator.isTypeUnboxable(className2));
        this.myClassName = className2;
    }

    @Override
    protected String getName() {
        return StringUtil.getShortName((String)this.myClassName);
    }

    @Override
    protected ValueLabelRenderer getValueLabelRenderer() {
        return new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
                CompletableFuture<PrimitiveValue> future = UnBoxingEvaluator.getInnerPrimitiveValue((ObjectReference)descriptor.getValue(), false);
                if (future.isDone()) {
                    return DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)future.join());
                }
                return ((CompletableFuture)future.handle((r, ex) -> {
                    String res = "";
                    if (ex == null) {
                        try {
                            res = DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)r);
                            descriptor.setValueLabel(res);
                        }
                        catch (EvaluateException e) {
                            descriptor.setValueLabelFailed(e);
                        }
                    } else {
                        descriptor.setValueLabelFailed(new EvaluateException(null, ex));
                    }
                    labelListener.labelChanged();
                    return res;
                })).getNow(XDebuggerUIConstants.getCollectingDataMessage());
            }

            @Override
            public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
                return false;
            }
        };
    }

    @Override
    protected Function<Type, CompletableFuture<Boolean>> getIsApplicableChecker() {
        return type2 -> CompletableFuture.completedFuture(type2 instanceof ReferenceType && StringUtil.equals((CharSequence)type2.name(), (CharSequence)this.myClassName));
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    public static class DoubleRenderer
    extends UnboxableTypeRenderer {
        public DoubleRenderer() {
            super("java.lang.Double");
        }
    }

    public static class FloatRenderer
    extends UnboxableTypeRenderer {
        public FloatRenderer() {
            super("java.lang.Float");
        }
    }

    public static class LongRenderer
    extends UnboxableTypeRenderer {
        public LongRenderer() {
            super("java.lang.Long");
        }
    }

    public static class IntegerRenderer
    extends UnboxableTypeRenderer {
        public IntegerRenderer() {
            super("java.lang.Integer");
        }
    }

    public static class ShortRenderer
    extends UnboxableTypeRenderer {
        public ShortRenderer() {
            super("java.lang.Short");
        }
    }

    public static class CharacterRenderer
    extends UnboxableTypeRenderer {
        public CharacterRenderer() {
            super("java.lang.Character");
        }
    }

    public static class ByteRenderer
    extends UnboxableTypeRenderer {
        public ByteRenderer() {
            super("java.lang.Byte");
        }
    }

    public static class BooleanRenderer
    extends UnboxableTypeRenderer {
        public BooleanRenderer() {
            super("java.lang.Boolean");
        }
    }
}

