/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MorphingAction
extends AnAction {
    private final DesignerEditorPanel myDesigner;
    private final EditableArea myArea;
    private final List<? extends RadComponent> myComponents;
    private final MetaModel myTarget;

    public MorphingAction(DesignerEditorPanel designer, EditableArea area, List<? extends RadComponent> components, MetaModel target) {
        super(target.getTag(), null, target.getIcon());
        this.myDesigner = designer;
        this.myArea = area;
        this.myComponents = components;
        this.myTarget = target;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MorphingAction.$$$reportNull$$$0(0);
        }
        PaletteItem paletteItem = this.myTarget.getPaletteItem();
        e.getPresentation().setEnabled(paletteItem == null || paletteItem.isEnabled());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MorphingAction.$$$reportNull$$$0(1);
        }
        this.myDesigner.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            ArrayList<RadComponent> newComponents = new ArrayList<RadComponent>();
            for (RadComponent radComponent : this.myComponents) {
                RadComponent newComponent = radComponent.morphingTo(this.myTarget);
                if (newComponent == null) continue;
                newComponents.add(newComponent);
            }
            this.myArea.setSelection(newComponents);
        }), "Run Morphing action", true);
    }

    public static void fill(DesignerEditorPanel designer, DefaultActionGroup group, EditableArea area) {
        List<RadComponent> selection = area.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        MetaModel model = null;
        for (RadComponent component : selection) {
            if (model == null) {
                model = component.getMetaModel();
                continue;
            }
            if (model == component.getMetaModel()) continue;
            return;
        }
        if (model == null) {
            return;
        }
        List<MetaModel> models = model.getMorphingModels();
        if (models.isEmpty()) {
            return;
        }
        DefaultActionGroup morphingGroup = DefaultActionGroup.createPopupGroup(() -> "Morphing");
        for (MetaModel morphingModel : models) {
            morphingGroup.add((AnAction)new MorphingAction(designer, area, selection, morphingModel));
        }
        group.add((AnAction)morphingGroup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/designer/actions/MorphingAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

