/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.actions.CommonEditActionsProvider;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.ComponentEditableArea;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.EmptyComponentDecorator;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.GlassLayer;
import com.intellij.designer.designSurface.ICaption;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.FindComponentVisitor;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadVisualComponent;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLayeredPane;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptionPanel
extends JBLayeredPane
implements DataProvider,
DeleteProvider {
    private static final int SIZE = 16;
    private final boolean myHorizontal;
    private final EditableArea myMainArea;
    private final EditableArea myArea;
    private final DecorationLayer myDecorationLayer;
    private final FeedbackLayer myFeedbackLayer;
    private DefaultActionGroup myActionGroup;
    private final CommonEditActionsProvider myActionsProvider;
    private final RadVisualComponent myRootComponent;
    private List<RadComponent> myRootChildren = Collections.emptyList();
    private ICaption myCaption;

    public CaptionPanel(DesignerEditorPanel designer, boolean horizontal, boolean addBorder) {
        if (addBorder) {
            this.setBorder(IdeBorderFactory.createBorder((int)(horizontal ? 8 : 4)));
        }
        this.setFocusable(true);
        this.myHorizontal = horizontal;
        this.myMainArea = designer.getSurfaceArea();
        this.myRootComponent = new RadVisualComponent(){

            @Override
            public List<RadComponent> getChildren() {
                return CaptionPanel.this.myRootChildren;
            }

            @Override
            public boolean canDelete() {
                return false;
            }
        };
        this.myRootComponent.setNativeComponent((Component)((Object)this));
        if (horizontal) {
            this.myRootComponent.setBounds(0, 0, 100000, 16);
        } else {
            this.myRootComponent.setBounds(0, 0, 16, 100000);
        }
        this.myArea = new ComponentEditableArea((JComponent)((Object)this)){

            @Override
            protected void fireSelectionChanged() {
                super.fireSelectionChanged();
                CaptionPanel.this.revalidate();
                CaptionPanel.this.repaint();
            }

            @Override
            public RadComponent findTarget(int x, int y, @Nullable ComponentTargetFilter filter) {
                FindComponentVisitor visitor2 = new FindComponentVisitor((JComponent)((Object)CaptionPanel.this), filter, x, y);
                CaptionPanel.this.myRootComponent.accept(visitor2, false);
                return visitor2.getResult();
            }

            @Override
            public InputTool findTargetTool(int x, int y) {
                return CaptionPanel.this.myDecorationLayer.findTargetTool(x, y);
            }

            @Override
            public void showSelection(boolean value2) {
                CaptionPanel.this.myDecorationLayer.showSelection(value2);
            }

            @Override
            public ComponentDecorator getRootSelectionDecorator() {
                return EmptyComponentDecorator.INSTANCE;
            }

            @Override
            public EditOperation processRootOperation(OperationContext context) {
                return null;
            }

            @Override
            public FeedbackLayer getFeedbackLayer() {
                return CaptionPanel.this.myFeedbackLayer;
            }

            @Override
            public RadComponent getRootComponent() {
                return CaptionPanel.this.myRootComponent;
            }

            @Override
            public ActionGroup getPopupActions() {
                if (CaptionPanel.this.myActionGroup == null) {
                    CaptionPanel.this.myActionGroup = new DefaultActionGroup();
                    CaptionPanel.this.myActionGroup.add(ActionManager.getInstance().getAction("$Delete"));
                }
                return CaptionPanel.this.myActionGroup;
            }

            @Override
            public String getPopupPlace() {
                return "UIDesigner.CaptionPanel";
            }
        };
        this.add(new GlassLayer(designer.getToolProvider(), this.myArea), DesignerEditorPanel.LAYER_GLASS);
        this.myDecorationLayer = new DecorationLayer(designer, this.myArea);
        this.add(this.myDecorationLayer, DesignerEditorPanel.LAYER_DECORATION);
        this.myFeedbackLayer = new FeedbackLayer(designer);
        this.add(this.myFeedbackLayer, DesignerEditorPanel.LAYER_FEEDBACK);
        this.myActionsProvider = new CommonEditActionsProvider(designer){

            @Override
            protected EditableArea getArea(DataContext dataContext) {
                return CaptionPanel.this.myArea;
            }
        };
        this.myMainArea.addSelectionListener(new ComponentSelectionListener(){

            @Override
            public void selectionChanged(EditableArea area) {
                CaptionPanel.this.update();
            }
        });
    }

    public void attachToScrollPane(JScrollPane scrollPane) {
        scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CaptionPanel.this.repaint();
            }
        });
    }

    public void doLayout() {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            component.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CaptionPanel.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CaptionPanel.$$$reportNull$$$0(1);
        }
        return this.myActionsProvider.canDeleteElement(dataContext);
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CaptionPanel.$$$reportNull$$$0(2);
        }
        this.myActionsProvider.deleteElement(dataContext);
    }

    public void update() {
        RadComponent component2;
        List<RadComponent> selection = this.myMainArea.getSelection();
        if (selection.size() != 1) {
            if (this.myCaption != null) {
                this.myCaption = null;
                this.myRootComponent.setLayout(null);
                this.myRootChildren = Collections.emptyList();
                this.myArea.deselectAll();
                this.revalidate();
                this.repaint();
            }
            return;
        }
        boolean update2 = !this.myRootChildren.isEmpty();
        IntArrayList oldSelection = null;
        if (this.myCaption != null) {
            oldSelection = new IntArrayList();
            for (RadComponent component2 : this.myArea.getSelection()) {
                oldSelection.add(this.myRootChildren.indexOf((Object)component2));
            }
        }
        this.myArea.deselectAll();
        this.myRootComponent.setLayout(null);
        ICaption caption = null;
        component2 = selection.get(0);
        RadComponent parent = component2.getParent();
        if (parent != null) {
            caption = parent.getLayout().getCaption(component2);
        }
        if (caption == null) {
            caption = component2.getCaption();
        }
        if (caption == null) {
            this.myRootChildren = Collections.emptyList();
        } else {
            this.myRootComponent.setLayout(caption.getCaptionLayout(this.myMainArea, this.myHorizontal));
            this.myRootChildren = caption.getCaptionChildren(this.myMainArea, this.myHorizontal);
            for (RadComponent child : this.myRootChildren) {
                child.setParent(this.myRootComponent);
            }
            if (this.myCaption == caption) {
                ArrayList<RadComponent> newSelection = new ArrayList<RadComponent>();
                int componentSize = this.myRootChildren.size();
                int selectionSize = oldSelection.size();
                for (int i = 0; i < selectionSize; ++i) {
                    int index = oldSelection.getInt(i);
                    if (0 > index || index >= componentSize) continue;
                    newSelection.add(this.myRootChildren.get(index));
                }
                if (!newSelection.isEmpty()) {
                    this.myArea.setSelection(newSelection);
                }
            }
            update2 |= !this.myRootChildren.isEmpty();
        }
        this.myCaption = caption;
        if (update2) {
            this.revalidate();
            this.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/designer/designSurface/CaptionPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

