/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable;

import com.intellij.designer.inspection.AbstractQuickFixManager;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.propertyTable.PropertyTable;
import com.intellij.designer.propertyTable.RadPropertyTable;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public final class QuickFixManager
extends AbstractQuickFixManager
implements ListSelectionListener {
    public QuickFixManager(PropertyTable component, JViewport viewPort) {
        super(null, (JComponent)component, viewPort);
        component.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.hideHint();
        this.updateHintVisibility();
    }

    @Override
    @NotNull
    protected List<ErrorInfo> getErrorInfos() {
        RadPropertyTable component = (RadPropertyTable)((Object)this.myComponent);
        int selectedRow = component.getSelectedRow();
        if (selectedRow < 0 || selectedRow >= component.getRowCount()) {
            List<ErrorInfo> list = Collections.emptyList();
            if (list == null) {
                QuickFixManager.$$$reportNull$$$0(0);
            }
            return list;
        }
        ErrorInfo errorInfo = component.getErrorInfoForRow(selectedRow);
        if (errorInfo != null) {
            List<ErrorInfo> list = Collections.singletonList(errorInfo);
            if (list == null) {
                QuickFixManager.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<ErrorInfo> list = Collections.emptyList();
        if (list == null) {
            QuickFixManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected Rectangle getErrorBounds() {
        RadPropertyTable component = (RadPropertyTable)((Object)this.myComponent);
        int selectedRow = component.getSelectedRow();
        if (selectedRow < 0 || selectedRow >= component.getRowCount()) {
            return null;
        }
        Rectangle rowRect = component.getCellRect(selectedRow, 0, true);
        Rectangle visibleRect = this.myComponent.getVisibleRect();
        if (visibleRect.intersects(rowRect)) {
            return visibleRect.intersection(rowRect);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/propertyTable/QuickFixManager", "getErrorInfos"));
    }
}

