/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ConfigurationWithCommandLineShortener;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.ArgumentFileFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.testDiscovery.JavaAutoRunManager;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.autotest.AbstractAutoTestManager;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public abstract class JavaTestFrameworkRunnableState<T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element> & ConfigurationWithCommandLineShortener>
extends JavaCommandLineState
implements RemoteConnectionCreator {
    private static final Logger LOG = Logger.getInstance(JavaTestFrameworkRunnableState.class);
    private static final ExtensionPointName<JUnitPatcher> JUNIT_PATCHER_EP = new ExtensionPointName("com.intellij.junitPatcher");
    private static final String JIGSAW_OPTIONS = "Jigsaw Options";
    protected ServerSocket myServerSocket;
    protected File myTempFile;
    protected File myWorkingDirsFile = null;
    private RemoteConnectionCreator remoteConnectionCreator;
    private final List<ArgumentFileFilter> myArgumentFileFilters = new ArrayList<ArgumentFileFilter>();
    private ServerSocket myForkSocket = null;

    public static ParamsGroup getJigsawOptions(JavaParameters parameters2) {
        return parameters2.getVMParametersList().getParamsGroup(JIGSAW_OPTIONS);
    }

    public void setRemoteConnectionCreator(RemoteConnectionCreator remoteConnectionCreator) {
        this.remoteConnectionCreator = remoteConnectionCreator;
    }

    @Nullable
    public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
        return this.remoteConnectionCreator == null ? null : this.remoteConnectionCreator.createRemoteConnection(environment);
    }

    public boolean isPollConnection() {
        return this.remoteConnectionCreator != null && this.remoteConnectionCreator.isPollConnection();
    }

    public JavaTestFrameworkRunnableState(ExecutionEnvironment environment) {
        super(environment);
    }

    @NotNull
    protected abstract String getFrameworkName();

    @NotNull
    protected abstract String getFrameworkId();

    protected abstract void passTempFile(ParametersList var1, String var2);

    @NotNull
    protected abstract T getConfiguration();

    @Nullable
    protected abstract TestSearchScope getScope();

    @NotNull
    protected abstract String getForkMode();

    @NotNull
    protected OSProcessHandler createHandler(Executor executor) throws ExecutionException {
        this.appendForkInfo(executor);
        this.appendRepeatMode();
        TargetEnvironment remoteEnvironment = this.getEnvironment().getPreparedTargetEnvironment((RunProfileState)this, (ProgressIndicator)new EmptyProgressIndicator());
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.getTargetedCommandLine();
        TargetedCommandLine targetedCommandLine = targetedCommandLineBuilder.build();
        Process process2 = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        KillableColoredProcessHandler.Silent processHandler = new KillableColoredProcessHandler.Silent(process2, targetedCommandLine.getCommandPresentation(remoteEnvironment), targetedCommandLine.getCharset(), targetedCommandLineBuilder.getFilesToDeleteOnTermination());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        SearchForTestsTask searchForTestsTask = this.createSearchingForTestsTask();
        if (searchForTestsTask != null) {
            searchForTestsTask.attachTaskToProcess((OSProcessHandler)processHandler);
        }
        KillableColoredProcessHandler.Silent silent = processHandler;
        if (silent == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(0);
        }
        return silent;
    }

    public SearchForTestsTask createSearchingForTestsTask() throws ExecutionException {
        return null;
    }

    protected boolean configureByModule(Module module) {
        return module != null;
    }

    protected boolean isIdBasedTestTree() {
        return false;
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration) throws ExecutionException {
        Map content;
        if (request == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(1);
        }
        TargetedCommandLineBuilder commandLineBuilder = super.createTargetedCommandLine(request, configuration);
        File inputFile = InputRedirectAware.getInputFile(this.getConfiguration());
        if (inputFile != null) {
            commandLineBuilder.setInputFile(request.getDefaultVolume().createUpload(inputFile.getAbsolutePath()));
        }
        if ((content = (Map)commandLineBuilder.getUserData(JdkUtil.COMMAND_LINE_CONTENT)) != null) {
            content.forEach((key2, value2) -> this.myArgumentFileFilters.add(new ArgumentFileFilter(key2, value2)));
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = commandLineBuilder;
        if (targetedCommandLineBuilder == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(2);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(3);
        }
        if (runner == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(4);
        }
        RunnerSettings runnerSettings = this.getRunnerSettings();
        SMTRunnerConsoleProperties testConsoleProperties = ((SMRunnerConsolePropertiesProvider)this.getConfiguration()).createTestConsoleProperties(executor);
        testConsoleProperties.setIdBasedTestTree(this.isIdBasedTestTree());
        testConsoleProperties.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)this.getFrameworkName(), (TestConsoleProperties)testConsoleProperties);
        SMTestRunnerResultsForm viewer = ((SMTRunnerConsoleView)consoleView).getResultsViewer();
        Disposer.register((Disposable)this.getConfiguration().getProject(), (Disposable)consoleView);
        viewer.getTestsRootNode().setExecutionId(this.getEnvironment().getExecutionId());
        final OSProcessHandler handler = this.createHandler(executor);
        for (ArgumentFileFilter filter : this.myArgumentFileFilters) {
            consoleView.addMessageFilter((Filter)filter);
        }
        consoleView.attachToProcess((ProcessHandler)handler);
        final AbstractTestProxy root = viewer.getRoot();
        if (root instanceof TestProxyRoot) {
            ((TestProxyRoot)root).setHandler((ProcessHandler)handler);
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JavaTestFrameworkRunnableState.this.getConfiguration().isSaveOutputToFile()) {
                    File file = OutputFileUtil.getOutputFile(JavaTestFrameworkRunnableState.this.getConfiguration());
                    root.setOutputFilePath(file != null ? file.getAbsolutePath() : null);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                Runnable runnable = () -> {
                    root.flushOutputFile();
                    JavaTestFrameworkRunnableState.this.deleteTempFiles();
                    JavaTestFrameworkRunnableState.this.clear();
                };
                UIUtil.invokeLaterIfNeeded((Runnable)runnable);
                handler.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/JavaTestFrameworkRunnableState$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        AbstractRerunFailedTestsAction rerunFailedTestsAction = testConsoleProperties.createRerunFailedTestsAction((ConsoleView)consoleView);
        LOG.assertTrue(rerunFailedTestsAction != null);
        rerunFailedTestsAction.setModelProvider(() -> viewer);
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)handler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction, new ToggleAutoTestAction(){

            public boolean isDelayApplicable() {
                return false;
            }

            public AbstractAutoTestManager getAutoTestManager(Project project) {
                return JavaAutoRunManager.getInstance(project);
            }
        }});
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)handler, runnerSettings);
        DefaultExecutionResult defaultExecutionResult = result;
        if (defaultExecutionResult == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(5);
        }
        return defaultExecutionResult;
    }

    protected abstract void configureRTClasspath(JavaParameters var1, Module var2) throws CantRunException;

    protected Sdk getJdk() {
        Project project = this.getConfiguration().getProject();
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        return module == null ? ProjectRootManager.getInstance((Project)project).getProjectSdk() : ModuleRootManager.getInstance((Module)module).getSdk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = new JavaParameters();
        Project project = this.getConfiguration().getProject();
        Module module = ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule();
        javaParameters.setJdk(this.getJdk());
        String parameters2 = ((CommonProgramRunConfigurationParameters)this.getConfiguration()).getProgramParameters();
        ((CommonProgramRunConfigurationParameters)this.getConfiguration()).setProgramParameters(null);
        try {
            JavaParametersUtil.configureConfiguration((SimpleJavaParameters)javaParameters, (CommonJavaRunConfigurationParameters)this.getConfiguration());
        }
        finally {
            ((CommonProgramRunConfigurationParameters)this.getConfiguration()).setProgramParameters(parameters2);
        }
        this.configureClasspath(javaParameters);
        javaParameters.getClassPath().addFirst(JavaSdkUtil.getIdeaRtJarPath());
        for (JUnitPatcher patcher : JUNIT_PATCHER_EP.getExtensionList()) {
            patcher.patchJavaParameters(project, module, javaParameters);
        }
        for (RunConfigurationExtension ext : RunConfigurationExtension.EP_NAME.getExtensionList()) {
            ext.updateJavaParameters(this.getConfiguration(), javaParameters, this.getRunnerSettings(), this.getEnvironment().getExecutor());
        }
        if (!StringUtil.isEmptyOrSpaces((String)parameters2)) {
            javaParameters.getProgramParametersList().addAll(this.getNamedParams(parameters2));
        }
        if (ConsoleBuffer.useCycleBuffer()) {
            javaParameters.getVMParametersList().addProperty("idea.test.cyclic.buffer.size", String.valueOf(ConsoleBuffer.getCycleBufferSize()));
        }
        javaParameters.setShortenCommandLine(((ConfigurationWithCommandLineShortener)this.getConfiguration()).getShortenCommandLine(), project);
        return javaParameters;
    }

    protected List<String> getNamedParams(String parameters2) {
        return Collections.singletonList("@name" + parameters2);
    }

    @Nullable
    public ServerSocket getForkSocket() {
        if (this.myForkSocket == null && (!Comparing.strEqual((String)this.getForkMode(), (String)"none") || this.forkPerModule()) && this.getRunnerSettings() != null) {
            try {
                this.myForkSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.myForkSocket;
    }

    private boolean isExecutorDisabledInForkedMode() {
        RunnerSettings settings = this.getRunnerSettings();
        return settings != null && !(settings instanceof GenericDebuggerRunnerSettings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendForkInfo(Executor executor) throws ExecutionException {
        JavaParameters javaParameters;
        Sdk jdk;
        String forkMode = this.getForkMode();
        if (Comparing.strEqual((String)forkMode, (String)"none")) {
            if (!this.forkPerModule()) return;
            if (this.isExecutorDisabledInForkedMode()) {
                String actionName = executor.getActionName();
                throw new CantRunException("'" + actionName + "' is disabled when per-module working directory is configured.<br/>Please specify single working directory, or change test scope to single module.");
            }
        } else if (this.isExecutorDisabledInForkedMode()) {
            String actionName = executor.getActionName();
            throw new CantRunException(actionName + " is disabled in fork mode.<br/>Please change fork mode to &lt;none&gt; to " + StringUtil.toLowerCase((String)actionName) + ".");
        }
        if ((jdk = (javaParameters = this.getJavaParameters()).getJdk()) == null) {
            throw new ExecutionException(ExecutionBundle.message((String)"run.configuration.error.no.jdk.specified", (Object[])new Object[0]));
        }
        try {
            File tempFile = FileUtil.createTempFile((String)"command.line", (String)"", (boolean)true);
            try (PrintWriter writer = new PrintWriter(tempFile, "UTF-8");){
                boolean useDynamicClasspathForForkMode;
                ShortenCommandLine shortenCommandLine = ((ConfigurationWithCommandLineShortener)this.getConfiguration()).getShortenCommandLine();
                boolean bl = shortenCommandLine == null ? JdkUtil.useDynamicClasspath((Project)this.getConfiguration().getProject()) : (useDynamicClasspathForForkMode = shortenCommandLine != ShortenCommandLine.NONE);
                if (useDynamicClasspathForForkMode && this.forkPerModule()) {
                    writer.println("use classpath jar");
                } else {
                    writer.println("");
                }
                writer.println(((JavaSdkType)jdk.getSdkType()).getVMExecutablePath(jdk));
                for (String vmParameter : javaParameters.getVMParametersList().getList()) {
                    writer.println(vmParameter);
                }
            }
            this.passForkMode(this.getForkMode(), tempFile, javaParameters);
            return;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected abstract void passForkMode(String var1, File var2, JavaParameters var3) throws ExecutionException;

    protected void collectListeners(JavaParameters javaParameters, StringBuilder buf, String epName, String delimiter) {
        T configuration = this.getConfiguration();
        for (Object listener : Extensions.getRootArea().getExtensionPoint(epName).getExtensionList()) {
            boolean enabled = true;
            for (RunConfigurationExtension ext : RunConfigurationExtension.EP_NAME.getExtensionList()) {
                if (!ext.isListenerDisabled((RunConfigurationBase)configuration, listener, this.getRunnerSettings())) continue;
                enabled = false;
                break;
            }
            if (!enabled) continue;
            if (buf.length() > 0) {
                buf.append(delimiter);
            }
            Class<?> classListener = listener.getClass();
            buf.append(classListener.getName());
            javaParameters.getClassPath().add(PathUtil.getJarPathForClass(classListener));
        }
    }

    protected void configureClasspath(JavaParameters javaParameters) throws CantRunException {
        RunConfigurationModule configurationModule = this.getConfiguration().getConfigurationModule();
        String jreHome = ((CommonJavaRunConfigurationParameters)this.getConfiguration()).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)this.getConfiguration()).getAlternativeJrePath() : null;
        int pathType = 7;
        Module module = configurationModule.getModule();
        if (this.configureByModule(module)) {
            JavaParametersUtil.configureModule(configurationModule, javaParameters, 7, jreHome);
            LOG.assertTrue(module != null);
            if (JavaSdkUtil.isJdkAtLeast(javaParameters.getJdk(), JavaSdkVersion.JDK_1_9)) {
                this.configureModulePath(javaParameters, module);
            }
        } else {
            JavaParametersUtil.configureProject(this.getConfiguration().getProject(), javaParameters, 7, jreHome);
        }
        this.configureRTClasspath(javaParameters, module);
    }

    protected static PsiJavaModule findJavaModule(Module module, boolean inTests) {
        return (PsiJavaModule)DumbService.getInstance((Project)module.getProject()).computeWithAlternativeResolveEnabled(() -> JavaModuleGraphUtil.findDescriptorByModule(module, inTests));
    }

    private void configureModulePath(JavaParameters javaParameters, @NotNull Module module) {
        if (module == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(6);
        }
        if (!this.useModulePath()) {
            return;
        }
        PsiJavaModule testModule = JavaTestFrameworkRunnableState.findJavaModule(module, true);
        if (testModule != null) {
            ParametersList vmParametersList = javaParameters.getVMParametersList().addParamsGroup(JIGSAW_OPTIONS).getParametersList();
            vmParametersList.add("--add-modules");
            vmParametersList.add(testModule.getName());
            PathsList classPath = javaParameters.getClassPath();
            PathsList modulePath = javaParameters.getModulePath();
            modulePath.addAll(classPath.getPathList());
            classPath.clear();
        } else {
            PsiJavaModule prodModule = JavaTestFrameworkRunnableState.findJavaModule(module, false);
            if (prodModule != null) {
                this.splitDepsBetweenModuleAndClasspath(javaParameters, module, prodModule);
            }
        }
    }

    private void splitDepsBetweenModuleAndClasspath(JavaParameters javaParameters, Module module, PsiJavaModule prodModule) {
        CompilerModuleExtension compilerExt = CompilerModuleExtension.getInstance((Module)module);
        if (compilerExt == null) {
            return;
        }
        PathsList modulePath = javaParameters.getModulePath();
        PathsList classPath = javaParameters.getClassPath();
        JavaTestFrameworkRunnableState.putDependenciesOnModulePath(modulePath, classPath, prodModule);
        ParametersList vmParametersList = javaParameters.getVMParametersList().addParamsGroup(JIGSAW_OPTIONS).getParametersList();
        String prodModuleName = prodModule.getName();
        VirtualFile testOutput = compilerExt.getCompilerOutputPathForTests();
        if (testOutput != null) {
            vmParametersList.add("--patch-module");
            vmParametersList.add(prodModuleName + "=" + testOutput.getPath());
        }
        vmParametersList.add("--add-reads");
        vmParametersList.add(prodModuleName + "=ALL-UNNAMED");
        ArrayList<String> opensOptions = new ArrayList<String>();
        this.collectPackagesToOpen(opensOptions);
        for (String option : opensOptions) {
            if (option.isEmpty()) continue;
            vmParametersList.add("--add-opens");
            vmParametersList.add(prodModuleName + "/" + option + "=ALL-UNNAMED");
        }
        vmParametersList.add("--add-modules");
        vmParametersList.add(prodModuleName);
    }

    protected void collectPackagesToOpen(List<String> options) {
    }

    protected static void collectSubPackages(List<String> options, PsiPackage aPackage, GlobalSearchScope globalSearchScope) {
        PsiPackage[] subPackages;
        if (aPackage.getClasses(globalSearchScope).length > 0) {
            options.add(aPackage.getQualifiedName());
        }
        for (PsiPackage subPackage : subPackages = aPackage.getSubPackages(globalSearchScope)) {
            JavaTestFrameworkRunnableState.collectSubPackages(options, subPackage, globalSearchScope);
        }
    }

    protected static void putDependenciesOnModulePath(PathsList modulePath, PathsList classPath, PsiJavaModule prodModule) {
        Set<PsiJavaModule> allRequires = JavaModuleGraphUtil.getAllDependencies(prodModule);
        allRequires.add(prodModule);
        JarFileSystem jarFS = JarFileSystem.getInstance();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)prodModule.getProject());
        allRequires.stream().filter(javaModule -> !"java.base".equals(javaModule.getName())).map(javaModule -> JavaTestFrameworkRunnableState.getClasspathEntry(javaModule, fileIndex, jarFS)).filter(Objects::nonNull).forEach(file -> JavaTestFrameworkRunnableState.putOnModulePath(modulePath, classPath, file));
    }

    private static void putOnModulePath(PathsList modulePath, PathsList classPath, VirtualFile virtualFile) {
        String path = PathUtil.getLocalPath((String)virtualFile.getPath());
        if (classPath.getPathList().contains(path)) {
            classPath.remove(path);
            modulePath.add(path);
        }
    }

    private static VirtualFile getClasspathEntry(PsiJavaModule javaModule, ProjectFileIndex fileIndex, JarFileSystem jarFileSystem) {
        VirtualFile moduleFile = PsiImplUtil.getModuleVirtualFile(javaModule);
        Module moduleDependency = fileIndex.getModuleForFile(moduleFile);
        if (moduleDependency == null) {
            return jarFileSystem.getLocalVirtualFileFor(moduleFile);
        }
        CompilerModuleExtension moduleExtension = CompilerModuleExtension.getInstance((Module)moduleDependency);
        return moduleExtension != null ? moduleExtension.getCompilerOutputPath() : null;
    }

    protected void createServerSocket(JavaParameters javaParameters) {
        try {
            this.myServerSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
            javaParameters.getProgramParametersList().add("-socket" + this.myServerSocket.getLocalPort());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected boolean spansMultipleModules(String qualifiedName) {
        SourceScope sourceScope;
        TestSearchScope scope;
        Project project;
        PsiPackage aPackage;
        if (qualifiedName != null && (aPackage = JavaPsiFacade.getInstance((Project)(project = this.getConfiguration().getProject())).findPackage(qualifiedName)) != null && (scope = this.getScope()) != null && (sourceScope = scope.getSourceScope(this.getConfiguration())) != null) {
            GlobalSearchScope configurationSearchScope = GlobalSearchScopesCore.projectTestScope((Project)project).intersectWith(sourceScope.getGlobalSearchScope());
            PsiDirectory[] directories = aPackage.getDirectories(configurationSearchScope);
            return Arrays.stream(directories).map(dir -> ModuleUtilCore.findModuleForFile((VirtualFile)dir.getVirtualFile(), (Project)project)).filter(Objects::nonNull).distinct().count() > 1L;
        }
        return false;
    }

    protected boolean forkPerModule() {
        return this.getScope() != TestSearchScope.SINGLE_MODULE && JavaTestFrameworkRunnableState.toChangeWorkingDirectory(((CommonProgramRunConfigurationParameters)this.getConfiguration()).getWorkingDirectory()) && this.spansMultipleModules(((CommonJavaRunConfigurationParameters)this.getConfiguration()).getPackage());
    }

    private static boolean toChangeWorkingDirectory(String workingDirectory) {
        return "$MODULE_DIR$".equals(workingDirectory) || "$MODULE_WORKING_DIR$".equals(workingDirectory) || "%MODULE_WORKING_DIR%".equals(workingDirectory);
    }

    protected void createTempFiles(JavaParameters javaParameters) {
        try {
            this.myWorkingDirsFile = FileUtil.createTempFile((String)("idea_working_dirs_" + this.getFrameworkId()), (String)".tmp", (boolean)true);
            javaParameters.getProgramParametersList().add("@w@" + this.myWorkingDirsFile.getAbsolutePath());
            this.myTempFile = FileUtil.createTempFile((String)("idea_" + this.getFrameworkId()), (String)".tmp", (boolean)true);
            this.passTempFile(javaParameters.getProgramParametersList(), this.myTempFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    protected void writeClassesPerModule(String packageName, JavaParameters javaParameters, Map<Module, List<String>> perModule, @NotNull String filters) throws FileNotFoundException, UnsupportedEncodingException {
        if (filters == null) {
            JavaTestFrameworkRunnableState.$$$reportNull$$$0(7);
        }
        if (perModule != null) {
            String classpath = this.getScope() == TestSearchScope.WHOLE_PROJECT ? null : javaParameters.getClassPath().getPathsString();
            String workingDirectory = ((CommonProgramRunConfigurationParameters)this.getConfiguration()).getWorkingDirectory();
            boolean toChangeWorkingDirectory = JavaTestFrameworkRunnableState.toChangeWorkingDirectory(workingDirectory);
            try (PrintWriter wWriter = new PrintWriter(this.myWorkingDirsFile, "UTF-8");){
                wWriter.println(packageName);
                for (Module module : perModule.keySet()) {
                    wWriter.println(toChangeWorkingDirectory ? PathMacroUtil.getModuleDir((String)module.getModuleFilePath()) : workingDirectory);
                    wWriter.println(module.getName());
                    if (classpath == null) {
                        JavaParameters parameters2 = new JavaParameters();
                        try {
                            JavaParametersUtil.configureModule(module, parameters2, 7, ((CommonJavaRunConfigurationParameters)this.getConfiguration()).isAlternativeJrePathEnabled() ? ((CommonJavaRunConfigurationParameters)this.getConfiguration()).getAlternativeJrePath() : null);
                            if (JavaSdkUtil.isJdkAtLeast(parameters2.getJdk(), JavaSdkVersion.JDK_1_9)) {
                                this.configureModulePath(parameters2, module);
                            }
                            this.configureRTClasspath(parameters2, module);
                            parameters2.getClassPath().add(JavaSdkUtil.getIdeaRtJarPath());
                            JavaTestFrameworkRunnableState.writeClasspath(wWriter, parameters2);
                        }
                        catch (CantRunException e) {
                            JavaTestFrameworkRunnableState.writeClasspath(wWriter, javaParameters);
                        }
                    } else {
                        JavaTestFrameworkRunnableState.writeClasspath(wWriter, javaParameters);
                    }
                    List<String> classNames = perModule.get(module);
                    wWriter.println(classNames.size());
                    for (String className2 : classNames) {
                        wWriter.println(className2);
                    }
                    wWriter.println(filters);
                }
            }
        }
    }

    private static void writeClasspath(PrintWriter wWriter, JavaParameters parameters2) {
        wWriter.println(parameters2.getClassPath().getPathsString());
        wWriter.println(parameters2.getModulePath().getPathsString());
        ParamsGroup paramsGroup = JavaTestFrameworkRunnableState.getJigsawOptions(parameters2);
        if (paramsGroup == null) {
            wWriter.println(0);
        } else {
            List parametersList = paramsGroup.getParametersList().getList();
            wWriter.println(parametersList.size());
            for (String option : parametersList) {
                wWriter.println(option);
            }
        }
    }

    protected void deleteTempFiles() {
        if (this.myTempFile != null) {
            FileUtil.delete((File)this.myTempFile);
        }
        if (this.myWorkingDirsFile != null) {
            FileUtil.delete((File)this.myWorkingDirsFile);
        }
    }

    public void appendRepeatMode() throws ExecutionException {
    }

    protected boolean useModulePath() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/JavaTestFrameworkRunnableState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/JavaTestFrameworkRunnableState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureModulePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeClassesPerModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

