/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractApplicationConfigurationProducer<T extends ApplicationConfiguration>
extends JavaRunConfigurationProducerBase<T> {
    public AbstractApplicationConfigurationProducer() {
    }

    @Deprecated
    public AbstractApplicationConfigurationProducer(@NotNull ApplicationConfigurationType configurationType) {
        if (configurationType == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(0);
        }
        super(configurationType);
    }

    protected boolean setupConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location contextLocation;
        if (configuration == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((contextLocation = context.getLocation()) == null) {
            return false;
        }
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (!element.isPhysical()) {
            return false;
        }
        PsiClass aClass = ApplicationConfigurationType.getMainClass(element);
        if (aClass == null) {
            return false;
        }
        PsiMethod method = PsiMethodUtil.findMainInClass((PsiClass)aClass);
        if (method != null && PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)element, (boolean)false)) {
            sourceElement.set((Object)method);
            this.setupConfiguration(configuration, aClass, context);
            return true;
        }
        sourceElement.set((Object)aClass);
        this.setupConfiguration(configuration, aClass, context);
        return true;
    }

    private void setupConfiguration(T configuration, PsiClass aClass, ConfigurationContext context) {
        ((ApplicationConfiguration)configuration).setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass));
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, configuration);
    }

    public boolean isConfigurationFromContext(@NotNull T appConfiguration, @NotNull ConfigurationContext context) {
        PsiElement location;
        PsiClass aClass;
        if (appConfiguration == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((aClass = ApplicationConfigurationType.getMainClass(location = context.getPsiLocation())) != null && Objects.equals(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), ((ApplicationConfiguration)appConfiguration).getMainClassName())) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)location, PsiMethod.class, (boolean)false);
            if (method != null && TestFrameworks.getInstance().isTestMethod(method)) {
                return false;
            }
            Module configurationModule = ((JavaRunConfigurationModule)appConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)context.getModule(), (Object)configurationModule)) {
                return true;
            }
            ApplicationConfiguration template = (ApplicationConfiguration)context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory()).getConfiguration();
            Module predefinedModule = ((JavaRunConfigurationModule)template.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfiguration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/application/AbstractApplicationConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

