/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.ArgumentFileFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJavaApplicationCommandLineState<T extends RunConfigurationBase>
extends JavaCommandLineState
implements RemoteConnectionCreator {
    @NotNull
    protected final T myConfiguration;
    @Nullable
    private volatile RemoteConnection myRemoteConnection;

    public BaseJavaApplicationCommandLineState(ExecutionEnvironment environment, @NotNull T configuration) {
        if (configuration == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(0);
        }
        super(environment);
        this.myConfiguration = configuration;
    }

    protected void setupJavaParameters(@NotNull JavaParameters params) throws ExecutionException {
        if (params == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(1);
        }
        JavaParametersUtil.configureConfiguration((SimpleJavaParameters)params, (CommonJavaRunConfigurationParameters)this.myConfiguration);
        for (RunConfigurationExtension ext : RunConfigurationExtension.EP_NAME.getExtensionList()) {
            ext.updateJavaParameters(this.getConfiguration(), params, this.getRunnerSettings(), this.getEnvironment().getExecutor());
        }
    }

    public synchronized void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (request == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(3);
        }
        this.prepareRemoteConnection(request, configuration);
        super.prepareTargetEnvironmentRequest(request, configuration, progressIndicator);
    }

    private void prepareRemoteConnection(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration) {
        if (request == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(4);
        }
        if (!"Debug".equalsIgnoreCase(this.getEnvironment().getExecutor().getId())) {
            this.myRemoteConnection = null;
            return;
        }
        try {
            if (!(request instanceof LocalTargetEnvironmentRequest)) {
                int remotePort = 12345;
                boolean java9plus = Optional.ofNullable(configuration).map(TargetEnvironmentConfiguration::getRuntimes).map(list -> (JavaLanguageRuntimeConfiguration)list.findByType(JavaLanguageRuntimeConfiguration.class)).map(JavaLanguageRuntimeConfiguration::getJavaVersionString).filter(StringUtil::isNotEmpty).map(JavaSdkVersion::fromVersionString).map(v -> v.isAtLeast(JavaSdkVersion.JDK_1_9)).orElse(false);
                String remoteAddressForVmParams = java9plus ? "*:12345" : String.valueOf(12345);
                RemoteConnection remoteConnection = new RemoteConnectionBuilder(false, 0, remoteAddressForVmParams).suspend(true).create(this.getJavaParameters());
                remoteConnection.setApplicationAddress(String.valueOf(12345));
                if (java9plus) {
                    remoteConnection.setApplicationHostName("*");
                }
                request.bindTargetPort(12345).getLocalValue().onSuccess(it -> {
                    remoteConnection.setDebuggerHostName("localhost");
                    remoteConnection.setDebuggerAddress(String.valueOf(it));
                });
                this.myRemoteConnection = remoteConnection;
            }
        }
        catch (ExecutionException e) {
            this.myRemoteConnection = null;
        }
    }

    @Nullable
    public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
        return this.myRemoteConnection;
    }

    public boolean isPollConnection() {
        return true;
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration) throws ExecutionException {
        if (request == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(5);
        }
        TargetedCommandLineBuilder line = super.createTargetedCommandLine(request, configuration);
        File inputFile = InputRedirectAware.getInputFile(this.myConfiguration);
        if (inputFile != null) {
            line.setInputFile(request.getDefaultVolume().createUpload(inputFile.getAbsolutePath()));
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = line;
        if (targetedCommandLineBuilder == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(6);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        TargetEnvironment remoteEnvironment = this.getEnvironment().getPreparedTargetEnvironment((RunProfileState)this, (ProgressIndicator)new EmptyProgressIndicator());
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.getTargetedCommandLine();
        TargetedCommandLine targetedCommandLine = targetedCommandLineBuilder.build();
        Process process2 = remoteEnvironment.createProcess(targetedCommandLine, (ProgressIndicator)new EmptyProgressIndicator());
        Map content = (Map)targetedCommandLineBuilder.getUserData(JdkUtil.COMMAND_LINE_CONTENT);
        if (content != null) {
            content.forEach((key2, value2) -> this.addConsoleFilters(new Filter[]{new ArgumentFileFilter(key2, value2)}));
        }
        KillableColoredProcessHandler.Silent handler = new KillableColoredProcessHandler.Silent(process2, targetedCommandLine.getCommandPresentation(remoteEnvironment), targetedCommandLine.getCharset(), targetedCommandLineBuilder.getFilesToDeleteOnTermination());
        ProcessTerminatedListener.attach((ProcessHandler)handler);
        JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.getConfiguration(), (ProcessHandler)handler, this.getRunnerSettings());
        KillableColoredProcessHandler.Silent silent = handler;
        if (silent == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(7);
        }
        return silent;
    }

    @NotNull
    protected T getConfiguration() {
        T t = this.myConfiguration;
        if (t == null) {
            BaseJavaApplicationCommandLineState.$$$reportNull$$$0(8);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/application/BaseJavaApplicationCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/application/BaseJavaApplicationCommandLineState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupJavaParameters";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetEnvironmentRequest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareRemoteConnection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

