/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.attach.JavaDebuggerAttachUtil;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaProgramPatcher;
import com.intellij.execution.runners.JvmPatchableProgramRunner;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadDumpConsoleFactory;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultJavaProgramRunner
implements JvmPatchableProgramRunner<RunnerSettings> {
    private static final Logger LOG = Logger.getInstance(DefaultJavaProgramRunner.class);
    private static final String ourWiseThreadDumpProperty = "idea.java.run.wise.thread.dump";
    public static final String DEFAULT_JAVA_RUNNER_ID = "Run";

    public static ProgramRunner<?> getInstance() {
        return ProgramRunner.findRunnerById((String)DEFAULT_JAVA_RUNNER_ID);
    }

    @NotNull
    public String getRunnerId() {
        return DEFAULT_JAVA_RUNNER_ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(1);
        }
        return executorId.equals(DEFAULT_JAVA_RUNNER_ID) && profile instanceof ModuleRunProfile && !(profile instanceof RunConfigurationWithSuppressedDefaultRunAction);
    }

    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        RunProfileState currentState;
        if (environment == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(2);
        }
        if ((currentState = environment.getState()) == null) {
            return;
        }
        ExecutionManager executionManager = ExecutionManager.getInstance((Project)environment.getProject());
        executionManager.executePreparationTasks(environment, currentState).onSuccess(__ -> executionManager.startRunProfile(environment, currentState, ignored -> this.doExecute(currentState, environment)));
    }

    public void patch(@NotNull JavaParameters javaParameters, @Nullable RunnerSettings settings, @NotNull RunProfile runProfile, boolean beforeExecution) {
        if (javaParameters == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(3);
        }
        if (runProfile == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(4);
        }
        JavaProgramPatcher.runCustomPatchers((JavaParameters)javaParameters, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)runProfile);
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        ExecutionResult executionResult;
        if (state == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(5);
        }
        if (env == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        boolean shouldAddDefaultActions = true;
        if (state instanceof JavaCommandLine) {
            ParametersList parametersList;
            JavaParameters parameters2 = ((JavaCommandLine)state).getJavaParameters();
            this.patch(parameters2, env.getRunnerSettings(), env.getRunProfile(), true);
            if (Registry.is((String)"execution.java.always.debug") && DebuggerSettings.getInstance().ALWAYS_DEBUG && (parametersList = parameters2.getVMParametersList()).getList().stream().noneMatch(s -> s.startsWith("-agentlib:jdwp"))) {
                parametersList.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,quiet=y");
            }
            final ProcessProxy proxy = ProcessProxyFactory.getInstance().createCommandLineProxy((JavaCommandLine)state);
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
            if (proxy != null) {
                ProcessHandler handler;
                ProcessHandler processHandler = handler = executionResult != null ? executionResult.getProcessHandler() : null;
                if (handler != null) {
                    proxy.attach(handler);
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            proxy.destroy();
                            handler.removeProcessListener((ProcessListener)this);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/DefaultJavaProgramRunner$1", "processTerminated"));
                        }
                    });
                } else {
                    proxy.destroy();
                }
            }
            if (state instanceof JavaCommandLineState && !((JavaCommandLineState)state).shouldAddJavaProgramRunnerActions()) {
                shouldAddDefaultActions = false;
            }
        } else {
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
        }
        if (executionResult == null) {
            return null;
        }
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, env);
        if (shouldAddDefaultActions) {
            DefaultJavaProgramRunner.addDefaultActions(contentBuilder, executionResult, state instanceof JavaCommandLine);
        }
        return contentBuilder.showRunContent(env.getContentToReuse());
    }

    private static void addDefaultActions(@NotNull RunContentBuilder contentBuilder, @NotNull ExecutionResult executionResult, boolean isJavaCommandLine) {
        ExecutionConsole executionConsole;
        if (contentBuilder == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(7);
        }
        if (executionResult == null) {
            DefaultJavaProgramRunner.$$$reportNull$$$0(8);
        }
        final JComponent consoleComponent = (executionConsole = executionResult.getExecutionConsole()) != null ? executionConsole.getComponent() : null;
        final ProcessHandler processHandler = executionResult.getProcessHandler();
        assert (processHandler != null) : executionResult;
        final ControlBreakAction controlBreakAction = new ControlBreakAction(processHandler, contentBuilder.getSearchScope());
        if (consoleComponent != null) {
            controlBreakAction.registerCustomShortcutSet(controlBreakAction.getShortcutSet(), consoleComponent);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                    controlBreakAction.unregisterCustomShortcutSet(consoleComponent);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/DefaultJavaProgramRunner$2", "processTerminated"));
                }
            });
        }
        contentBuilder.addAction((AnAction)controlBreakAction);
        if (isJavaCommandLine) {
            AttachDebuggerAction.add(contentBuilder, processHandler);
        }
        contentBuilder.addAction((AnAction)new SoftExitAction(processHandler));
    }

    private static void showThreadDump(String out, List<ThreadState> states, Project project) {
        ThreadDumpConsoleFactory factory = states.size() > 1 ? new ThreadDumpConsoleFactory(project, states) : null;
        String title = "Dump " + DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        ApplicationManager.getApplication().invokeLater(() -> AnalyzeStacktraceUtil.addConsole((Project)project, (AnalyzeStacktraceUtil.ConsoleFactory)factory, (String)title, (String)out), ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "patch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addDefaultActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static final class SoftExitAction
    extends ProxyBasedAction {
        public SoftExitAction(ProcessHandler processHandler) {
            super(ExecutionBundle.message((String)"run.configuration.exit.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Exit, processHandler);
        }

        @Override
        protected boolean available(ProcessProxy proxy) {
            return proxy.canSendStop();
        }

        @Override
        protected void perform(AnActionEvent e, ProcessProxy proxy) {
            this.myProcessHandler.putUserData(ProcessHandler.TERMINATION_REQUESTED, (Object)Boolean.TRUE);
            proxy.sendStop();
        }
    }

    private static final class WiseDumpThreadsListener {
        private final Project myProject;
        private final ProcessHandler myProcessHandler;
        private final CapturingProcessAdapter myListener;

        WiseDumpThreadsListener(Project project, ProcessHandler processHandler) {
            this.myProject = project;
            this.myProcessHandler = processHandler;
            this.myListener = new CapturingProcessAdapter();
            this.myProcessHandler.addProcessListener((ProcessListener)this.myListener);
        }

        public void after() {
            if (this.myProject == null) {
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myListener);
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String stdout;
                if (this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating()) {
                    return;
                }
                List<ThreadState> threadStates = null;
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 1000L && (threadStates = ThreadDumpParser.parse(stdout = this.myListener.getOutput().getStdout())).isEmpty()) {
                    TimeoutUtil.sleep((long)50L);
                    threadStates = null;
                }
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myListener);
                if (threadStates != null && !threadStates.isEmpty()) {
                    DefaultJavaProgramRunner.showThreadDump(this.myListener.getOutput().getStdout(), threadStates, this.myProject);
                }
            });
        }
    }

    protected static final class AttachDebuggerAction
    extends DumbAwareAction {
        private final AtomicBoolean myEnabled = new AtomicBoolean();
        private final AtomicReference<XDebugSession> myAttachedSession = new AtomicReference();
        private final BaseProcessHandler<?> myProcessHandler;
        private MessageBusConnection myConnection = null;

        public AttachDebuggerAction(BaseProcessHandler<?> processHandler) {
            super(ExecutionBundle.message((String)"run.configuration.attach.debugger.action.name", (Object[])new Object[0]), null, AllIcons.Debugger.AttachToProcess);
            this.myProcessHandler = processHandler;
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> myEnabled.set(!myProcessHandler.isProcessTerminating() && !myProcessHandler.isProcessTerminated() && JavaDebuggerAttachUtil.canAttach(myProcessHandler)), 1L, TimeUnit.SECONDS);
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (myConnection != null) {
                        myConnection.disconnect();
                    }
                    myProcessHandler.removeProcessListener((ProcessListener)this);
                    XDebugSession attachedSession = myAttachedSession.getAndSet(null);
                    if (attachedSession != null) {
                        attachedSession.stop();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                AttachDebuggerAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) != null && this.myConnection == null) {
                this.myConnection = project.getMessageBus().connect();
                this.myConnection.subscribe(XDebuggerManager.TOPIC, (Object)new XDebuggerManagerListener(){

                    public void processStarted(@NotNull XDebugProcess debugProcess) {
                        if (debugProcess == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        this.processEvent(debugProcess, true);
                    }

                    public void processStopped(@NotNull XDebugProcess debugProcess) {
                        if (debugProcess == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        this.processEvent(debugProcess, false);
                    }

                    void processEvent(@NotNull XDebugProcess debugProcess, boolean started) {
                        RemoteConnection connection;
                        if (debugProcess == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        if (debugProcess instanceof JavaDebugProcess && (connection = ((JavaDebugProcess)debugProcess).getDebuggerSession().getProcess().getConnection()) instanceof PidRemoteConnection && ((PidRemoteConnection)connection).getPid().equals(String.valueOf(OSProcessUtil.getProcessID((Process)myProcessHandler.getProcess())))) {
                            myAttachedSession.set(started ? debugProcess.getSession() : null);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "debugProcess";
                        objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStarted";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStopped";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processEvent";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            if (this.myAttachedSession.get() != null || this.myProcessHandler.isProcessTerminated()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(Boolean.TRUE.equals(this.myEnabled.get()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AttachDebuggerAction.$$$reportNull$$$0(1);
            }
            JavaDebuggerAttachUtil.attach(this.myProcessHandler, e.getProject());
        }

        public static void add(RunContentBuilder contentBuilder, ProcessHandler processHandler) {
            if (Registry.is((String)"debugger.attach.to.process.action") && processHandler instanceof BaseProcessHandler) {
                contentBuilder.addAction((AnAction)new AttachDebuggerAction((BaseProcessHandler)processHandler));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$AttachDebuggerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class ControlBreakAction
    extends ProxyBasedAction {
        private final GlobalSearchScope mySearchScope;

        public ControlBreakAction(ProcessHandler processHandler, GlobalSearchScope searchScope) {
            super(ExecutionBundle.message((String)"run.configuration.dump.threads.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Dump, processHandler);
            this.mySearchScope = searchScope;
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(3, 128)));
        }

        @Override
        protected boolean available(ProcessProxy proxy) {
            return proxy.canSendBreak();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void perform(AnActionEvent event, ProcessProxy proxy) {
            boolean wise;
            Project project = event.getProject();
            if (project == null) {
                return;
            }
            RunnerContentUi runnerContentUi = (RunnerContentUi)event.getData(RunnerContentUi.KEY);
            if (Registry.is((String)"execution.dump.threads.using.attach") && this.myProcessHandler instanceof BaseProcessHandler && runnerContentUi != null) {
                VirtualMachine vm = null;
                try {
                    String pid = String.valueOf(OSProcessUtil.getProcessID((Process)((BaseProcessHandler)this.myProcessHandler).getProcess()));
                    if (!JavaDebuggerAttachUtil.getAttachedPids(project).contains(pid)) {
                        vm = JavaDebuggerAttachUtil.attachVirtualMachine(pid);
                        InputStream inputStream = (InputStream)vm.getClass().getMethod("remoteDataDump", Object[].class).invoke((Object)vm, new Object[]{ArrayUtilRt.EMPTY_OBJECT_ARRAY});
                        String text2 = StreamUtil.readText((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                        List<ThreadState> threads = ThreadDumpParser.parse(text2);
                        DebuggerUtilsEx.addThreadDump(project, threads, runnerContentUi.getRunnerLayoutUi(), this.mySearchScope);
                        return;
                    }
                }
                catch (AttachNotSupportedException e) {
                    LOG.debug((Throwable)e);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                finally {
                    if (vm != null) {
                        try {
                            vm.detach();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            WiseDumpThreadsListener wiseListener = (wise = Boolean.getBoolean(DefaultJavaProgramRunner.ourWiseThreadDumpProperty)) ? new WiseDumpThreadsListener(project, this.myProcessHandler) : null;
            proxy.sendBreak();
            if (wiseListener != null) {
                wiseListener.after();
            }
        }
    }

    private static abstract class ProxyBasedAction
    extends AnAction {
        protected final ProcessHandler myProcessHandler;

        protected ProxyBasedAction(String text2, String description, Icon icon, ProcessHandler processHandler) {
            super(text2, description, icon);
            this.myProcessHandler = processHandler;
        }

        public final void update(@NotNull AnActionEvent event) {
            ProcessProxy proxy;
            if (event == null) {
                ProxyBasedAction.$$$reportNull$$$0(0);
            }
            boolean available = (proxy = ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler)) != null && this.available(proxy);
            Presentation presentation = event.getPresentation();
            if (!available) {
                presentation.setEnabledAndVisible(false);
            } else {
                presentation.setVisible(true);
                presentation.setEnabled(!this.myProcessHandler.isProcessTerminated());
            }
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            ProcessProxy proxy;
            if (e == null) {
                ProxyBasedAction.$$$reportNull$$$0(1);
            }
            if ((proxy = ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler)) != null) {
                this.perform(e, proxy);
            }
        }

        protected abstract boolean available(ProcessProxy var1);

        protected abstract void perform(AnActionEvent var1, ProcessProxy var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/impl/DefaultJavaProgramRunner$ProxyBasedAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

