/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.jar.JarApplicationConfiguration;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarApplicationConfigurable
extends SettingsEditor<JarApplicationConfiguration>
implements PanelWithAnchor {
    private CommonJavaParametersPanel myCommonProgramParameters;
    private LabeledComponent<TextFieldWithBrowseButton> myJarPathComponent;
    private LabeledComponent<ModulesComboBox> myModuleComponent;
    private JPanel myWholePanel;
    private JrePathEditor myJrePathEditor;
    private final Project myProject;
    private JComponent myAnchor;

    public JarApplicationConfigurable(Project project) {
        this.myProject = project;
        PanelWithAnchor[] panelWithAnchorArray = new PanelWithAnchor[3];
        this.$$$setupUI$$$();
        panelWithAnchorArray[0] = this.myJarPathComponent;
        panelWithAnchorArray[1] = this.myCommonProgramParameters;
        panelWithAnchorArray[2] = this.myJrePathEditor;
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])panelWithAnchorArray);
        ModulesComboBox modulesComboBox = (ModulesComboBox)this.myModuleComponent.getComponent();
        modulesComboBox.allowEmptySelection("<whole project>");
        modulesComboBox.fillModules(project);
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromModuleDependencies(modulesComboBox, true));
    }

    public void applyEditorTo(@NotNull JarApplicationConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            JarApplicationConfigurable.$$$reportNull$$$0(0);
        }
        this.myCommonProgramParameters.applyTo(configuration);
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        configuration.setJarPath(FileUtil.toSystemIndependentName((String)((TextFieldWithBrowseButton)this.myJarPathComponent.getComponent()).getText()));
        configuration.setModule(((ModulesComboBox)this.myModuleComponent.getComponent()).getSelectedModule());
    }

    public void resetEditorFrom(@NotNull JarApplicationConfiguration configuration) {
        if (configuration == null) {
            JarApplicationConfigurable.$$$reportNull$$$0(1);
        }
        this.myCommonProgramParameters.reset(configuration);
        ((TextFieldWithBrowseButton)this.myJarPathComponent.getComponent()).setText(FileUtil.toSystemDependentName((String)configuration.getJarPath()));
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        ((ModulesComboBox)this.myModuleComponent.getComponent()).setSelectedModule(configuration.getModule());
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            JarApplicationConfigurable.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myJarPathComponent = new LabeledComponent();
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.addBrowseFolderListener(ExecutionBundle.message((String)"choose.jar.file", (Object[])new Object[0]), null, this.myProject, new FileChooserDescriptor(false, false, true, true, false, false));
        this.myJarPathComponent.setComponent((JComponent)textFieldWithBrowseButton);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
        this.myJarPathComponent.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        JrePathEditor jrePathEditor;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCommonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel.add((Component)((Object)commonJavaParametersPanel), new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel.add((Component)((Object)jrePathEditor), new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent2 = this.myJarPathComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText("Path to &JAR");
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myModuleComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Search sources using m&odule's classpath");
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/jar/JarApplicationConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/jar/JarApplicationConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

