/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

final class JavaScratchCompilationSupport
implements CompileTask {
    JavaScratchCompilationSupport() {
    }

    @Nullable
    public static File getScratchOutputDirectory(Project project) {
        File root = CompilerManager.getInstance((Project)project).getJavacCompilerWorkingDir();
        return root != null ? new File(root, "scratches/out") : null;
    }

    @Nullable
    public static File getScratchTempDirectory(Project project) {
        File root = CompilerManager.getInstance((Project)project).getJavacCompilerWorkingDir();
        return root != null ? new File(root, "scratches/src") : null;
    }

    public boolean execute(@NotNull CompileContext context) {
        Sdk targetSdk;
        if (context == null) {
            JavaScratchCompilationSupport.$$$reportNull$$$0(0);
        }
        Project project = context.getProject();
        RunConfiguration configuration = CompileStepBeforeRun.getRunConfiguration(context);
        if (!(configuration instanceof JavaScratchConfiguration)) {
            return true;
        }
        JavaScratchConfiguration scratchConfig = (JavaScratchConfiguration)configuration;
        String scratchUrl = scratchConfig.getScratchFileUrl();
        if (scratchUrl == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "Associated scratch file not found", null, -1, -1);
            return false;
        }
        @Nullable Module module = ((JavaRunConfigurationModule)scratchConfig.getConfigurationModule()).getModule();
        Sdk sdk = targetSdk = module != null ? ModuleRootManager.getInstance((Module)module).getSdk() : ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (targetSdk == null) {
            String message2 = module != null ? "Cannot find associated SDK for run configuration module \"" + module.getName() + "\".\nPlease check project settings." : "Cannot find associated project SDK for the run configuration.\nPlease check project settings.";
            context.addMessage(CompilerMessageCategory.ERROR, message2, scratchUrl, -1, -1);
            return true;
        }
        if (!(targetSdk.getSdkType() instanceof JavaSdkType)) {
            String message3 = module != null ? "Expected Java SDK for run configuration module \"" + module.getName() + "\".\nPlease check project settings." : "Expected Java SDK for project \"" + project.getName() + "\".\nPlease check project settings.";
            context.addMessage(CompilerMessageCategory.ERROR, message3, scratchUrl, -1, -1);
            return true;
        }
        File outputDir = JavaScratchCompilationSupport.getScratchOutputDirectory(project);
        if (outputDir == null) {
            return true;
        }
        FileUtil.delete((File)outputDir);
        try {
            File scratchFile;
            File srcFile = scratchFile = new File(VirtualFileManager.extractPath((String)scratchUrl));
            VirtualFile vFile = (VirtualFile)ReadAction.compute(() -> VirtualFileManager.getInstance().findFileByUrl(scratchUrl));
            Charset charset = (Charset)ReadAction.compute(() -> vFile == null ? null : vFile.getCharset());
            if (!StringUtil.endsWith((CharSequence)srcFile.getName(), (CharSequence)".java")) {
                File srcDir = JavaScratchCompilationSupport.getScratchTempDirectory(project);
                if (srcDir == null) {
                    return true;
                }
                FileUtil.delete((File)srcDir);
                String srcFileName = (String)ReadAction.compute(() -> {
                    PsiFile psiFile;
                    if (vFile != null && (psiFile = PsiManager.getInstance((Project)project).findFile(vFile)) instanceof PsiJavaFile) {
                        String name2 = null;
                        for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                            if (name2 == null) {
                                name2 = aClass.getName();
                                if (!JavaScratchCompilationSupport.isPublic(aClass)) continue;
                                break;
                            }
                            if (!JavaScratchCompilationSupport.isPublic(aClass)) continue;
                            name2 = aClass.getName();
                            break;
                        }
                        if (name2 != null) {
                            return name2;
                        }
                    }
                    return FileUtilRt.getNameWithoutExtension((String)scratchFile.getName());
                });
                srcFile = new File(srcDir, srcFileName + ".java");
                FileUtil.copy((File)scratchFile, (File)srcFile);
            }
            Set<File> files = Collections.singleton(srcFile);
            LinkedHashSet cp = new LinkedHashSet();
            ArrayList platformCp = new ArrayList();
            Computable orderEnumerator = module != null ? () -> ModuleRootManager.getInstance((Module)module).orderEntries() : () -> ProjectRootManager.getInstance((Project)project).orderEntries();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (module != null || scratchConfig.isBuildProjectOnEmptyModuleList()) {
                    for (String s : ((OrderEnumerator)orderEnumerator.compute()).compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
                        cp.add(new File(s));
                    }
                }
                for (String s : ((OrderEnumerator)orderEnumerator.compute()).compileOnly().sdkOnly().getPathsList().getPathList()) {
                    platformCp.add(new File(s));
                }
            });
            ArrayList<String> options = new ArrayList<String>();
            options.add("-g");
            JavaSdkVersion sdkVersion = JavaSdk.getInstance().getVersion(targetSdk);
            if (sdkVersion != null) {
                LanguageLevel level = sdkVersion.getMaxLanguageLevel();
                String langLevel = JpsJavaSdkType.complianceOption((JavaVersion)level.toJavaVersion());
                options.add("-source");
                options.add(langLevel);
                options.add("-target");
                options.add(langLevel);
                if (level.isPreview()) {
                    options.add("--enable-preview");
                }
            }
            options.add("-proc:none");
            if (charset != null) {
                options.add("-encoding");
                options.add(charset.name());
            }
            Collection result = CompilerManager.getInstance((Project)project).compileJavaCode(options, platformCp, cp, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), files, outputDir);
            for (ClassObject classObject : result) {
                byte[] bytes = classObject.getContent();
                if (bytes == null) continue;
                FileUtil.writeToFile((File)new File(classObject.getPath()), (byte[])bytes);
            }
        }
        catch (CompilationException e) {
            for (CompilationException.Message m : e.getMessages()) {
                context.addMessage(m.getCategory(), m.getText(), scratchUrl, m.getLine(), m.getColumn());
            }
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), scratchUrl, -1, -1);
        }
        return true;
    }

    private static boolean isPublic(PsiClass aClass) {
        PsiModifierList modifiers = aClass.getModifierList();
        return modifiers != null && modifiers.hasModifierProperty("public");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/scratch/JavaScratchCompilationSupport", "execute"));
    }
}

