/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TestDiscoverySearchHelper {
    public static Set<String> search(Project project, Pair<String, String> position, String changeList, byte frameworkId) {
        LinkedHashSet patterns = new LinkedHashSet();
        if (position != null) {
            TestDiscoverySearchHelper.collectPatterns(project, patterns, (String)position.first, (String)position.second, frameworkId);
        }
        List<VirtualFile> files = TestDiscoverySearchHelper.getAffectedFiles(changeList, project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        TestDiscoveryIndex discoveryIndex = TestDiscoveryIndex.getInstance(project);
        for (VirtualFile file : files) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile instanceof PsiClassOwner) {
                    PsiClass[] classes2;
                    if (position != null && ((classes2 = ((PsiClassOwner)psiFile).getClasses()).length == 0 || TestFrameworks.detectFramework((PsiClass)classes2[0]) == null)) {
                        return;
                    }
                    List changedTextRanges = VcsFacade.getInstance().getChangedTextRanges(project, psiFile);
                    for (TextRange textRange : changedTextRanges) {
                        PsiElement start = psiFile.findElementAt(textRange.getStartOffset());
                        PsiElement end = psiFile.findElementAt(textRange.getEndOffset());
                        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])new PsiElement[]{start, end});
                        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(PsiTreeUtil.findChildrenOfType((PsiElement)parent, PsiMethod.class));
                        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class);
                        if (containingMethod != null) {
                            methods.add(containingMethod);
                        }
                        for (PsiMethod changedMethod : methods) {
                            PsiClass containingClass;
                            LinkedHashSet<String> detectedPatterns;
                            LinkedHashSet<String> linkedHashSet = detectedPatterns = position == null ? TestDiscoverySearchHelper.collectPatterns(changedMethod, frameworkId) : null;
                            if (detectedPatterns != null) {
                                patterns.addAll(detectedPatterns);
                            }
                            if ((containingClass = changedMethod.getContainingClass()) == null || containingClass.getParent() != psiFile) continue;
                            String classQualifiedName = containingClass.getQualifiedName();
                            String changedMethodName = changedMethod.getName();
                            if (classQualifiedName == null || (position != null || TestFrameworks.detectFramework((PsiClass)containingClass) == null) && (position == null || discoveryIndex.hasTestTrace(classQualifiedName, changedMethodName, frameworkId))) continue;
                            patterns.add(classQualifiedName + "," + changedMethodName);
                        }
                    }
                }
            });
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project);
        return new HashSet<String>(ContainerUtil.filter(patterns, fqn -> (Boolean)ReadAction.compute(() -> psiFacade.findClass(StringUtil.getPackageName((String)fqn, (char)','), searchScope) != null)));
    }

    private static void collectPatterns(@NotNull Project project, @NotNull Set<? super String> patterns, @NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        if (project == null) {
            TestDiscoverySearchHelper.$$$reportNull$$$0(0);
        }
        if (patterns == null) {
            TestDiscoverySearchHelper.$$$reportNull$$$0(1);
        }
        if (classFQName == null) {
            TestDiscoverySearchHelper.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            TestDiscoverySearchHelper.$$$reportNull$$$0(3);
        }
        SmartList classesAndMethods = new SmartList((Object)Couple.of((Object)classFQName, (Object)methodName));
        TestDiscoveryProducer.consumeDiscoveredTests(project, (List<Couple<String>>)classesAndMethods, frameworkId, Collections.emptyList(), (c, m, p) -> {
            patterns.add(c + "," + m);
            return true;
        });
    }

    @NotNull
    private static List<VirtualFile> getAffectedFiles(String changeListName, Project project) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if ("All".equals(changeListName)) {
            List list = changeListManager.getAffectedFiles();
            if (list == null) {
                TestDiscoverySearchHelper.$$$reportNull$$$0(4);
            }
            return list;
        }
        LocalChangeList changeList = changeListManager.findChangeList(changeListName);
        if (changeList != null) {
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (Change change : changeList.getChanges()) {
                VirtualFile file;
                ContentRevision afterRevision = change.getAfterRevision();
                if (afterRevision == null || (file = afterRevision.getFile().getVirtualFile()) == null) continue;
                files.add(file);
            }
            ArrayList<VirtualFile> arrayList = files;
            if (arrayList == null) {
                TestDiscoverySearchHelper.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            TestDiscoverySearchHelper.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static LinkedHashSet<String> collectPatterns(PsiMethod psiMethod, byte frameworkId) {
        String qualifiedName;
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            TestDiscoverySearchHelper.collectPatterns(psiMethod.getProject(), patterns, qualifiedName, psiMethod.getName(), frameworkId);
        }
        LinkedHashSet<String> linkedHashSet = patterns;
        if (linkedHashSet == null) {
            TestDiscoverySearchHelper.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoverySearchHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoverySearchHelper";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectPatterns";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

