/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.ui.BeforeRunComponent;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ModuleClasspathCombo;
import com.intellij.execution.ui.RunConfigurationEditorFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class CommonJavaFragments {
    public static <S extends RunConfigurationBase<?>> SettingsEditorFragment<S, JLabel> createBuildBeforeRun(final BeforeRunComponent beforeRunComponent) {
        final String buildAndRun = ExecutionBundle.message((String)"application.configuration.title.build.and.run", (Object[])new Object[0]);
        final String run2 = ExecutionBundle.message((String)"application.configuration.title.run", (Object[])new Object[0]);
        final JLabel jLabel = new JLabel(buildAndRun);
        jLabel.setFont(JBUI.Fonts.label().deriveFont(1));
        RunConfigurationEditorFragment fragment = new RunConfigurationEditorFragment<S, JLabel>("doNotBuildBeforeRun", ExecutionBundle.message((String)"do.not.build.before.run", (Object[])new Object[0]), ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), jLabel, -1){

            public void resetEditorFrom(@NotNull RunnerAndConfigurationSettingsImpl s) {
                if (s == null) {
                    1.$$$reportNull$$$0(0);
                }
                jLabel.setText(this.hasTask(s) ? buildAndRun : run2);
            }

            private boolean hasTask(@NotNull RunnerAndConfigurationSettingsImpl s) {
                if (s == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ContainerUtil.exists((Iterable)s.getManager().getBeforeRunTasks(s.getConfiguration()), t -> CompileStepBeforeRun.ID == t.getProviderId());
            }

            public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
                if (s == null) {
                    1.$$$reportNull$$$0(2);
                }
                ArrayList<BeforeRunTask> tasks = new ArrayList<BeforeRunTask>(s.getManager().getBeforeRunTasks(s.getConfiguration()));
                if (!this.isSelected()) {
                    if (!this.hasTask(s)) {
                        CompileStepBeforeRun.MakeBeforeRunTask task = new CompileStepBeforeRun.MakeBeforeRunTask();
                        task.setEnabled(true);
                        tasks.add(task);
                    }
                } else {
                    tasks.removeIf(t -> CompileStepBeforeRun.ID == t.getProviderId());
                }
                s.getManager().setBeforeRunTasks(s.getConfiguration(), tasks);
            }

            public void setSelected(boolean selected) {
                jLabel.setText(selected ? run2 : buildAndRun);
                beforeRunComponent.addOrRemove(CompileStepBeforeRun.ID, !selected);
                this.fireEditorStateChanged();
            }

            public boolean isSelected() {
                return run2.equals(jLabel.getText());
            }

            @NotNull
            protected JComponent createEditor() {
                JComponent jComponent = this.myComponent;
                if (jComponent == null) {
                    1.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/execution/ui/CommonJavaFragments$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/execution/ui/CommonJavaFragments$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEditor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "resetEditorFrom";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "hasTask";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyEditorTo";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        beforeRunComponent.setTagListener((key2, added) -> {
            if (CompileStepBeforeRun.ID == key2) {
                jLabel.setText(added != false ? buildAndRun : run2);
            }
        });
        return fragment;
    }

    public static <S extends ModuleBasedConfiguration<?, ?>> SettingsEditorFragment<S, ModuleClasspathCombo> moduleClasspath(ModuleClasspathCombo.Item option, Predicate<S> getter, BiConsumer<S, Boolean> setter) {
        ModuleClasspathCombo comboBox = new ModuleClasspathCombo(option);
        String name2 = ExecutionBundle.message((String)"application.configuration.use.classpath.and.jdk.of.module", (Object[])new Object[0]);
        comboBox.getAccessibleContext().setAccessibleName(name2);
        CommandLinePanel.setMinimumWidth((Component)comboBox, (int)400);
        UIUtil.setMonospaced((Component)comboBox);
        SettingsEditorFragment fragment = new SettingsEditorFragment("module.classpath", name2, ExecutionBundle.message((String)"group.java.options", (Object[])new Object[0]), (JComponent)comboBox, 10, (s, c) -> {
            comboBox.reset((ModuleBasedConfiguration)s);
            option.myOptionValue = getter.test(s);
        }, (s, c) -> {
            if (comboBox.isVisible()) {
                comboBox.applyTo((ModuleBasedConfiguration)s);
                setter.accept(s, option.myOptionValue);
            } else {
                s.setModule(s.getDefaultModule());
                setter.accept(s, false);
            }
        }, s -> s.getDefaultModule() != s.getConfigurationModule().getModule());
        fragment.setHint(ExecutionBundle.message((String)"application.configuration.use.classpath.and.jdk.of.module.hint", (Object[])new Object[0]));
        return fragment;
    }

    @NotNull
    public static SettingsEditorFragment<ApplicationConfiguration, JrePathEditor> createJrePath(Project project) {
        JrePathEditor jrePathEditor = new JrePathEditor(false);
        ComboBox comboBox = (ComboBox)jrePathEditor.getComponent();
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JrePathEditor.JreComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JrePathEditor.JreComboBoxItem> list, JrePathEditor.JreComboBoxItem value2, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value2 != null) {
                    if (index == -1) {
                        this.append("java ");
                        this.append("(" + value2.getPresentableText() + ")");
                    } else {
                        value2.render((SimpleColoredComponent)this, selected);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/CommonJavaFragments$2", "customizeCellRenderer"));
            }
        });
        UIUtil.setMonospaced((Component)comboBox);
        CommandLinePanel.setMinimumWidth((Component)((Object)jrePathEditor), (int)100);
        jrePathEditor.getLabel().setVisible(false);
        ((ComboBox)jrePathEditor.getComponent()).getAccessibleContext().setAccessibleName(jrePathEditor.getLabel().getText());
        jrePathEditor.setDefaultJreSelector(DefaultJreSelector.projectSdk(project));
        return new SettingsEditorFragment("jrePath", null, null, (JComponent)((Object)jrePathEditor), 5, (configuration, editor) -> editor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled()), (configuration, editor) -> {
            configuration.setAlternativeJrePath(editor.getJrePathOrName());
            configuration.setAlternativeJrePathEnabled(editor.isAlternativeJreSelected());
        }, configuration -> true);
    }
}

