/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class JreVersionDetector {
    private String myLastAlternativeJrePath;
    private boolean myLastIsJre50;

    public boolean isModuleJre50Configured(ModuleBasedConfiguration configuration) {
        Module module = configuration.getConfigurationModule().getModule();
        Sdk sdk = module != null && !module.isDisposed() ? ModuleRootManager.getInstance((Module)module).getSdk() : ProjectRootManager.getInstance((Project)configuration.getProject()).getProjectSdk();
        return JavaSdkUtil.isJdkAtLeast(sdk, JavaSdkVersion.JDK_1_5);
    }

    public boolean isJre50Configured(CommonJavaRunConfigurationParameters configuration) {
        String alternativeJrePath;
        if (configuration.isAlternativeJrePathEnabled() && !StringUtil.isEmptyOrSpaces((String)(alternativeJrePath = configuration.getAlternativeJrePath()))) {
            if (Objects.equals(alternativeJrePath, this.myLastAlternativeJrePath)) {
                return this.myLastIsJre50;
            }
            this.myLastAlternativeJrePath = alternativeJrePath;
            JdkVersionDetector.JdkVersionInfo jdkInfo = SdkVersionUtil.getJdkVersionInfo((String)this.myLastAlternativeJrePath);
            this.myLastIsJre50 = jdkInfo != null && jdkInfo.version.feature >= 5;
            return this.myLastIsJre50;
        }
        return false;
    }
}

