/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.serialization.PropertyMapping;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaProjectData
extends AbstractExternalEntityData {
    public static final Key<JavaProjectData> KEY = Key.create(JavaProjectData.class, (int)(ProjectKeys.PROJECT.getProcessingWeight() + 1));
    private static final Logger LOG = Logger.getInstance(JavaProjectData.class);
    private static final Pattern JDK_VERSION_PATTERN = Pattern.compile(".*1.(\\d+).*");
    private boolean isSetJdkVersion;
    @NotNull
    private JavaSdkVersion jdkVersion;
    @NotNull
    private String compileOutputPath;
    @NotNull
    private LanguageLevel languageLevel;
    @Nullable
    private String targetBytecodeVersion;

    public JavaProjectData(@NotNull ProjectSystemId owner2, @NotNull String compileOutputPath) {
        if (owner2 == null) {
            JavaProjectData.$$$reportNull$$$0(0);
        }
        if (compileOutputPath == null) {
            JavaProjectData.$$$reportNull$$$0(1);
        }
        this(owner2, compileOutputPath, null, null);
    }

    @PropertyMapping(value={"owner", "compileOutputPath", "languageLevel", "targetBytecodeVersion"})
    public JavaProjectData(@NotNull ProjectSystemId owner2, @NotNull String compileOutputPath, @Nullable LanguageLevel languageLevel, @Nullable String targetBytecodeVersion) {
        if (owner2 == null) {
            JavaProjectData.$$$reportNull$$$0(2);
        }
        if (compileOutputPath == null) {
            JavaProjectData.$$$reportNull$$$0(3);
        }
        this(owner2, compileOutputPath, null, languageLevel, targetBytecodeVersion);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public @NotNull JavaProjectData(@NotNull ProjectSystemId owner2, @NotNull String compileOutputPath, @Nullable JavaSdkVersion jdkVersion, @Nullable LanguageLevel languageLevel, @Nullable String targetBytecodeVersion) {
        if (owner2 == null) {
            JavaProjectData.$$$reportNull$$$0(4);
        }
        if (compileOutputPath == null) {
            JavaProjectData.$$$reportNull$$$0(5);
        }
        super(owner2);
        this.isSetJdkVersion = false;
        this.compileOutputPath = compileOutputPath;
        this.jdkVersion = jdkVersion != null ? jdkVersion : JavaSdkVersion.fromLanguageLevel((LanguageLevel)LanguageLevel.HIGHEST);
        this.languageLevel = languageLevel != null ? languageLevel : LanguageLevel.HIGHEST;
        this.targetBytecodeVersion = targetBytecodeVersion;
    }

    @NotNull
    public String getCompileOutputPath() {
        String string = this.compileOutputPath;
        if (string == null) {
            JavaProjectData.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setCompileOutputPath(@NotNull String compileOutputPath) {
        if (compileOutputPath == null) {
            JavaProjectData.$$$reportNull$$$0(7);
        }
        this.compileOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)compileOutputPath);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public JavaSdkVersion getJdkVersion() {
        JavaSdkVersion javaSdkVersion = this.jdkVersion;
        if (javaSdkVersion == null) {
            JavaProjectData.$$$reportNull$$$0(8);
        }
        return javaSdkVersion;
    }

    @ApiStatus.Internal
    public boolean isSetJdkVersion() {
        return this.isSetJdkVersion;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setJdkVersion(@NotNull JavaSdkVersion jdkVersion) {
        if (jdkVersion == null) {
            JavaProjectData.$$$reportNull$$$0(9);
        }
        this.isSetJdkVersion = true;
        this.jdkVersion = jdkVersion;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setJdkVersion(@Nullable String jdk) {
        JavaSdkVersion sdkVersion = JavaProjectData.resolveSdkVersion(jdk);
        if (sdkVersion == null) {
            return;
        }
        this.setJdkVersion(sdkVersion);
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static JavaSdkVersion resolveSdkVersion(@Nullable String jdk) {
        if (jdk == null) {
            return null;
        }
        try {
            int version = Integer.parseInt(jdk.trim());
            JavaSdkVersion sdkVersion = JavaProjectData.resolveSdkVersion(version);
            if (sdkVersion != null) {
                return sdkVersion;
            }
        }
        catch (NumberFormatException version) {
            // empty catch block
        }
        Matcher matcher = JDK_VERSION_PATTERN.matcher(jdk);
        if (!matcher.matches()) {
            return null;
        }
        String versionAsString = matcher.group(1);
        try {
            return JavaProjectData.resolveSdkVersion(Integer.parseInt(versionAsString));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Nullable
    private static JavaSdkVersion resolveSdkVersion(int version) {
        if (version < 0 || version >= JavaSdkVersion.values().length) {
            LOG.warn(String.format("Unsupported jdk version detected (%d). Expected to get number from range [0; %d]", version, JavaSdkVersion.values().length));
            return null;
        }
        for (JavaSdkVersion sdkVersion : JavaSdkVersion.values()) {
            if (sdkVersion.ordinal() != version) continue;
            return sdkVersion;
        }
        assert (false) : version + ", max value: " + JavaSdkVersion.values().length;
        return null;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.languageLevel;
        if (languageLevel == null) {
            JavaProjectData.$$$reportNull$$$0(10);
        }
        return languageLevel;
    }

    public void setLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaProjectData.$$$reportNull$$$0(11);
        }
        this.languageLevel = level;
    }

    public void setLanguageLevel(@Nullable String languageLevel) {
        LanguageLevel level = LanguageLevel.parse((String)languageLevel);
        if (level != null) {
            this.languageLevel = level;
        }
    }

    @Nullable
    public String getTargetBytecodeVersion() {
        return this.targetBytecodeVersion;
    }

    public void setTargetBytecodeVersion(@Nullable String targetBytecodeVersion) {
        this.targetBytecodeVersion = targetBytecodeVersion;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.jdkVersion);
        result = 31 * result + this.languageLevel.hashCode();
        result = 31 * result + Objects.hashCode(this.targetBytecodeVersion);
        result = 31 * result + this.compileOutputPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaProjectData project = (JavaProjectData)((Object)o);
        if (!this.compileOutputPath.equals(project.compileOutputPath)) {
            return false;
        }
        if (Objects.equals(this.jdkVersion, project.jdkVersion)) {
            return false;
        }
        if (Objects.equals(this.languageLevel, project.languageLevel)) {
            return false;
        }
        return !Objects.equals(this.targetBytecodeVersion, project.targetBytecodeVersion);
    }

    public String toString() {
        return "java project";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileOutputPath";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalSystem/JavaProjectData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkVersion";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalSystem/JavaProjectData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileOutputPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCompileOutputPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setJdkVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

