/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FindPackageUsagesDialog
extends JavaFindUsagesDialog<JavaPackageFindUsagesOptions> {
    private StateRestoringCheckBox myCbUsages;
    private StateRestoringCheckBox myCbClassesUsages;

    public FindPackageUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    public JComponent getPreferredFocusedControl() {
        return this.myCbUsages;
    }

    @Override
    public void calcFindUsagesOptions(JavaPackageFindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        options.isUsages = FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbUsages);
        if (FindPackageUsagesDialog.isToChange((JCheckBox)this.myCbClassesUsages)) {
            options.isClassesUsages = FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbClassesUsages);
        }
        options.isSkipPackageStatements = false;
        options.isSkipImportStatements = false;
        FUCounterUsageLogger.getInstance().logEvent("java.find.usages", "find.package.started", this.createFeatureUsageData(options));
    }

    @Override
    protected FeatureUsageData createFeatureUsageData(JavaPackageFindUsagesOptions options) {
        FeatureUsageData data = super.createFeatureUsageData(options);
        data.addData("classesUsages", options.isClassesUsages);
        return data;
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JavaBundle.message((String)"find.what.group", (Object[])new Object[0])));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        this.myCbUsages = this.addCheckboxToPanel(JavaBundle.message((String)"find.what.usages.checkbox", (Object[])new Object[0]), ((JavaPackageFindUsagesOptions)((Object)this.getFindUsagesOptions())).isUsages, findWhatPanel, true);
        this.myCbClassesUsages = this.addCheckboxToPanel(JavaBundle.message((String)"find.what.usages.of.classes.and.interfaces", (Object[])new Object[0]), ((JavaPackageFindUsagesOptions)((Object)this.getFindUsagesOptions())).isClassesUsages, findWhatPanel, true);
        return findWhatPanel;
    }

    protected void update() {
        if (this.myCbToSearchForTextOccurrences != null) {
            if (FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbUsages)) {
                this.myCbToSearchForTextOccurrences.makeSelectable();
            } else {
                this.myCbToSearchForTextOccurrences.makeUnselectable(false);
            }
        }
        boolean hasSelected = FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbUsages) || FindPackageUsagesDialog.isSelected((JCheckBox)this.myCbClassesUsages);
        this.setOKActionEnabled(hasSelected);
    }
}

