/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library.impl;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.RequiredFrameworkVersion;
import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.framework.library.impl.DownloadableLibraryPropertiesEditor;
import com.intellij.framework.library.impl.LibraryVersionsFetcher;
import com.intellij.ide.util.frameworkSupport.CustomLibraryDescriptionImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class DownloadableLibraryServiceImpl
extends DownloadableLibraryService {
    private static final Logger LOG = Logger.getInstance(DownloadableLibraryServiceImpl.class);

    @Override
    @NotNull
    public DownloadableLibraryDescription createLibraryDescription(@NotNull String groupId, URL ... localUrls) {
        if (groupId == null) {
            DownloadableLibraryServiceImpl.$$$reportNull$$$0(0);
        }
        if (localUrls == null) {
            DownloadableLibraryServiceImpl.$$$reportNull$$$0(1);
        }
        return new LibraryVersionsFetcher(groupId, localUrls){

            @NotNull
            protected FrameworkAvailabilityCondition createAvailabilityCondition(Artifact version) {
                RequiredFrameworkVersion groupVersion = version.getRequiredFrameworkVersion();
                if (groupVersion != null) {
                    return new FrameworkLibraryAvailabilityCondition(groupVersion.myGroupId, groupVersion.myVersion);
                }
                FrameworkAvailabilityCondition frameworkAvailabilityCondition = FrameworkAvailabilityCondition.ALWAYS_TRUE;
                if (frameworkAvailabilityCondition == null) {
                    1.$$$reportNull$$$0(0);
                }
                return frameworkAvailabilityCondition;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl$1", "createAvailabilityCondition"));
            }
        };
    }

    @Override
    @NotNull
    public CustomLibraryDescription createDescriptionForType(Class<? extends DownloadableLibraryType> typeClass) {
        DownloadableLibraryType libraryType = (DownloadableLibraryType)((Object)LibraryType.EP_NAME.findExtension(typeClass));
        LOG.assertTrue(libraryType != null, typeClass);
        return new CustomLibraryDescriptionImpl(libraryType);
    }

    @Override
    @NotNull
    public LibraryPropertiesEditor createDownloadableLibraryEditor(@NotNull DownloadableLibraryDescription description, @NotNull LibraryEditorComponent<LibraryVersionProperties> editorComponent, @NotNull DownloadableLibraryType libraryType) {
        if (description == null) {
            DownloadableLibraryServiceImpl.$$$reportNull$$$0(2);
        }
        if (editorComponent == null) {
            DownloadableLibraryServiceImpl.$$$reportNull$$$0(3);
        }
        if (libraryType == null) {
            DownloadableLibraryServiceImpl.$$$reportNull$$$0(4);
        }
        return new DownloadableLibraryPropertiesEditor(description, editorComponent, libraryType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localUrls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLibraryDescription";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDownloadableLibraryEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FrameworkLibraryAvailabilityCondition
    extends FrameworkAvailabilityCondition {
        private final String myGroupId;
        private final String myVersionId;

        FrameworkLibraryAvailabilityCondition(String groupId, String versionId) {
            this.myGroupId = groupId;
            this.myVersionId = versionId;
        }

        public boolean isAvailableFor(@NotNull FrameworkSupportModel model) {
            Object selectedVersion;
            if (model == null) {
                FrameworkLibraryAvailabilityCondition.$$$reportNull$$$0(0);
            }
            return (selectedVersion = ((FrameworkSupportModelBase)model).getSelectedVersion(this.myGroupId)) != null && this.myVersionId.equals(selectedVersion.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/framework/library/impl/DownloadableLibraryServiceImpl$FrameworkLibraryAvailabilityCondition", "isAvailableFor"));
        }
    }
}

