/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntheticElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public class JavaFileIconPatcher
implements FileIconPatcher {
    public Icon patchIcon(Icon baseIcon, VirtualFile file, int flags, Project project) {
        PsiClass[] classes2;
        if (project == null) {
            return baseIcon;
        }
        FileType fileType = file.getFileType();
        if (fileType == JavaFileType.INSTANCE && !FileIndexUtil.isJavaSourceFile((Project)project, (VirtualFile)file)) {
            return PlatformIcons.JAVA_OUTSIDE_SOURCE_ICON;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof PsiClassOwner && psiFile.getViewProvider().getBaseLanguage() == JavaLanguage.INSTANCE && (classes2 = ((PsiClassOwner)psiFile).getClasses()).length > 0) {
            String fileName = file.getNameWithoutExtension();
            for (PsiClass aClass : classes2) {
                if (aClass instanceof SyntheticElement) {
                    return baseIcon;
                }
                if (!Comparing.strEqual((String)aClass.getName(), (String)fileName)) continue;
                return aClass.getIcon(flags);
            }
            return classes2[classes2.length - 1].getIcon(flags);
        }
        return baseIcon;
    }
}

