/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.icons.AllIcons;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.method.MethodHierarchyTreeStructure;
import com.intellij.ide.hierarchy.method.MethodHierarchyUtil;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.ui.IconManager;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    private Icon myRawIcon;
    private Icon myStateIcon;
    private MethodHierarchyTreeStructure myTreeStructure;

    MethodHierarchyNodeDescriptor(@NotNull Project project, HierarchyNodeDescriptor parentDescriptor, @NotNull PsiElement aClass, boolean isBase, @NotNull MethodHierarchyTreeStructure treeStructure) {
        if (project == null) {
            MethodHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            MethodHierarchyNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (treeStructure == null) {
            MethodHierarchyNodeDescriptor.$$$reportNull$$$0(2);
        }
        super(project, (NodeDescriptor)parentDescriptor, aClass, isBase);
        this.myTreeStructure = treeStructure;
    }

    public final void setTreeStructure(MethodHierarchyTreeStructure treeStructure) {
        this.myTreeStructure = treeStructure;
    }

    @Nullable
    PsiMethod getMethod(PsiClass aClass, boolean checkBases) {
        try {
            return MethodHierarchyUtil.findBaseMethodInClass(this.myTreeStructure.getBaseMethod(), aClass, checkBases);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    public final PsiElement getPsiClass() {
        return this.getPsiElement();
    }

    public final PsiElement getTargetElement() {
        PsiElement element = this.getPsiClass();
        if (!(element instanceof PsiClass)) {
            return element;
        }
        PsiClass aClass = (PsiClass)this.getPsiClass();
        if (!aClass.isValid()) {
            return null;
        }
        PsiMethod method = this.getMethod(aClass, false);
        if (method != null) {
            return method;
        }
        return aClass;
    }

    public final boolean update() {
        Icon newStateIcon;
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes2 = super.update();
        PsiElement psiClass = this.getPsiClass();
        if (psiClass == null) {
            return this.invalidElement();
        }
        Icon newRawIcon = psiClass.getIcon(flags);
        Icon icon = newStateIcon = psiClass instanceof PsiClass ? this.calculateState((PsiClass)psiClass) : AllIcons.Hierarchy.MethodDefined;
        if (changes2 || newRawIcon != this.myRawIcon || newStateIcon != this.myStateIcon) {
            changes2 = true;
            this.myRawIcon = newRawIcon;
            this.myStateIcon = newStateIcon;
            Icon newIcon = this.myRawIcon;
            if (this.myIsBase) {
                newIcon = this.getBaseMarkerIcon(newIcon);
            }
            if (this.myStateIcon != null) {
                newIcon = IconManager.getInstance().createRowIcon(new Icon[]{this.myStateIcon, newIcon});
            }
            this.setIcon(newIcon);
        }
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if (psiClass instanceof PsiClass) {
            this.myHighlightedText.getEnding().addText(ClassPresentationUtil.getNameForClass((PsiClass)psiClass, false), classNameAttributes);
            this.myHighlightedText.getEnding().addText("  (" + JavaHierarchyUtil.getPackageName((PsiClass)psiClass) + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        } else if (psiClass instanceof PsiFunctionalExpression) {
            this.myHighlightedText.getEnding().addText(ClassPresentationUtil.getFunctionalExpressionPresentation((PsiFunctionalExpression)psiClass, false));
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes2 = true;
        }
        return changes2;
    }

    private Icon calculateState(PsiClass psiClass) {
        boolean hasBaseImplementation;
        PsiMethod method = this.getMethod(psiClass, false);
        if (method != null) {
            if (method.hasModifierProperty("abstract")) {
                return null;
            }
            return AllIcons.Hierarchy.MethodDefined;
        }
        if (this.myTreeStructure.isSuperClassForBaseClass(psiClass)) {
            return AllIcons.Hierarchy.MethodNotDefined;
        }
        boolean isAbstractClass = psiClass.hasModifierProperty("abstract");
        PsiMethod baseClassMethod = this.getMethod(psiClass, true);
        boolean bl = hasBaseImplementation = baseClassMethod != null && !baseClassMethod.hasModifierProperty("abstract");
        if (hasBaseImplementation || isAbstractClass) {
            return AllIcons.Hierarchy.MethodNotDefined;
        }
        return AllIcons.Hierarchy.ShouldDefineMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "treeStructure";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/hierarchy/method/MethodHierarchyNodeDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

