/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;

final class MethodHierarchyUtil {
    MethodHierarchyUtil() {
    }

    public static PsiMethod findBaseMethodInClass(PsiMethod baseMethod, PsiClass aClass, boolean checkBases) {
        PsiMethod[] methods;
        if (baseMethod == null) {
            return null;
        }
        if (MethodHierarchyUtil.cannotBeOverridding(baseMethod)) {
            return null;
        }
        PsiMethod subMethod = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)baseMethod, (boolean)checkBases);
        if (subMethod != null) {
            return subMethod;
        }
        for (PsiMethod method : methods = baseMethod.findSuperMethods(aClass)) {
            if (!checkBases && method.getContainingClass() != aClass) continue;
            return method;
        }
        return null;
    }

    private static boolean cannotBeOverridding(PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        return parentClass == null || method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("private");
    }
}

