/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.hierarchy.type.SubtypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.SupertypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.type.TypeHierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeHierarchyBrowser
extends TypeHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance(TypeHierarchyBrowser.class);

    public TypeHierarchyBrowser(Project project, PsiClass psiClass) {
        super(project, (PsiElement)psiClass);
    }

    protected boolean isInterface(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(0);
        }
        return psiElement instanceof PsiClass && ((PsiClass)psiElement).isInterface();
    }

    protected void createTrees(@NotNull Map<String, JTree> trees) {
        if (trees == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(1);
        }
        this.createTreeAndSetupCommonActions(trees, "TypeHierarchyPopupMenu");
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(2);
        }
        super.prependActions(actionGroup);
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.ChangeScopeAction(){

            protected boolean isEnabled() {
                return !Comparing.strEqual((String)TypeHierarchyBrowser.this.getCurrentViewType(), (String)TypeHierarchyBrowserBase.getSupertypesHierarchyType());
            }
        });
    }

    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        if (typeName == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(3);
        }
        if (element == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(4);
        }
        return MessageFormat.format(typeName, ClassPresentationUtil.getNameForClass((PsiClass)element, false));
    }

    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(5);
        }
        if (!(descriptor instanceof TypeHierarchyNodeDescriptor)) {
            return null;
        }
        return ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
    }

    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(6);
        }
        return element instanceof PsiClass;
    }

    protected boolean isApplicableElementForBaseOn(@NotNull PsiElement element) {
        if (element == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(7);
        }
        return element instanceof PsiClass && !"java.lang.Object".equals(((PsiClass)element).getQualifiedName());
    }

    protected Comparator<NodeDescriptor<?>> getComparator() {
        return JavaHierarchyUtil.getComparator(this.myProject);
    }

    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(8);
        }
        if (psiElement == null) {
            TypeHierarchyBrowser.$$$reportNull$$$0(9);
        }
        if (TypeHierarchyBrowser.getSupertypesHierarchyType().equals(typeName)) {
            return new SupertypesHierarchyTreeStructure(this.myProject, (PsiClass)psiElement);
        }
        if (TypeHierarchyBrowser.getSubtypesHierarchyType().equals(typeName)) {
            return new SubtypesHierarchyTreeStructure(this.myProject, (PsiClass)psiElement, this.getCurrentScopeType());
        }
        if (TypeHierarchyBrowser.getTypeHierarchyType().equals(typeName)) {
            return new TypeHierarchyTreeStructure(this.myProject, (PsiClass)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    protected boolean canBeDeleted(PsiElement psiElement) {
        return psiElement instanceof PsiClass && !(psiElement instanceof PsiAnonymousClass);
    }

    protected String getQualifiedName(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            return ((PsiClass)psiElement).getQualifiedName();
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trees";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/hierarchy/type/TypeHierarchyBrowser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInterface";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTrees";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prependActions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getContentDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementFromDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableElementForBaseOn";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createHierarchyTreeStructure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

