/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewProjectUtil {
    private static final Logger LOG = Logger.getInstance(NewProjectUtil.class);

    private NewProjectUtil() {
    }

    @Deprecated
    public static void createNewProject(@Nullable Project projectToClose, @NotNull AbstractProjectWizard wizard) {
        if (wizard == null) {
            NewProjectUtil.$$$reportNull$$$0(0);
        }
        NewProjectUtil.createNewProject(wizard);
    }

    public static void createNewProject(@NotNull AbstractProjectWizard wizard) {
        if (wizard == null) {
            NewProjectUtil.$$$reportNull$$$0(1);
        }
        String title = JavaUiBundle.message("project.new.wizard.progress.title", new Object[0]);
        Runnable warmUp = () -> ProjectManager.getInstance().getDefaultProject();
        boolean proceed = ProgressManager.getInstance().runProcessWithProgressSynchronously(warmUp, title, true, null);
        if (proceed && wizard.showAndGet()) {
            NewProjectUtil.createFromWizard(wizard);
        }
    }

    public static Project createFromWizard(@NotNull AbstractProjectWizard wizard) {
        if (wizard == null) {
            NewProjectUtil.$$$reportNull$$$0(2);
        }
        return NewProjectUtil.createFromWizard(wizard, null);
    }

    public static Project createFromWizard(@NotNull AbstractProjectWizard wizard, @Nullable Project projectToClose) {
        if (wizard == null) {
            NewProjectUtil.$$$reportNull$$$0(3);
        }
        try {
            return NewProjectUtil.doCreate(wizard, projectToClose);
        }
        catch (IOException e) {
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((String)e.getMessage(), (String)JavaUiBundle.message("dialog.title.project.initialization.failed", new Object[0])));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Project doCreate(@NotNull AbstractProjectWizard wizard, @Nullable Project projectToClose) throws IOException {
        if (wizard == null) {
            NewProjectUtil.$$$reportNull$$$0(4);
        }
        String projectFilePath = wizard.getNewProjectFilePath();
        for (Project p : ProjectUtil.getOpenProjects()) {
            if (!ProjectUtil.isSameProject((Path)Paths.get(projectFilePath, new String[0]), (Project)p)) continue;
            ProjectUtil.focusProjectWindow((Project)p, (boolean)false);
            return null;
        }
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        LOG.debug("builder " + projectBuilder);
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        try {
            Project newProject;
            String name2;
            Path projectDir;
            Path projectFile = Paths.get(projectFilePath, new String[0]);
            if (wizard.getStorageScheme() == StorageScheme.DEFAULT) {
                projectDir = projectFile.getParent();
                if (projectDir == null) {
                    throw new IOException("Cannot create project in '" + projectFilePath + "': no parent file exists");
                }
            } else {
                projectDir = projectFile;
            }
            Files.createDirectories(projectDir, new FileAttribute[0]);
            if (projectBuilder == null || !projectBuilder.isUpdate()) {
                name2 = wizard.getProjectName();
                newProject = projectBuilder == null ? projectManager.newProject(projectFile, OpenProjectTask.newProject().withProjectName(name2)) : projectBuilder.createProject(name2, projectFilePath);
            } else {
                newProject = projectToClose;
            }
            if (newProject == null) {
                name2 = projectToClose;
                return name2;
            }
            Sdk jdk = wizard.getNewProjectJdk();
            if (jdk != null) {
                CommandProcessor.getInstance().executeCommand(newProject, () -> ApplicationManager.getApplication().runWriteAction(() -> NewProjectUtil.applyJdkToProject(newProject, jdk)), null, null);
            }
            String compileOutput = wizard.getNewCompileOutput();
            NewProjectUtil.setCompilerOutputPath(newProject, compileOutput);
            if (projectBuilder != null) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    newProject.save();
                }
                if (!projectBuilder.validate(projectToClose, newProject)) {
                    Project project = projectToClose;
                    return project;
                }
                projectBuilder.commit(newProject, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                boolean needToOpenProjectStructure = projectBuilder == null || projectBuilder.isOpenProjectSettingsAfter();
                StartupManager.getInstance((Project)newProject).registerPostStartupActivity(() -> ApplicationManager.getApplication().invokeLater(() -> {
                    if (needToOpenProjectStructure) {
                        ModulesConfigurator.showDialog(newProject, null, null);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)newProject).getToolWindow("Project");
                        if (toolWindow != null) {
                            toolWindow.activate(null);
                        }
                    }, ModalityState.NON_MODAL, newProject.getDisposed());
                }, ModalityState.NON_MODAL, newProject.getDisposed()));
            }
            if (newProject != projectToClose) {
                ProjectUtil.updateLastProjectLocation((Path)projectFile);
                ProjectManagerEx.getInstanceEx().openProject(projectDir, OpenProjectTask.withCreatedProject((Project)newProject).withProjectName(projectFile.getFileName().toString()));
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                SaveAndSyncHandler.getInstance().scheduleProjectSave(newProject);
            }
            Project project = newProject;
            return project;
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    public static void setCompilerOutputPath(@NotNull Project project, @NotNull String path) {
        if (project == null) {
            NewProjectUtil.$$$reportNull$$$0(5);
        }
        if (path == null) {
            NewProjectUtil.$$$reportNull$$$0(6);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)project);
            if (extension != null) {
                String canonicalPath = path;
                try {
                    canonicalPath = FileUtil.resolveShortWindowsName((String)path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                extension.setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)canonicalPath));
            }
        }), null, null);
    }

    public static void applyJdkToProject(@NotNull Project project, @NotNull Sdk jdk) {
        if (project == null) {
            NewProjectUtil.$$$reportNull$$$0(7);
        }
        if (jdk == null) {
            NewProjectUtil.$$$reportNull$$$0(8);
        }
        ProjectRootManagerEx rootManager = ProjectRootManagerEx.getInstanceEx((Project)project);
        rootManager.setProjectSdk(jdk);
        JavaSdkVersion version = JavaSdk.getInstance().getVersion(jdk);
        if (version != null) {
            LanguageLevel maxLevel = version.getMaxLanguageLevel();
            LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
            LanguageLevelProjectExtension ext = LanguageLevelProjectExtension.getInstance((Project)project);
            if (extension.isDefault() || maxLevel.compareTo((Enum)ext.getLanguageLevel()) < 0) {
                ext.setLanguageLevel(maxLevel);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/NewProjectUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewProject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromWizard";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doCreate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setCompilerOutputPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "applyJdkToProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

