/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibrariesLayoutPanel;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.fileTypes.FileTypeManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesDetectionStep
extends AbstractStepWithProgress<List<LibraryDescriptor>> {
    private final ProjectFromSourcesBuilder myBuilder;
    private final ProjectDescriptor myProjectDescriptor;
    private final ModuleInsight myInsight;
    private final Icon myIcon;
    private final String myHelpId;
    private LibrariesLayoutPanel myLibrariesPanel;
    private int myPreviousStateHashCode = -1;

    public LibrariesDetectionStep(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, ModuleInsight insight, Icon icon, @NonNls String helpId) {
        super("Stop library analysis?");
        this.myBuilder = builder;
        this.myProjectDescriptor = projectDescriptor;
        this.myInsight = insight;
        this.myIcon = icon;
        this.myHelpId = helpId;
    }

    public void updateDataModel() {
        this.myProjectDescriptor.setLibraries(this.myLibrariesPanel.getChosenEntries());
    }

    @Override
    protected JComponent createResultsPanel() {
        this.myLibrariesPanel = new LibrariesLayoutPanel(this.myInsight);
        return this.myLibrariesPanel;
    }

    @Override
    protected String getProgressText() {
        return "Searching for libraries. Please wait.";
    }

    @Override
    protected boolean shouldRunProgress() {
        int currentHash = this.calcStateHashCode();
        try {
            boolean bl = currentHash != this.myPreviousStateHashCode;
            return bl;
        }
        finally {
            this.myPreviousStateHashCode = currentHash;
        }
    }

    private int calcStateHashCode() {
        int hash = this.myBuilder.getBaseProjectPath().hashCode();
        for (DetectedSourceRoot root : LibrariesDetectionStep.getSourceRoots(this.myInsight, this.myBuilder)) {
            hash = 31 * hash + root.getDirectory().hashCode();
        }
        return hash;
    }

    @Nullable
    public static List<LibraryDescriptor> calculate(@NotNull ModuleInsight insight, @NotNull ProjectFromSourcesBuilder builder) {
        if (insight == null) {
            LibrariesDetectionStep.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            LibrariesDetectionStep.$$$reportNull$$$0(1);
        }
        List<DetectedSourceRoot> sourceRoots = LibrariesDetectionStep.getSourceRoots(insight, builder);
        HashSet<String> ignored = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(FileTypeManager.getInstance().getIgnoredFilesList(), ";", false);
        while (tokenizer.hasMoreTokens()) {
            ignored.add(tokenizer.nextToken());
        }
        insight.setRoots(Collections.singletonList(new File(builder.getBaseProjectPath())), sourceRoots, ignored);
        insight.scanLibraries();
        return insight.getSuggestedLibraries();
    }

    @Override
    protected List<LibraryDescriptor> calculate() {
        return LibrariesDetectionStep.calculate(this.myInsight, this.myBuilder);
    }

    @NotNull
    private static List<DetectedSourceRoot> getSourceRoots(@NotNull ModuleInsight insight, @NotNull ProjectFromSourcesBuilder builder) {
        if (insight == null) {
            LibrariesDetectionStep.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            LibrariesDetectionStep.$$$reportNull$$$0(3);
        }
        ArrayList<DetectedSourceRoot> sourceRoots = new ArrayList<DetectedSourceRoot>();
        for (ProjectStructureDetector detector : (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()) {
            for (DetectedProjectRoot root : builder.getProjectRoots(detector)) {
                if (!insight.isApplicableRoot(root)) continue;
                sourceRoots.add((DetectedSourceRoot)root);
            }
        }
        ArrayList<DetectedSourceRoot> arrayList = sourceRoots;
        if (arrayList == null) {
            LibrariesDetectionStep.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    protected void onFinished(List<LibraryDescriptor> libraries2, boolean canceled) {
        this.myLibrariesPanel.rebuild();
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insight";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/importProject/LibrariesDetectionStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/importProject/LibrariesDetectionStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoots";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

