/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.diagnostic.PluginException;
import com.intellij.framework.FrameworkOrGroup;
import com.intellij.ide.util.newProjectWizard.FrameworkGroupNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.ui.EmptyIcon;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportNodeBase<T extends FrameworkOrGroup>
extends CheckedTreeNode {
    private static final Logger LOG = Logger.getInstance(FrameworkSupportNodeBase.class);
    private final FrameworkSupportNodeBase myParentNode;

    public FrameworkSupportNodeBase(T userObject, FrameworkSupportNodeBase parentNode) {
        super(userObject);
        this.setChecked(false);
        this.myParentNode = parentNode;
        if (parentNode != null) {
            parentNode.add((MutableTreeNode)((Object)this));
        }
    }

    public T getUserObject() {
        return (T)((FrameworkOrGroup)super.getUserObject());
    }

    public static void sortByName(@Nullable List<? extends FrameworkSupportNodeBase> nodes, @Nullable Comparator<? super FrameworkSupportNodeBase> comparator) {
        if (nodes == null) {
            return;
        }
        nodes.sort((o1, o2) -> {
            int compare;
            if (comparator != null && (compare = comparator.compare((FrameworkSupportNodeBase)((Object)((Object)o1)), (FrameworkSupportNodeBase)((Object)((Object)o2)))) != 0) {
                return compare;
            }
            if (o1 instanceof FrameworkGroupNode && !(o2 instanceof FrameworkGroupNode)) {
                return -1;
            }
            if (o2 instanceof FrameworkGroupNode && !(o1 instanceof FrameworkGroupNode)) {
                return 1;
            }
            if (o1.getChildCount() < o2.getChildCount()) {
                return 1;
            }
            if (o1.getChildCount() > o2.getChildCount()) {
                return -1;
            }
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        });
        for (FrameworkSupportNodeBase frameworkSupportNodeBase : nodes) {
            Vector children = frameworkSupportNodeBase.children;
            FrameworkSupportNodeBase.sortByName(children, null);
        }
    }

    @NotNull
    protected final String getTitle() {
        String string = this.getUserObject().getPresentableName();
        if (string == null) {
            FrameworkSupportNodeBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public final Icon getIcon() {
        Icon icon = this.getUserObject().getIcon();
        if (icon == null) {
            Class<?> aClass = this.getUserObject().getClass();
            PluginException.logPluginError((Logger)LOG, (String)("FrameworkOrGroup::getIcon returns null for " + aClass), null, aClass);
            Icon icon2 = EmptyIcon.ICON_16;
            if (icon2 == null) {
                FrameworkSupportNodeBase.$$$reportNull$$$0(1);
            }
            return icon2;
        }
        Icon icon3 = icon;
        if (icon3 == null) {
            FrameworkSupportNodeBase.$$$reportNull$$$0(2);
        }
        return icon3;
    }

    @NotNull
    public final String getId() {
        String string = this.getUserObject().getId();
        if (string == null) {
            FrameworkSupportNodeBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public List<FrameworkSupportNodeBase> getChildren() {
        Vector vector = this.children != null ? this.children : Collections.emptyList();
        if (vector == null) {
            FrameworkSupportNodeBase.$$$reportNull$$$0(4);
        }
        return vector;
    }

    public FrameworkSupportNodeBase getParentNode() {
        return this.myParentNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/util/newProjectWizard/FrameworkSupportNodeBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

