/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkForModuleStep
extends ModuleWizardStep {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSdksModel mySdksModel;
    @NotNull
    private final JdkComboBox myJdkChooser;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final WizardContext myContext;
    @Nullable
    private final String myHelpId;
    @NotNull
    private final JButton mySetAsDefaultButton;

    public ProjectJdkForModuleStep(@NotNull WizardContext context, @Nullable SdkType type2) {
        if (context == null) {
            ProjectJdkForModuleStep.$$$reportNull$$$0(0);
        }
        this(context, type2, null);
    }

    public ProjectJdkForModuleStep(@NotNull WizardContext context, @Nullable SdkType type2, @Nullable @NonNls String helpId) {
        if (context == null) {
            ProjectJdkForModuleStep.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myHelpId = helpId;
        Project project = context.getProject();
        this.myProject = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        ProjectStructureConfigurable projectConfig = ProjectStructureConfigurable.getInstance(this.myProject);
        this.mySdksModel = projectConfig.getProjectJdksModel();
        this.myJdkChooser = new JdkComboBox(this.myProject, this.mySdksModel, (Condition<? super SdkTypeId>)((Condition)sdk -> sdk instanceof SdkType && (type2 == null || type2.equals(sdk))), null, null, null);
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEtchedBorder());
        JLabel label = new JLabel(JavaUiBundle.message("prompt.please.select.module.jdk", type2 == null ? "SDK" : type2.getPresentableName()));
        label.setUI((LabelUI)new MultiLineLabelUI());
        this.myPanel.add((Component)label, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.create((int)8, (int)10), 0, 0));
        JLabel jdkLabel = new JLabel(JavaUiBundle.message("label.project.jdk", new Object[0]));
        jdkLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        this.myPanel.add((Component)jdkLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)8, (int)10, (int)0, (int)10), 0, 0));
        jdkLabel.setLabelFor((Component)((Object)this.myJdkChooser));
        this.myPanel.add((Component)((Object)this.myJdkChooser), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)2, (int)10, (int)10, (int)5), 0, 0));
        this.mySetAsDefaultButton = new JButton(JavaUiBundle.message("button.set.default", new Object[0]));
        this.mySetAsDefaultButton.setMnemonic('D');
        this.myPanel.add((Component)this.mySetAsDefaultButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 18, 0, (Insets)JBUI.insets((int)2, (int)10, (int)10, (int)5), 0, 0));
        final Project defaultProject = ProjectManagerEx.getInstanceEx().getDefaultProject();
        this.mySetAsDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk jdk = ProjectJdkForModuleStep.this.getJdk();
                Runnable runnable = () -> ProjectRootManagerEx.getInstanceEx((Project)defaultProject).setProjectSdk(jdk);
                ApplicationManager.getApplication().runWriteAction(runnable);
                ProjectJdkForModuleStep.this.mySetAsDefaultButton.setEnabled(false);
            }
        });
        this.myJdkChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectJdkForModuleStep.this.mySetAsDefaultButton.setEnabled(ProjectJdkForModuleStep.this.getJdk() != ProjectRootManagerEx.getInstanceEx((Project)defaultProject).getProjectSdk());
            }
        });
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJdkChooser;
    }

    @Nullable
    public String getHelpId() {
        return this.myHelpId;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        this.myContext.setProjectJdk(this.getJdk());
    }

    public void updateStep() {
        this.mySdksModel.reset(this.myProject);
        this.myJdkChooser.reloadModel();
        Sdk defaultJdk = this.getDefaultJdk();
        if (defaultJdk != null) {
            this.myJdkChooser.setSelectedJdk(defaultJdk);
        }
        this.mySetAsDefaultButton.setEnabled(defaultJdk != null);
    }

    @Nullable
    public Sdk getJdk() {
        return this.myJdkChooser.getSelectedJdk();
    }

    @Deprecated
    public Object @NotNull [] getAllJdks() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            ProjectJdkForModuleStep.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public Icon getIcon() {
        return this.myContext.getStepIcon();
    }

    @Nullable
    private Sdk getDefaultJdk() {
        Project defaultProject = ProjectManagerEx.getInstanceEx().getDefaultProject();
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)defaultProject).getProjectSdk();
        if (sdk == null) {
            sdk = AddModuleWizard.getMostRecentSuitableSdk(this.myContext);
        }
        return sdk;
    }

    public boolean validate() {
        block3: {
            int result;
            Sdk jdk = this.myJdkChooser.getSelectedJdk();
            if (jdk == null && (result = Messages.showOkCancelDialog((String)JavaUiBundle.message("prompt.confirm.project.no.jdk", new Object[0]), (String)JavaUiBundle.message("title.no.jdk.specified", new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon(), null)) != 0) {
                return false;
            }
            try {
                this.mySdksModel.apply(null, true);
            }
            catch (ConfigurationException e) {
                if (Messages.showDialog((String)JavaUiBundle.message("dialog.message.0.do.you.want.to.proceed", e.getMessage()), (String)e.getTitle(), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) == 0) break block3;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/ProjectJdkForModuleStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/ProjectJdkForModuleStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

