/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.swing.Icon;

public class ProjectWizardUtil {
    private ProjectWizardUtil() {
    }

    public static String findNonExistingFileName(String searchDirectory, String preferredName, String extension) {
        int idx = 0;
        String fileName;
        while (Files.exists(Paths.get(searchDirectory, fileName = (idx > 0 ? preferredName + idx : preferredName) + extension), new LinkOption[0])) {
            ++idx;
        }
        return fileName;
    }

    public static boolean createDirectoryIfNotExists(String promptPrefix, String directoryPath, boolean promptUser) {
        Path dir = Paths.get(directoryPath, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            if (promptUser) {
                String ide = ApplicationNamesInfo.getInstance().getFullProductName();
                String message2 = JavaUiBundle.message("prompt.project.wizard.directory.does.not.exist", promptPrefix, dir, ide);
                int answer = Messages.showOkCancelDialog((String)message2, (String)JavaUiBundle.message("title.directory.does.not.exist", new Object[0]), (String)IdeBundle.message((String)"button.create", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (answer != 0) {
                    return false;
                }
            }
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Logger.getInstance(ProjectWizardUtil.class).warn((Throwable)e);
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.failed.to.create.directory", (Object[])new Object[]{dir}), (String)CommonBundle.getErrorTitle());
                return false;
            }
        }
        if (!ProjectWizardUtil.isWritable(dir)) {
            Messages.showErrorDialog((String)JavaUiBundle.message("error.directory.read.only", dir), (String)CommonBundle.getErrorTitle());
            return false;
        }
        return true;
    }

    private static boolean isWritable(Path dir) {
        if (SystemInfo.isWindows) {
            try {
                Files.deleteIfExists(Files.createTempFile(dir, "probe_", ".txt", new FileAttribute[0]));
                return true;
            }
            catch (IOException e) {
                Logger.getInstance(ProjectWizardUtil.class).debug((Throwable)e);
                return false;
            }
        }
        return Files.isWritable(dir);
    }
}

