/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IdIterator;
import com.intellij.util.indexing.StorageException;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class InspectStubIndexAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(InspectStubIndexAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            InspectStubIndexAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Inspecting Stub Index", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ReadAction.run(() -> InspectStubIndexAction.actionPerformed(project, indicator));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/InspectStubIndexAction$1", "run"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void actionPerformed(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            InspectStubIndexAction.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            InspectStubIndexAction.$$$reportNull$$$0(2);
        }
        ArrayList fileIds = new ArrayList(FileBasedIndex.getInstance().getAllKeys(StubUpdatingIndex.INDEX_ID, project));
        TIntArrayList staleFileIds = new TIntArrayList();
        ArrayList staleFiles = new ArrayList();
        ArrayList mismatchedKeys = new ArrayList();
        indicator.setIndeterminate(false);
        AtomicInteger counter = new AtomicInteger();
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(fileIds, indicator, id -> {
            File ioFile;
            VirtualFile vFile;
            indicator.setFraction((double)counter.incrementAndGet() / (double)fileIds.size());
            if (!((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project).containsFileId(id.intValue())) {
                return true;
            }
            try {
                vFile = ManagingFS.getInstance().findFileById(id.intValue());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return true;
            }
            if (vFile == null) {
                try {
                    Map staleTree = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID).getIndexedFileData(id.intValue());
                    if (staleTree.isEmpty()) return true;
                    TIntArrayList tIntArrayList = staleFileIds;
                    synchronized (tIntArrayList) {
                        staleFileIds.add(id.intValue());
                        return true;
                    }
                }
                catch (StorageException ex) {
                    LOG.error((Throwable)ex);
                }
                return true;
            }
            if (vFile.isInLocalFileSystem() && !(ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vFile)).exists()) {
                List list = staleFiles;
                synchronized (list) {
                    staleFiles.add(vFile);
                    return true;
                }
            }
            Map data = FileBasedIndex.getInstance().getFileData(StubUpdatingIndex.INDEX_ID, vFile, project);
            if (data.isEmpty()) {
                return true;
            }
            try {
                SerializedStubTree tree = (SerializedStubTree)data.values().iterator().next();
                for (Map.Entry entry : tree.getStubIndicesValueMap().entrySet()) {
                    StubIndexKey stubIndexKey = (StubIndexKey)entry.getKey();
                    Set keys = ((Map)entry.getValue()).keySet();
                    for (Object key2 : keys) {
                        boolean found = false;
                        IdIterator ids = StubIndex.getInstance().getContainingIds(stubIndexKey, key2, project, GlobalSearchScope.allScope((Project)project));
                        while (ids.hasNext()) {
                            if (ids.next() != id.intValue()) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        List list = mismatchedKeys;
                        synchronized (list) {
                            mismatchedKeys.add(Trinity.create((Object)vFile, (Object)stubIndexKey, key2));
                        }
                    }
                    continue;
                    return true;
                }
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            return true;
        });
        LOG.info("Stub index analysis is finished for " + fileIds.size() + " records.");
        Object object = staleFileIds;
        synchronized (object) {
            if (!staleFileIds.isEmpty()) {
                LOG.info("Stale file ids: " + staleFileIds);
            }
        }
        object = staleFiles;
        synchronized (object) {
            if (!staleFiles.isEmpty()) {
                LOG.info("Stale files: " + staleFiles);
            }
        }
        object = mismatchedKeys;
        synchronized (object) {
            if (!mismatchedKeys.isEmpty()) {
                for (Trinity key2 : mismatchedKeys) {
                    LOG.info("mismatched key file = " + key2.getFirst() + " id = " + ((VirtualFileWithId)key2.getFirst()).getId() + " index = " + ((StubIndexKey)key2.getSecond()).getName() + " index key = " + key2.getThird());
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
        }
        objectArray[1] = "com/intellij/internal/InspectStubIndexAction";
        objectArray[2] = "actionPerformed";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

