/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptors;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.SerializationException;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryJarStatisticsService
implements DumbAware {
    private static final String FILE_NAME = "statistics/library-jar-statistics.xml";
    private static final LibraryJarStatisticsService ourInstance = new LibraryJarStatisticsService();
    private LibraryJarDescriptor[] ourDescriptors;

    @NotNull
    public static LibraryJarStatisticsService getInstance() {
        LibraryJarStatisticsService libraryJarStatisticsService = ourInstance;
        if (libraryJarStatisticsService == null) {
            LibraryJarStatisticsService.$$$reportNull$$$0(0);
        }
        return libraryJarStatisticsService;
    }

    public LibraryJarDescriptor @NotNull [] getTechnologyDescriptors() {
        if (this.ourDescriptors == null) {
            if (!StatisticsUploadAssistant.isSendAllowed()) {
                if (LibraryJarDescriptor.EMPTY == null) {
                    LibraryJarStatisticsService.$$$reportNull$$$0(1);
                }
                return LibraryJarDescriptor.EMPTY;
            }
            URL url = LibraryJarStatisticsService.createVersionsUrl();
            if (url == null) {
                if (LibraryJarDescriptor.EMPTY == null) {
                    LibraryJarStatisticsService.$$$reportNull$$$0(2);
                }
                return LibraryJarDescriptor.EMPTY;
            }
            LibraryJarDescriptors descriptors = LibraryJarStatisticsService.deserialize(url);
            LibraryJarDescriptor[] libraryJarDescriptorArray = this.ourDescriptors = descriptors == null ? LibraryJarDescriptor.EMPTY : descriptors.getDescriptors();
        }
        if (this.ourDescriptors == null) {
            LibraryJarStatisticsService.$$$reportNull$$$0(3);
        }
        return this.ourDescriptors;
    }

    @Nullable
    private static LibraryJarDescriptors deserialize(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        LibraryJarDescriptors libraryJarDescriptors = null;
        try {
            libraryJarDescriptors = (LibraryJarDescriptors)XmlSerializer.deserialize((URL)url, LibraryJarDescriptors.class);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        return libraryJarDescriptors;
    }

    @Nullable
    private static URL createVersionsUrl() {
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                String url = serviceUrl + "/" + FILE_NAME;
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/libraryJar/LibraryJarStatisticsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTechnologyDescriptors";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

