/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FindJarFix<T extends PsiElement>
implements IntentionAction,
Iconable,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(FindJarFix.class);
    private static final String CLASS_ROOT_URL = "http://findjar.com/class/";
    private static final String CLASS_PAGE_EXT = ".html";
    private static final String SERVICE_URL = "http://findjar.com";
    protected final T myRef;
    protected final Module myModule;
    protected JComponent myEditorComponent;

    public FindJarFix(T ref) {
        this.myRef = ref;
        this.myModule = ModuleUtilCore.findModuleForPsiElement(ref);
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            FindJarFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"quickfix.name.find.jar.on.web", (Object[])new Object[0]);
        if (string == null) {
            FindJarFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            FindJarFix.$$$reportNull$$$0(2);
        }
        return this.myRef.isValid() && JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", file.getResolveScope()) != null && this.myModule != null && FindJarFix.isFqnsOk(project, this.getPossibleFqns(this.myRef));
    }

    private static boolean isFqnsOk(Project project, List<String> fqns) {
        if (fqns.isEmpty()) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        for (String fqn : fqns) {
            if (facade.findClass(fqn, scope) == null) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            FindJarFix.$$$reportNull$$$0(3);
        }
        List<String> fqns = this.getPossibleFqns(this.myRef);
        this.myEditorComponent = editor.getComponent();
        if (fqns.size() > 1) {
            JBPopupFactory.getInstance().createPopupChooserBuilder(fqns).setTitle(JavaBundle.message((String)"popup.title.select.qualified.name", (Object[])new Object[0])).setItemChosenCallback(value2 -> this.findJarsForFqn((String)value2, editor)).createPopup().showInBestPositionFor(editor);
        } else if (fqns.size() == 1) {
            this.findJarsForFqn(fqns.get(0), editor);
        }
    }

    private void findJarsForFqn(final String fqn, final @NotNull Editor editor) {
        if (editor == null) {
            FindJarFix.$$$reportNull$$$0(4);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(editor.getProject(), JavaBundle.message((String)"progress.title.looking.for.libraries", (Object[])new Object[0]), true){
            final Map<String, String> libs;
            {
                super(arg0, arg1, arg2);
                this.libs = new HashMap<String, String>();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    String html = HttpRequests.request((String)(FindJarFix.CLASS_ROOT_URL + fqn.replace('.', '/') + FindJarFix.CLASS_PAGE_EXT)).readString(indicator);
                    indicator.checkCanceled();
                    Matcher matcher = URLUtil.HREF_PATTERN.matcher(html);
                    if (!matcher.find()) {
                        return;
                    }
                    do {
                        indicator.checkCanceled();
                        String pathToJar = matcher.group(1);
                        if (pathToJar == null || !pathToJar.startsWith("/jar/") && !pathToJar.startsWith("/class/../")) continue;
                        this.libs.put(matcher.group(2), FindJarFix.SERVICE_URL + pathToJar);
                    } while (matcher.find());
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }

            public void onSuccess() {
                if (this.libs.isEmpty()) {
                    HintManager.getInstance().showInformationHint(editor, "No libraries found for '" + fqn + "'");
                } else {
                    JBList libNames = new JBList((Collection)ContainerUtil.sorted(this.libs.keySet()));
                    libNames.installCellRenderer(o -> new JLabel((String)o, PlatformIcons.JAR_ICON, 2));
                    if (this.libs.size() == 1) {
                        String jarName = this.libs.keySet().iterator().next();
                        String url = this.libs.get(jarName);
                        FindJarFix.this.initiateDownload(url, jarName, editor.getProject());
                    } else {
                        JBPopupFactory.getInstance().createListPopupBuilder((JList)libNames).setTitle(JavaBundle.message((String)"popup.title.select.a.jar.file", (Object[])new Object[0])).setItemChoosenCallback(() -> {
                            String jarName = (String)libNames.getSelectedValue();
                            String url = this.libs.get(jarName);
                            if (url != null) {
                                FindJarFix.this.initiateDownload(url, jarName, editor.getProject());
                            }
                        }).createPopup().showInBestPositionFor(editor);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/FindJarFix$1", "run"));
            }
        });
    }

    private void initiateDownload(final @NotNull String url, final @NotNull String jarName, @Nullable Project project) {
        if (url == null) {
            FindJarFix.$$$reportNull$$$0(5);
        }
        if (jarName == null) {
            FindJarFix.$$$reportNull$$$0(6);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, JavaBundle.message((String)"progress.title.download.library.descriptor", (Object[])new Object[0]), true){
            private String jarUrl;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    String html = HttpRequests.request((String)url).readString(indicator);
                    indicator.checkCanceled();
                    Matcher matcher = URLUtil.HREF_PATTERN.matcher(html);
                    if (!matcher.find()) {
                        return;
                    }
                    do {
                        indicator.checkCanceled();
                        String jarUrl = matcher.group(1);
                        if (jarUrl == null || !jarUrl.endsWith(jarName)) continue;
                        this.jarUrl = jarUrl;
                        return;
                    } while (matcher.find());
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }

            public void onSuccess() {
                if (this.jarUrl != null) {
                    FindJarFix.this.downloadJar(this.jarUrl, jarName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/FindJarFix$2", "run"));
            }
        });
    }

    private void downloadJar(@NotNull String jarUrl, @NotNull String jarName) {
        Project project;
        String dirPath;
        if (jarUrl == null) {
            FindJarFix.$$$reportNull$$$0(7);
        }
        if (jarName == null) {
            FindJarFix.$$$reportNull$$$0(8);
        }
        VirtualFile toSelect = (dirPath = PropertiesComponent.getInstance((Project)(project = this.myModule.getProject())).getValue("findjar.last.used.dir")) == null ? null : LocalFileSystem.getInstance().findFileByIoFile(new File(dirPath));
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(JavaBundle.message((String)"chooser.title.select.path.to.save.jar", (Object[])new Object[0])).withDescription(JavaBundle.message((String)"chooser.text.choose.where.to.save.0", (Object[])new Object[]{jarName}));
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect);
        if (file != null) {
            PropertiesComponent.getInstance((Project)project).setValue("findjar.last.used.dir", file.getPath());
            DownloadableFileService downloader = DownloadableFileService.getInstance();
            DownloadableFileDescription description = downloader.createFileDescription(jarUrl, jarName);
            List jars = downloader.createDownloader(Collections.singletonList(description), jarName).downloadFilesWithProgress(file.getPath(), project, this.myEditorComponent);
            if (jars != null && jars.size() == 1) {
                WriteAction.run(() -> OrderEntryFix.addJarToRoots(((VirtualFile)jars.get(0)).getPresentableUrl(), this.myModule, this.myRef));
            }
        }
    }

    protected abstract Collection<String> getFqns(@NotNull T var1);

    protected List<String> getPossibleFqns(T ref) {
        Collection<String> fqns = this.getFqns(ref);
        ArrayList<String> res = new ArrayList<String>(fqns.size());
        for (String fqn : fqns) {
            String className2;
            int index;
            if (fqn.startsWith("java.") || fqn.startsWith("javax.swing.") || (index = fqn.lastIndexOf(46)) == -1 || (className2 = fqn.substring(index + 1)).length() == 0 || Character.isLowerCase(className2.charAt(0))) continue;
            res.add(fqn);
        }
        return res;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.WEB_ICON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarFinder/FindJarFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarFinder/FindJarFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findJarsForFqn";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initiateDownload";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "downloadJar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

