/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.ide.IdeBundle;
import com.intellij.jarFinder.SourceSearchException;
import com.intellij.jarFinder.SourceSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SonatypeSourceSearcher
extends SourceSearcher {
    private static final Logger LOG = Logger.getInstance(SonatypeSourceSearcher.class);

    @Override
    @Nullable
    public String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version, @NotNull VirtualFile classesJar) throws SourceSearchException {
        if (indicator == null) {
            SonatypeSourceSearcher.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            SonatypeSourceSearcher.$$$reportNull$$$0(1);
        }
        if (version == null) {
            SonatypeSourceSearcher.$$$reportNull$$$0(2);
        }
        if (classesJar == null) {
            SonatypeSourceSearcher.$$$reportNull$$$0(3);
        }
        try {
            List<Element> artifactList;
            indicator.setIndeterminate(true);
            indicator.setText(IdeBundle.message((String)"progress.message.connecting.to", (Object[])new Object[]{"https://oss.sonatype.org"}));
            indicator.checkCanceled();
            String url = "https://oss.sonatype.org/service/local/lucene/search?collapseresults=true&c=sources&a=" + artifactId + "&v=" + version;
            String groupId = SonatypeSourceSearcher.findMavenGroupId(classesJar, artifactId);
            if (groupId != null) {
                url = url + "&g=" + groupId;
            }
            if ((artifactList = SonatypeSourceSearcher.findElements("./data/artifact", SonatypeSourceSearcher.readElementCancelable(indicator, url))).isEmpty()) {
                return null;
            }
            if (artifactList.size() != 1) {
                return null;
            }
            Element element = artifactList.get(0);
            List<Element> artifactHintList = SonatypeSourceSearcher.findElements("artifactHits/artifactHit/artifactLinks/artifactLink/classifier[text()='sources']/../../..", element);
            if (artifactHintList.isEmpty()) {
                return null;
            }
            groupId = element.getChildTextTrim("groupId");
            String repositoryId = artifactHintList.get(0).getChildTextTrim("repositoryId");
            return "https://oss.sonatype.org/service/local/artifact/maven/redirect?r=" + repositoryId + "&g=" + groupId + "&a=" + artifactId + "&v=" + version + "&e=jar&c=sources";
        }
        catch (IOException e) {
            indicator.checkCanceled();
            LOG.warn((Throwable)e);
            throw new SourceSearchException("Connection problem. See log for more details.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "artifactId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "version";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "classesJar";
                break;
            }
        }
        objectArray[1] = "com/intellij/jarFinder/SonatypeSourceSearcher";
        objectArray[2] = "findSourceJar";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

