/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.DescendentBasedRootFilter;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

class RepositoryLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private static final Logger LOG = Logger.getInstance(RepositoryLibraryRootsComponentDescriptor.class);

    RepositoryLibraryRootsComponentDescriptor() {
    }

    @Nullable
    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type2) {
        if (type2 == null) {
            RepositoryLibraryRootsComponentDescriptor.$$$reportNull$$$0(0);
        }
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type2);
    }

    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        List<DescendentBasedRootFilter> list = Collections.singletonList(DefaultLibraryRootsComponentDescriptor.createAnnotationsRootDetector());
        if (list == null) {
            RepositoryLibraryRootsComponentDescriptor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String libraryName) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(JavaUiBundle.message("chooser.title.attach.external.annotations", new Object[0]));
        descriptor.setDescription(JavaUiBundle.message("chooser.description.select.directory.where.external.annotations.are.located", new Object[0]));
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            RepositoryLibraryRootsComponentDescriptor.$$$reportNull$$$0(2);
        }
        return fileChooserDescriptor;
    }

    public String getAttachFilesActionName() {
        return "Attach Annotations...";
    }

    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        List list = Collections.emptyList();
        if (list == null) {
            RepositoryLibraryRootsComponentDescriptor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public LibraryRootsComponentDescriptor.RootRemovalHandler createRootRemovalHandler() {
        return new LibraryRootsComponentDescriptor.RootRemovalHandler(){

            public void onRootRemoved(@NotNull String rootUrl, @NotNull OrderRootType rootType, @NotNull LibraryEditor libraryEditor) {
                if (rootUrl == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rootType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (libraryEditor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (rootType == OrderRootType.CLASSES) {
                    String coordinates = RepositoryLibraryRootsComponentDescriptor.getMavenCoordinates(rootUrl);
                    if (coordinates != null) {
                        RepositoryLibraryProperties properties = (RepositoryLibraryProperties)libraryEditor.getProperties();
                        properties.setExcludedDependencies(ContainerUtil.append((List)properties.getExcludedDependencies(), (Object[])new String[]{coordinates}));
                    } else {
                        LOG.warn("Cannot determine Maven coordinates for removed library root " + rootUrl);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootUrl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "libraryEditor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jarRepository/RepositoryLibraryRootsComponentDescriptor$1";
                objectArray[2] = "onRootRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static String getMavenCoordinates(@NotNull String jarUrl) {
        File jarFile;
        if (jarUrl == null) {
            RepositoryLibraryRootsComponentDescriptor.$$$reportNull$$$0(4);
        }
        if ((jarFile = new File(PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)jarUrl)))).getParentFile() == null) {
            return null;
        }
        File artifactDir = jarFile.getParentFile().getParentFile();
        if (artifactDir == null) {
            return null;
        }
        File localRepoRoot = JarRepositoryManager.getLocalRepositoryPath();
        if (!FileUtil.isAncestor((File)localRepoRoot, (File)artifactDir, (boolean)true)) {
            return null;
        }
        String relativePath = FileUtil.getRelativePath((File)localRepoRoot, (File)artifactDir.getParentFile());
        if (relativePath == null) {
            return null;
        }
        return relativePath.replace(File.separatorChar, '.') + ":" + artifactDir.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/RepositoryLibraryRootsComponentDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/RepositoryLibraryRootsComponentDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDetectors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachFilesChooserDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachButtons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypePresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMavenCoordinates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

