/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.ProjectTopics;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.SyncLoadingKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableImplUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;

public class RepositoryLibrarySynchronizer
implements StartupActivity.DumbAware {
    private static boolean isLibraryNeedToBeReloaded(LibraryEx library, RepositoryLibraryProperties properties) {
        String version = properties.getVersion();
        if (version == null) {
            return false;
        }
        if (version.equals("LATEST") || version.equals("RELEASE") || version.endsWith("-SNAPSHOT")) {
            return true;
        }
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            if (library.getFiles(orderRootType).length == library.getUrls(orderRootType).length) continue;
            return true;
        }
        return false;
    }

    public static Set<Library> collectLibraries(@NotNull Project project, @NotNull Predicate<? super Library> predicate) {
        if (project == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(0);
        }
        if (predicate == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(1);
        }
        LinkedHashSet<Library> result = new LinkedHashSet<Library>();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                OrderEnumerator.orderEntries((Module)module).withoutSdk().forEachLibrary(library -> {
                    if (predicate.test((Library)library)) {
                        result.add((Library)library);
                    }
                    return true;
                });
            }
            for (Module module : LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries()) {
                if (!predicate.test((Library)module)) continue;
                result.add((Library)module);
            }
        });
        return result;
    }

    private static void removeDuplicatedUrlsFromRepositoryLibraries(@NotNull Project project) {
        Set<Library> libraries2;
        if (project == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(2);
        }
        if (!(libraries2 = RepositoryLibrarySynchronizer.collectLibraries(project, library -> library instanceof LibraryEx && ((LibraryEx)library).getProperties() instanceof RepositoryLibraryProperties && RepositoryLibrarySynchronizer.hasDuplicatedRoots(library))).isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                List validLibraries = ContainerUtil.filter((Collection)libraries2, LibraryTableImplUtil::isValidLibrary);
                if (validLibraries.isEmpty()) {
                    return;
                }
                WriteAction.run(() -> {
                    for (Library library : validLibraries) {
                        Library.ModifiableModel model = library.getModifiableModel();
                        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
                            String[] urls = model.getUrls(type2);
                            LinkedHashSet<String> uniqueUrls = new LinkedHashSet<String>(Arrays.asList(urls));
                            if (uniqueUrls.size() == urls.length) continue;
                            for (String url : urls) {
                                model.removeRoot(url, type2);
                            }
                            for (String url : uniqueUrls) {
                                model.addRoot(url, type2);
                            }
                        }
                        model.commit();
                    }
                });
                String libraryText = validLibraries.size() == 1 ? "'" + LibraryUtil.getPresentableName((Library)((Library)validLibraries.iterator().next())) + "' library" : validLibraries.size() + " libraries";
                Notifications.Bus.notify((Notification)new Notification("Repository", JavaUiBundle.message("notification.title.repository.libraries.cleanup", new Object[0]), JavaUiBundle.message("notification.text.duplicated.urls.were.removed", libraryText, ApplicationNamesInfo.getInstance().getFullProductName()), NotificationType.INFORMATION), (Project)project);
            }, project.getDisposed());
        }
    }

    private static boolean hasDuplicatedRoots(Library library) {
        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
            Object[] urls = library.getUrls(type2);
            if (urls.length == ContainerUtil.set((Object[])urls).size()) continue;
            return true;
        }
        return false;
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            SyncLoadingKt.loadDependenciesSync(project);
            return;
        }
        final Runnable syncTask = () -> {
            Set<Library> toSync = RepositoryLibrarySynchronizer.collectLibrariesToSync(project);
            ApplicationManager.getApplication().invokeLater(() -> {
                for (Library library : toSync) {
                    if (!LibraryTableImplUtil.isValidLibrary((Library)library)) continue;
                    RepositoryUtils.reloadDependencies(project, (LibraryEx)library);
                }
            }, project.getDisposed());
        };
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private final Alarm myAlarm;
            {
                this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
            }

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!this.myAlarm.isDisposed() && event.getSource() instanceof Project) {
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(syncTask, 300L);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/jarRepository/RepositoryLibrarySynchronizer$1", "rootsChanged"));
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RepositoryLibrarySynchronizer.removeDuplicatedUrlsFromRepositoryLibraries(project);
            syncTask.run();
        });
    }

    @NotNull
    public static Set<Library> collectLibrariesToSync(@NotNull Project project) {
        if (project == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(4);
        }
        Set<Library> set = RepositoryLibrarySynchronizer.collectLibraries(project, library -> {
            if (library instanceof LibraryEx) {
                LibraryEx libraryEx = (LibraryEx)library;
                return libraryEx.getProperties() instanceof RepositoryLibraryProperties && RepositoryLibrarySynchronizer.isLibraryNeedToBeReloaded(libraryEx, (RepositoryLibraryProperties)libraryEx.getProperties());
            }
            return false;
        });
        if (set == null) {
            RepositoryLibrarySynchronizer.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/RepositoryLibrarySynchronizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/RepositoryLibrarySynchronizer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLibrariesToSync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectLibraries";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatedUrlsFromRepositoryLibraries";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectLibrariesToSync";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

