/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.nexus;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.nexus.NexusModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NexusRepositoryService
extends MavenRepositoryService {
    private final Gson gson = new Gson();

    @Nullable
    public static RemoteRepositoryDescription convertRepositoryInfo(@NotNull NexusModel.RepositoryType repo) {
        if (repo == null) {
            NexusRepositoryService.$$$reportNull$$$0(0);
        }
        if (repo.id == null) {
            return null;
        }
        if (repo.name == null) {
            return null;
        }
        if (repo.contentResourceURI == null) {
            return null;
        }
        return new RemoteRepositoryDescription(repo.id, repo.name, repo.contentResourceURI);
    }

    public static RepositoryArtifactDescription convertArtifactInfo(NexusModel.ArtifactType t) {
        return new RepositoryArtifactDescription(t.groupId, t.artifactId, t.version, t.packaging, t.classifier, null, t.repoId);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Nexus";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        SmartList smartList;
        if (url == null) {
            NexusRepositoryService.$$$reportNull$$$0(1);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        try {
            NexusModel.RepositorySearchResults repos = (NexusModel.RepositorySearchResults)this.gson.fromJson(HttpRequests.request((Url)this.toUrl(url, "repositories")).productNameAsUserAgent().accept("application/json").readString(), NexusModel.RepositorySearchResults.class);
            SmartList result = new SmartList();
            if (repos.data != null) {
                for (NexusModel.RepositoryType repo : repos.data) {
                    RemoteRepositoryDescription desc;
                    if (!"maven2".equals(repo.provider) || (desc = NexusRepositoryService.convertRepositoryInfo(repo)) == null) continue;
                    result.add(desc);
                }
            }
            smartList = result;
        }
        catch (JsonSyntaxException e) {
            List<RemoteRepositoryDescription> list = Collections.emptyList();
            if (list == null) {
                NexusRepositoryService.$$$reportNull$$$0(3);
            }
            return list;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (smartList == null) {
            NexusRepositoryService.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        ArrayList<RepositoryArtifactDescription> arrayList;
        if (url == null) {
            NexusRepositoryService.$$$reportNull$$$0(4);
        }
        if (template == null) {
            NexusRepositoryService.$$$reportNull$$$0(5);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        try {
            String packaging = StringUtil.notNullize((String)template.getPackaging());
            NexusModel.ArtifactSearchResults results = (NexusModel.ArtifactSearchResults)this.gson.fromJson(HttpRequests.request((Url)this.toUrl(url, "data_index", this.prepareParameters(template))).accept("application/json").readString(), NexusModel.ArtifactSearchResults.class);
            ArrayList<RepositoryArtifactDescription> result = new ArrayList<RepositoryArtifactDescription>();
            if (results.data != null) {
                for (NexusModel.ArtifactType each : results.data) {
                    if (!Objects.equals(each.packaging, packaging)) continue;
                    result.add(NexusRepositoryService.convertArtifactInfo(each));
                }
            }
            arrayList = result;
        }
        catch (JsonSyntaxException e) {
            List<RepositoryArtifactDescription> list = Collections.emptyList();
            if (list == null) {
                NexusRepositoryService.$$$reportNull$$$0(7);
            }
            return list;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (arrayList == null) {
            NexusRepositoryService.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private String prepareParameters(@NotNull RepositoryArtifactDescription template) {
        if (template == null) {
            NexusRepositoryService.$$$reportNull$$$0(8);
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("q", StringUtil.join(Arrays.asList(template.getGroupId(), template.getArtifactId(), template.getVersion()), (String)":"));
        params.put("g", template.getGroupId());
        params.put("a", template.getArtifactId());
        params.put("v", template.getVersion());
        params.put("cn", template.getClassNames());
        String string = this.mapToParamString(params);
        if (string == null) {
            NexusRepositoryService.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/services/nexus/NexusRepositoryService";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/services/nexus/NexusRepositoryService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifacts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertRepositoryInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findArtifacts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

