/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.request;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.java.request.CreateConstructorFromCallExpressionRequest;
import com.intellij.lang.java.request.CreateConstructorFromJavaUsageRequest;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0002\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"findTargetClass", "Lcom/intellij/lang/jvm/JvmClass;", "call", "Lcom/intellij/psi/PsiConstructorCall;", "constant", "Lcom/intellij/psi/PsiEnumConstant;", "newExpression", "Lcom/intellij/psi/PsiNewExpression;", "generateConstructorActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/psi/PsiMethodCallExpression;", "intellij.java.impl"})
@JvmName(name="CreateConstructorFromUsage")
public final class CreateConstructorFromUsage {
    @NotNull
    public static final List<IntentionAction> generateConstructorActions(@NotNull PsiConstructorCall call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        JvmClass jvmClass = CreateConstructorFromUsage.findTargetClass(call);
        if (jvmClass == null) {
            return CollectionsKt.emptyList();
        }
        JvmClass targetClass = jvmClass;
        CreateConstructorFromJavaUsageRequest request = new CreateConstructorFromJavaUsageRequest(call, (Collection<? extends JvmModifier>)CollectionsKt.emptyList());
        return JvmElementActionFactories.createConstructorActions((JvmClass)targetClass, (CreateConstructorRequest)request);
    }

    private static final JvmClass findTargetClass(PsiConstructorCall call) {
        PsiConstructorCall psiConstructorCall = call;
        return psiConstructorCall instanceof PsiEnumConstant ? CreateConstructorFromUsage.findTargetClass((PsiEnumConstant)call) : (psiConstructorCall instanceof PsiNewExpression ? CreateConstructorFromUsage.findTargetClass((PsiNewExpression)call) : null);
    }

    private static final JvmClass findTargetClass(PsiEnumConstant constant) {
        PsiClass psiClass = constant.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"constant.containingClass ?: return null");
        PsiClass clazz = psiClass;
        return clazz.getClassKind() == JvmClassKind.ENUM ? (JvmClass)clazz : null;
    }

    private static final JvmClass findTargetClass(PsiNewExpression newExpression) {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = newExpression.getClassOrAnonymousClassReference();
        Object object = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.resolve() : null;
        if (!(object instanceof JvmClass)) {
            object = null;
        }
        JvmClass jvmClass = (JvmClass)object;
        if (jvmClass == null) {
            return null;
        }
        JvmClass clazz = jvmClass;
        return clazz.getClassKind() == JvmClassKind.CLASS ? clazz : null;
    }

    @NotNull
    public static final List<IntentionAction> generateConstructorActions(@NotNull PsiMethodCallExpression call) {
        boolean bl;
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        PsiElement $this$parentsOfType$iv = (PsiElement)call;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        PsiClass psiClass = (PsiClass)SequencesKt.firstOrNull((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, PsiClass.class, (boolean)withSelf$iv));
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass containingClass = psiClass;
        SmartList result = new SmartList();
        PsiClass superClass = containingClass.getSuperClass();
        if (superClass != null) {
            Collection collection = (Collection)result;
            iterable = JvmElementActionFactories.createConstructorActions((JvmClass)((JvmClass)superClass), (CreateConstructorRequest)new CreateConstructorFromCallExpressionRequest(call, "super"));
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
        Collection collection = (Collection)result;
        iterable = JvmElementActionFactories.createConstructorActions((JvmClass)((JvmClass)containingClass), (CreateConstructorRequest)new CreateConstructorFromCallExpressionRequest(call, "this"));
        bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return (List)result;
    }
}

