/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.request;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\r\u001a\u00020\u0002H\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\f\u0010\u0012\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\r\u001a\u00020\u0002H\u0000\u00a8\u0006\u0014"}, d2={"collectOuterClasses", "", "Lcom/intellij/psi/PsiClass;", "place", "Lcom/intellij/psi/PsiElement;", "computeVisibility", "Lcom/intellij/lang/jvm/JvmModifier;", "project", "Lcom/intellij/openapi/project/Project;", "ownerClass", "targetClass", "Lcom/intellij/lang/jvm/JvmClass;", "hierarchy", "clazz", "isInStaticContext", "", "Lcom/intellij/psi/PsiExpression;", "isWithinConstructorCall", "isWithinStaticMember", "isWithinStaticMemberOf", "intellij.java.impl"})
public final class CreateFromUsageUtilsKt {
    public static final boolean isInStaticContext(@NotNull PsiExpression $this$isInStaticContext) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isInStaticContext, (String)"$this$isInStaticContext");
        return CreateFromUsageUtilsKt.isWithinStaticMember($this$isInStaticContext) || CreateFromUsageUtilsKt.isWithinConstructorCall($this$isInStaticContext);
    }

    public static final boolean isWithinStaticMemberOf(@NotNull PsiExpression $this$isWithinStaticMemberOf, @NotNull PsiClass clazz) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isWithinStaticMemberOf, (String)"$this$isWithinStaticMemberOf");
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        PsiElement currentPlace = (PsiElement)$this$isWithinStaticMemberOf;
        while (true) {
            PsiClass enclosingClass;
            PsiMember enclosingMember;
            PsiElement $this$parentOfType$iv = currentPlace;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            if ((PsiMember)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiMember.class, (boolean)true) == null) {
                return false;
            }
            if (enclosingMember.getContainingClass() == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)enclosingClass, (String)"enclosingMember.containingClass ?: return false");
            if (Intrinsics.areEqual((Object)enclosingClass, (Object)clazz)) {
                return enclosingMember.hasModifierProperty("static");
            }
            if (enclosingClass.getParent() != null) continue;
            return false;
        }
    }

    public static final boolean isWithinStaticMember(@NotNull PsiExpression $this$isWithinStaticMember) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isWithinStaticMember, (String)"$this$isWithinStaticMember");
        PsiElement $this$parentOfType$iv = (PsiElement)$this$isWithinStaticMember;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiMember.class, (boolean)true);
        return psiMember != null ? psiMember.hasModifierProperty("static") : false;
    }

    public static final boolean isWithinConstructorCall(@NotNull PsiExpression $this$isWithinConstructorCall) {
        Object v3;
        Object v2;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)$this$isWithinConstructorCall, (String)"$this$isWithinConstructorCall");
            PsiElement $this$parentOfType$iv = (PsiElement)$this$isWithinConstructorCall;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiModifierListOwner.class, (boolean)true);
            if (!(psiElement instanceof PsiMethod)) {
                psiElement = null;
            }
            PsiMethod psiMethod = (PsiMethod)psiElement;
            if (psiMethod == null) {
                return false;
            }
            PsiMethod owner2 = psiMethod;
            if (!owner2.isConstructor()) {
                return false;
            }
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.getParentsWithSelf((PsiElement)((PsiElement)$this$isWithinConstructorCall));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiExpression))) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = v3 = null;
        }
        if (!(v2 instanceof PsiExpressionList)) {
            v3 = null;
        }
        PsiExpressionList psiExpressionList = v3;
        if (psiExpressionList == null) {
            return false;
        }
        PsiExpressionList parent = psiExpressionList;
        PsiElement psiElement = parent.getParent();
        if (!(psiElement instanceof PsiMethodCallExpression)) {
            psiElement = null;
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiElement;
        if (psiMethodCallExpression == null) {
            return false;
        }
        PsiMethodCallExpression grandParent = psiMethodCallExpression;
        PsiReferenceExpression psiReferenceExpression = grandParent.getMethodExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression, (String)"grandParent.methodExpression");
        String calleText = psiReferenceExpression.getText();
        return Intrinsics.areEqual((Object)calleText, (Object)"super") || Intrinsics.areEqual((Object)calleText, (Object)"this");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final JvmModifier computeVisibility(@NotNull Project project, @Nullable PsiClass ownerClass, @NotNull JvmClass targetClass) {
        String setting;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)targetClass, (String)"targetClass");
        if (targetClass.getClassKind() == JvmClassKind.INTERFACE) return JvmModifier.PUBLIC;
        if (targetClass.getClassKind() == JvmClassKind.ANNOTATION) {
            return JvmModifier.PUBLIC;
        }
        if (ownerClass != null) {
            JvmClass jvmClass = targetClass;
            if (!(jvmClass instanceof PsiClass)) {
                jvmClass = null;
            }
            PsiClass psiClass = (PsiClass)jvmClass;
            if (psiClass != null) {
                PsiClass psiClass2 = psiClass;
                boolean bl = false;
                boolean bl2 = false;
                PsiClass target = psiClass2;
                boolean bl3 = false;
                if (target.isEquivalentTo((PsiElement)ownerClass)) return JvmModifier.PRIVATE;
                if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)target), (PsiElement)((PsiElement)ownerClass), (boolean)false)) {
                    return JvmModifier.PRIVATE;
                }
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)ownerClass, (PsiClass)target, (boolean)true)) {
                    return JvmModifier.PROTECTED;
                }
            }
        }
        String string = setting = ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JavaCodeStyleSettings.class)).VISIBILITY;
        if (string == null) return null;
        switch (string) {
            case "public": {
                JvmModifier jvmModifier = JvmModifier.PUBLIC;
                return jvmModifier;
            }
            case "protected": {
                JvmModifier jvmModifier = JvmModifier.PROTECTED;
                return jvmModifier;
            }
            case "packageLocal": {
                JvmModifier jvmModifier = JvmModifier.PACKAGE_LOCAL;
                return jvmModifier;
            }
            case "private": {
                JvmModifier jvmModifier = JvmModifier.PRIVATE;
                return jvmModifier;
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public static final List<PsiClass> collectOuterClasses(@NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        PsiElement $this$parentsOfType$iv = place;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        for (PsiClass clazz : PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, PsiClass.class, (boolean)withSelf$iv)) {
            result.add(clazz);
            if (!clazz.hasModifierProperty("static")) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiClass> hierarchy(@NotNull PsiClass clazz) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        LinkedHashSet<PsiClass> result = new LinkedHashSet<PsiClass>();
        LinkedList<PsiClass> queue = new LinkedList<PsiClass>();
        queue.add(clazz);
        while (true) {
            Collection collection = queue;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            PsiClass current = (PsiClass)queue.removeFirst();
            if (!result.add(current)) continue;
            Collection collection2 = queue;
            PsiClass psiClass = current;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"current");
            Object[] objectArray = psiClass.getSupers();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"current.supers");
            CollectionsKt.addAll((Collection)collection2, (Object[])objectArray);
        }
        Iterable $this$filter$iv = result;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiClass it = (PsiClass)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof PsiTypeParameter))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

