/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;

public final class JavaSdkImpl
extends JavaSdk {
    private static final Logger LOG = Logger.getInstance(JavaSdkImpl.class);
    public static final DataKey<Boolean> KEY = DataKey.create((String)"JavaSdk");
    private static final String VM_EXE_NAME = SystemInfo.isWindows ? "java.exe" : "java";
    private final Map<String, String> myCachedSdkHomeToVersionString = new ConcurrentHashMap<String, String>();
    private final Map<String, JavaVersion> myCachedVersionStringToJdkVersion = new ConcurrentHashMap<String, JavaVersion>();

    public JavaSdkImpl() {
        super("JavaSDK");
        Disposable parentDisposable = ExtensionPointUtil.createExtensionDisposable((Object)((Object)this), (ExtensionPointName)EP_NAME);
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFileDeleteEvent) {
                        JavaSdkImpl.this.updateCache(vFileEvent, PathUtil.getFileName((String)vFileEvent.getPath()));
                        break;
                    }
                    if (!(vFileEvent instanceof VFileCreateEvent)) continue;
                    JavaSdkImpl.this.updateCache(vFileEvent, ((VFileCreateEvent)vFileEvent).getChildName());
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/projectRoots/impl/JavaSdkImpl$1", "after"));
            }
        });
    }

    private void updateCache(@NotNull VFileEvent event, @NotNull String fileName) {
        if (event == null) {
            JavaSdkImpl.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            JavaSdkImpl.$$$reportNull$$$0(1);
        }
        if (ArchiveFileType.INSTANCE.equals(FileTypeManager.getInstance().getFileTypeByFileName(fileName))) {
            String filePath = event.getPath();
            if (this.myCachedSdkHomeToVersionString.keySet().removeIf(sdkHome -> FileUtil.isAncestor((String)sdkHome, (String)filePath, (boolean)false))) {
                this.myCachedVersionStringToJdkVersion.clear();
            }
        }
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"sdk.java.name", (Object[])new Object[0]);
        if (string == null) {
            JavaSdkImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Icon getIcon() {
        return AllIcons.Nodes.PpJdk;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.java";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = AllIcons.General.AddJdk;
        if (icon == null) {
            JavaSdkImpl.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        JavaSdkVersion version;
        int release;
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(4);
        }
        int n = release = (version = this.getVersion(sdk)) != null ? version.ordinal() : 0;
        if (release > LanguageLevel.HIGHEST.toJavaVersion().feature) {
            return "https://download.java.net/java/early_access/jdk" + release + "/docs/api/";
        }
        if (release >= 11) {
            return "https://docs.oracle.com/en/java/javase/" + release + "/docs/api/";
        }
        if (release >= 6) {
            return "https://docs.oracle.com/javase/" + release + "/docs/api/";
        }
        if (release == 5) {
            return "https://docs.oracle.com/javase/1.5.0/docs/api/";
        }
        return null;
    }

    @NotNull
    public String getDownloadSdkUrl() {
        return "https://www.oracle.com/technetwork/java/javase/downloads/index.html";
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            JavaSdkImpl.$$$reportNull$$$0(5);
        }
        if (sdkModificator == null) {
            JavaSdkImpl.$$$reportNull$$$0(6);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            JavaSdkImpl.$$$reportNull$$$0(7);
        }
        if (additional == null) {
            JavaSdkImpl.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    public Comparator<Sdk> versionComparator() {
        Comparator comparator = (sdk1, sdk2) -> {
            assert (sdk1.getSdkType() == this) : sdk1;
            assert (sdk2.getSdkType() == this) : sdk2;
            return Comparing.compare((Comparable)this.getJavaVersion((Sdk)sdk1), (Comparable)this.getJavaVersion((Sdk)sdk2));
        };
        if (comparator == null) {
            JavaSdkImpl.$$$reportNull$$$0(9);
        }
        return comparator;
    }

    @NotNull
    public Comparator<String> versionStringComparator() {
        Comparator comparator = (sdk1, sdk2) -> Comparing.compare((Comparable)this.getJavaVersion((String)sdk1), (Comparable)this.getJavaVersion((String)sdk2));
        if (comparator == null) {
            JavaSdkImpl.$$$reportNull$$$0(10);
        }
        return comparator;
    }

    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(11);
        }
        return JavaSdkImpl.getConvertedHomePath(sdk) + "bin";
    }

    public String getToolsPath(@NotNull Sdk sdk) {
        JavaVersion version;
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(12);
        }
        return (version = this.getJavaVersion(sdk)) == null || version.feature > 9 ? null : JavaSdkImpl.getConvertedHomePath(sdk) + "lib" + File.separator + (version.feature < 2 ? "classes.zip" : "tools.jar");
    }

    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(13);
        }
        return this.getBinPath(sdk) + File.separator + VM_EXE_NAME;
    }

    private static String getConvertedHomePath(Sdk sdk) {
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        String path = FileUtil.toSystemDependentName((String)homePath);
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public String suggestHomePath() {
        return JavaHomeFinder.defaultJavaLocation();
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        List list = JavaHomeFinder.suggestHomePaths();
        if (list == null) {
            JavaSdkImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = super.getHomeChooserDescriptor();
        descriptor.putUserData(KEY, (Object)Boolean.TRUE);
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            JavaSdkImpl.$$$reportNull$$$0(15);
        }
        return fileChooserDescriptor;
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        if (homePath == null) {
            JavaSdkImpl.$$$reportNull$$$0(16);
        }
        if (SystemInfo.isMac) {
            File home = new File(homePath, "/Home");
            if (home.exists()) {
                String string = home.getPath();
                if (string == null) {
                    JavaSdkImpl.$$$reportNull$$$0(17);
                }
                return string;
            }
            home = new File(homePath, "Contents/Home");
            if (home.exists()) {
                String string = home.getPath();
                if (string == null) {
                    JavaSdkImpl.$$$reportNull$$$0(18);
                }
                return string;
            }
        }
        String string = homePath;
        if (string == null) {
            JavaSdkImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    public boolean isValidSdkHome(String path) {
        return JdkUtil.checkForJdk((String)path);
    }

    public String getInvalidHomeMessage(String path) {
        if (JdkUtil.checkForJre((String)path)) {
            return "The selected directory points to a JRE, not a JDK.\nYou can download a JDK from " + this.getDownloadSdkUrl();
        }
        return super.getInvalidHomeMessage(path);
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        String suggestedName = JdkUtil.suggestJdkName((String)this.getVersionString(sdkHome));
        return suggestedName != null ? suggestedName : (currentSdkName != null ? currentSdkName : "");
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(20);
        }
        if (sdkModel == null) {
            JavaSdkImpl.$$$reportNull$$$0(21);
        }
        this.setupSdkPaths(sdk);
        if (sdk.getSdkModificator().getRoots(OrderRootType.CLASSES).length == 0) {
            String title = JavaBundle.message((String)"sdk.cannot.create", (Object[])new Object[0]);
            String message2 = JavaBundle.message((String)"sdk.java.no.classes", (Object[])new Object[]{sdk.getHomePath()});
            Messages.showMessageDialog((String)message2, (String)title, (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(22);
        }
        String homePath = sdk.getHomePath();
        assert (homePath != null) : sdk;
        File jdkHome = new File(homePath);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        List<String> classes2 = JavaSdkImpl.findClasses(jdkHome, false);
        LinkedHashSet<String> previousRoots = new LinkedHashSet<String>(Arrays.asList(sdkModificator.getUrls(OrderRootType.CLASSES)));
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        previousRoots.removeAll(new HashSet<String>(classes2));
        for (String url : classes2) {
            sdkModificator.addRoot(url, OrderRootType.CLASSES);
        }
        for (String url : previousRoots) {
            sdkModificator.addRoot(url, OrderRootType.CLASSES);
        }
        JavaSdkImpl.addSources(jdkHome, sdkModificator);
        this.addDocs(jdkHome, sdkModificator, sdk);
        JavaSdkImpl.attachJdkAnnotations(sdkModificator);
        sdkModificator.commitChanges();
    }

    public static void attachJdkAnnotations(@NotNull SdkModificator modificator) {
        if (modificator == null) {
            JavaSdkImpl.$$$reportNull$$$0(23);
        }
        JavaSdkImpl.attachIDEAAnnotationsToJdk(modificator);
    }

    public static boolean attachIDEAAnnotationsToJdk(@NotNull SdkModificator modificator) {
        ArrayList pathsChecked;
        VirtualFile root;
        if (modificator == null) {
            JavaSdkImpl.$$$reportNull$$$0(24);
        }
        if ((root = JavaSdkImpl.internalJdkAnnotationsPath(pathsChecked = new ArrayList())) == null) {
            String msg = "Paths checked:\n";
            for (String p : pathsChecked) {
                File f = new File(p);
                msg = msg + p + "; exists: " + f.exists() + "; siblings: " + Arrays.toString(f.getParentFile().list()) + "\n";
            }
            LOG.error("JDK annotations not found", new String[]{msg});
            return false;
        }
        OrderRootType annoType = AnnotationOrderRootType.getInstance();
        if (modificator.getRoots(annoType).length != 0) {
            modificator.removeRoot(root, annoType);
        }
        modificator.addRoot(root, annoType);
        return true;
    }

    static VirtualFile internalJdkAnnotationsPath(@NotNull List<? super String> pathsChecked) {
        VirtualFile root;
        String javaPluginClassesRootPath;
        if (pathsChecked == null) {
            JavaSdkImpl.$$$reportNull$$$0(25);
        }
        LOG.assertTrue((javaPluginClassesRootPath = PathManager.getJarPathForClass(JavaSdkImpl.class)) != null);
        File javaPluginClassesRoot = new File(javaPluginClassesRootPath);
        if (javaPluginClassesRoot.isFile()) {
            String annotationsJarPath = FileUtil.toSystemIndependentName((String)new File(javaPluginClassesRoot.getParentFile(), "jdkAnnotations.jar").getAbsolutePath());
            root = VirtualFileManager.getInstance().findFileByUrl("jar://" + annotationsJarPath + "!/");
            pathsChecked.add(annotationsJarPath);
        } else {
            File projectRoot = (File)JBIterable.generate((Object)javaPluginClassesRoot, File::getParentFile).get(4);
            File root1 = new File(projectRoot, "community/java/jdkAnnotations");
            File root2 = new File(projectRoot, "java/jdkAnnotations");
            VirtualFile virtualFile = root1.exists() && root1.isDirectory() ? LocalFileSystem.getInstance().findFileByIoFile(root1) : (root = root2.exists() && root2.isDirectory() ? LocalFileSystem.getInstance().findFileByIoFile(root2) : null);
        }
        if (root == null) {
            String url = "jar://" + FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) + "/lib/jdkAnnotations.jar!/";
            root = VirtualFileManager.getInstance().findFileByUrl(url);
            pathsChecked.add(url);
        }
        if (root == null) {
            String path = FileUtil.toSystemIndependentName((String)PathManager.getCommunityHomePath()) + "/java/jdkAnnotations";
            root = LocalFileSystem.getInstance().findFileByPath(path);
            pathsChecked.add(path);
        }
        return root;
    }

    public final String getVersionString(String sdkHome) {
        return this.myCachedSdkHomeToVersionString.computeIfAbsent(sdkHome, homePath -> {
            JdkVersionDetector.JdkVersionInfo jdkInfo = SdkVersionUtil.getJdkVersionInfo((String)homePath);
            return jdkInfo != null ? JdkVersionDetector.formatVersionString((JavaVersion)jdkInfo.version) : null;
        });
    }

    public JavaSdkVersion getVersion(@NotNull Sdk sdk) {
        JavaVersion version;
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(26);
        }
        return (version = this.getJavaVersion(sdk)) != null ? JavaSdkVersion.fromJavaVersion((JavaVersion)version) : null;
    }

    @Nullable
    public JavaVersion getJavaVersion(@NotNull Sdk sdk) {
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(27);
        }
        String versionString = sdk.getVersionString();
        return this.getJavaVersion(versionString);
    }

    @Nullable
    private JavaVersion getJavaVersion(@Nullable String versionString) {
        return versionString != null ? this.myCachedVersionStringToJdkVersion.computeIfAbsent(versionString, JavaVersion::tryParse) : null;
    }

    @Nullable
    public JavaSdkVersion getVersion(@NotNull String versionString) {
        if (versionString == null) {
            JavaSdkImpl.$$$reportNull$$$0(28);
        }
        return JavaSdkVersion.fromVersionString((String)versionString);
    }

    public boolean isOfVersionOrHigher(@NotNull Sdk sdk, @NotNull JavaSdkVersion version) {
        JavaSdkVersion sdkVersion;
        if (sdk == null) {
            JavaSdkImpl.$$$reportNull$$$0(29);
        }
        if (version == null) {
            JavaSdkImpl.$$$reportNull$$$0(30);
        }
        return (sdkVersion = this.getVersion(sdk)) != null && sdkVersion.isAtLeast(version);
    }

    @NotNull
    public Sdk createJdk(@NotNull String jdkName, @NotNull String home, boolean isJre) {
        File jdkHomeFile;
        if (jdkName == null) {
            JavaSdkImpl.$$$reportNull$$$0(31);
        }
        if (home == null) {
            JavaSdkImpl.$$$reportNull$$$0(32);
        }
        if (!(jdkHomeFile = new File(home)).exists()) {
            throw new IllegalArgumentException(jdkHomeFile.getAbsolutePath() + " doesn't exist");
        }
        ProjectJdkImpl jdk = new ProjectJdkImpl(jdkName, (SdkTypeId)this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)home));
        if (JdkVersionDetector.isVersionString((String)jdkName)) {
            sdkModificator.setVersionString(jdkName);
        }
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, isJre);
        JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        this.addDocs(jdkHomeFile, sdkModificator, null);
        JavaSdkImpl.attachJdkAnnotations(sdkModificator);
        sdkModificator.commitChanges();
        ProjectJdkImpl projectJdkImpl = jdk;
        if (projectJdkImpl == null) {
            JavaSdkImpl.$$$reportNull$$$0(33);
        }
        return projectJdkImpl;
    }

    @ApiStatus.Internal
    public static void addClasses(@NotNull File file, @NotNull SdkModificator sdkModificator, boolean isJre) {
        if (file == null) {
            JavaSdkImpl.$$$reportNull$$$0(34);
        }
        if (sdkModificator == null) {
            JavaSdkImpl.$$$reportNull$$$0(35);
        }
        for (String url : JavaSdkImpl.findClasses(file, isJre)) {
            sdkModificator.addRoot(url, OrderRootType.CLASSES);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static List<String> readModulesFromReleaseFile(File jrtBaseDir) {
        File releaseFile = new File(jrtBaseDir, "release");
        if (!releaseFile.isFile()) return null;
        try (FileInputStream stream = new FileInputStream(releaseFile);){
            Properties p = new Properties();
            p.load(stream);
            String modules = p.getProperty("MODULES");
            if (modules == null) return null;
            List list = StringUtil.split((String)StringUtil.unquoteString((String)modules), (String)" ");
            return list;
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    @NotNull
    private static List<String> findClasses(@NotNull File jdkHome, boolean isJre) {
        if (jdkHome == null) {
            JavaSdkImpl.$$$reportNull$$$0(36);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (JdkUtil.isExplodedModularRuntime((String)jdkHome.getPath())) {
            File[] exploded = new File(jdkHome, "modules").listFiles();
            if (exploded != null) {
                for (File root : exploded) {
                    result.add(VfsUtil.getUrlForLibraryRoot((File)root));
                }
            }
        } else if (JdkUtil.isModularRuntime((File)jdkHome)) {
            String jrtBaseUrl = "jrt://" + JavaSdkImpl.getPath(jdkHome) + "!/";
            List<String> modules = JavaSdkImpl.readModulesFromReleaseFile(jdkHome);
            if (modules != null) {
                for (String module : modules) {
                    result.add(jrtBaseUrl + module);
                }
            } else {
                VirtualFile jrt = VirtualFileManager.getInstance().findFileByUrl(jrtBaseUrl);
                if (jrt != null) {
                    for (VirtualFile virtualFile : jrt.getChildren()) {
                        result.add(virtualFile.getUrl());
                    }
                }
            }
        } else {
            for (File root : JavaSdkUtil.getJdkClassesRoots((File)jdkHome, (boolean)isJre)) {
                result.add(VfsUtil.getUrlForLibraryRoot((File)root));
            }
        }
        Collections.sort(result);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            JavaSdkImpl.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    public static void addSources(@NotNull File jdkHome, @NotNull SdkModificator sdkModificator) {
        VirtualFile fxSrc;
        VirtualFile jdkSrc;
        if (jdkHome == null) {
            JavaSdkImpl.$$$reportNull$$$0(38);
        }
        if (sdkModificator == null) {
            JavaSdkImpl.$$$reportNull$$$0(39);
        }
        if ((jdkSrc = JavaSdkImpl.findSources(jdkHome, "src")) != null) {
            if (jdkSrc.findChild("java.base") != null) {
                Stream.of(jdkSrc.getChildren()).filter(VirtualFile::isDirectory).forEach(root -> sdkModificator.addRoot(root, OrderRootType.SOURCES));
            } else {
                sdkModificator.addRoot(jdkSrc, OrderRootType.SOURCES);
            }
        }
        if ((fxSrc = JavaSdkImpl.findSources(jdkHome, "javafx-src")) != null) {
            sdkModificator.addRoot(fxSrc, OrderRootType.SOURCES);
        }
    }

    @Nullable
    private static VirtualFile findSources(File jdkHome, String srcName) {
        File srcArc = new File(jdkHome, srcName + ".jar");
        if (!srcArc.exists()) {
            srcArc = new File(jdkHome, srcName + ".zip");
        }
        if (!srcArc.exists()) {
            srcArc = new File(jdkHome, "lib/" + srcName + ".zip");
        }
        if (srcArc.exists()) {
            VirtualFile srcRoot = JavaSdkImpl.findInJar(srcArc, "src");
            if (srcRoot == null) {
                srcRoot = JavaSdkImpl.findInJar(srcArc, "");
            }
            return srcRoot;
        }
        File srcDir = new File(jdkHome, "src");
        if (srcDir.isDirectory()) {
            return LocalFileSystem.getInstance().findFileByPath(JavaSdkImpl.getPath(srcDir));
        }
        return null;
    }

    private void addDocs(File jdkHome, SdkModificator sdkModificator, @Nullable Sdk sdk) {
        OrderRootType docRootType = JavadocOrderRootType.getInstance();
        VirtualFile apiDocs = JavaSdkImpl.findDocs(jdkHome, "docs/api");
        if (apiDocs != null) {
            sdkModificator.addRoot(apiDocs, docRootType);
        } else if (SystemInfo.isMac) {
            VirtualFile appleDocs;
            VirtualFile commonDocs = JavaSdkImpl.findDocs(jdkHome, "docs");
            if (commonDocs == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "doc/api");
            }
            if (commonDocs == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "docs/api");
            }
            if (commonDocs != null) {
                sdkModificator.addRoot(commonDocs, docRootType);
            }
            if ((appleDocs = JavaSdkImpl.findDocs(jdkHome, "appledocs")) == null) {
                appleDocs = JavaSdkImpl.findInJar(new File(jdkHome, "appledocs.jar"), "appledoc/api");
            }
            if (appleDocs != null) {
                sdkModificator.addRoot(appleDocs, docRootType);
            }
        }
        if (sdk != null && sdkModificator.getRoots(docRootType).length == 0 && sdkModificator.getRoots(OrderRootType.SOURCES).length == 0) {
            VirtualFile fxDocUrl;
            VirtualFile onlineDoc;
            String docUrl = this.getDefaultDocumentationUrl(sdk);
            if (docUrl != null && (onlineDoc = VirtualFileManager.getInstance().findFileByUrl(docUrl)) != null) {
                sdkModificator.addRoot(onlineDoc, docRootType);
            }
            if (this.getVersion(sdk) == JavaSdkVersion.JDK_1_7 && (fxDocUrl = VirtualFileManager.getInstance().findFileByUrl("https://docs.oracle.com/javafx/2/api/")) != null) {
                sdkModificator.addRoot(fxDocUrl, docRootType);
            }
        }
    }

    @Nullable
    private static VirtualFile findDocs(@NotNull File jdkHome, @NotNull String relativePath) {
        File docDir;
        if (jdkHome == null) {
            JavaSdkImpl.$$$reportNull$$$0(40);
        }
        if (relativePath == null) {
            JavaSdkImpl.$$$reportNull$$$0(41);
        }
        return (docDir = new File(jdkHome.getAbsolutePath(), relativePath)).isDirectory() ? LocalFileSystem.getInstance().findFileByPath(JavaSdkImpl.getPath(docDir)) : null;
    }

    private static VirtualFile findInJar(File jarFile, String relativePath) {
        if (!jarFile.exists()) {
            return null;
        }
        String url = "jar://" + JavaSdkImpl.getPath(jarFile) + "!/" + relativePath;
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    private static String getPath(File jarFile) {
        return FileUtil.toSystemIndependentName((String)jarFile.getAbsolutePath());
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type2) {
        if (type2 == null) {
            JavaSdkImpl.$$$reportNull$$$0(42);
        }
        return type2 == OrderRootType.CLASSES || type2 == OrderRootType.SOURCES || type2 == JavadocOrderRootType.getInstance() || type2 == AnnotationOrderRootType.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/JavaSdkImpl";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 6: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificator";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsChecked";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHome";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/JavaSdkImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "versionComparator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "versionStringComparator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createJdk";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateCache";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: 
            case 37: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getToolsPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVMExecutablePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "attachJdkAnnotations";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "attachIDEAAnnotationsToJdk";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "internalJdkAnnotationsPath";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getJavaVersion";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isOfVersionOrHigher";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addClasses";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addSources";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findDocs";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 33: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

