/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactErrorPanel;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemDescription;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.packaging.elements.PackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ArtifactValidationManagerImpl
implements Disposable {
    private final ArtifactErrorPanel myErrorPanel;
    private final ArtifactEditorImpl myArtifactEditor;
    private final MultiValuesMap<PackagingElementNode<?>, ArtifactProblemDescription> myProblemsForNodes = new MultiValuesMap(true);
    private final List<ArtifactProblemDescription> myProblems = new ArrayList<ArtifactProblemDescription>();

    ArtifactValidationManagerImpl(ArtifactEditorImpl artifactEditor) {
        Disposer.register((Disposable)artifactEditor, (Disposable)this);
        this.myArtifactEditor = artifactEditor;
        this.myErrorPanel = new ArtifactErrorPanel(artifactEditor);
    }

    public void dispose() {
    }

    public JComponent getMainErrorPanel() {
        return this.myErrorPanel.getMainPanel();
    }

    public void onNodesAdded() {
        for (ArtifactProblemDescription problem : this.myProblems) {
            this.showProblemInTree(problem);
        }
    }

    @Nullable
    public Collection<ArtifactProblemDescription> getProblems(PackagingElementNode<?> node) {
        return this.myProblemsForNodes.get(node);
    }

    public void updateProblems(@Nullable ProjectStructureProblemsHolderImpl holder) {
        List<ProjectStructureProblemDescription> problemDescriptions;
        this.myErrorPanel.clearError();
        this.myProblemsForNodes.clear();
        this.myProblems.clear();
        if (holder != null && (problemDescriptions = holder.getProblemDescriptions()) != null) {
            for (ProjectStructureProblemDescription description : problemDescriptions) {
                String message2 = description.getMessage(false);
                List<Object> quickFixes = Collections.emptyList();
                if (description instanceof ArtifactProblemDescription) {
                    ArtifactProblemDescription artifactProblem = (ArtifactProblemDescription)description;
                    quickFixes = artifactProblem.getFixes();
                    if (artifactProblem.getPathToPlace() != null) {
                        this.myProblems.add(artifactProblem);
                        this.showProblemInTree(artifactProblem);
                    }
                }
                this.myErrorPanel.showError(message2, description.getSeverity(), quickFixes);
            }
        }
        this.myArtifactEditor.getLayoutTreeComponent().updateTreeNodesPresentation();
    }

    private void showProblemInTree(ArtifactProblemDescription problem) {
        PackagingElementNode<?> node = this.myArtifactEditor.getLayoutTreeComponent().getRootNode();
        List<PackagingElement<?>> pathToPlace = problem.getPathToPlace();
        if (node != null && pathToPlace != null) {
            List<PackagingElementNode<?>> nodes = node.getNodesByPath(pathToPlace.subList(1, pathToPlace.size()));
            for (PackagingElementNode<?> elementNode : nodes) {
                this.myProblemsForNodes.put(elementNode, (Object)problem);
            }
        }
    }
}

