/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FindUsagesInProjectStructureActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementRenderer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.navigation.Place;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseStructureConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable,
Place.Navigator {
    protected StructureConfigurableContext myContext;
    protected final Project myProject;
    protected boolean myUiDisposed;
    private boolean myWasTreeInitialized;
    protected boolean myAutoScrollEnabled;

    protected BaseStructureConfigurable(Project project, MasterDetailsState state) {
        super(state);
        this.myUiDisposed = true;
        this.myAutoScrollEnabled = true;
        this.myProject = project;
    }

    protected BaseStructureConfigurable(@NotNull Project project) {
        if (project == null) {
            BaseStructureConfigurable.$$$reportNull$$$0(0);
        }
        this.myUiDisposed = true;
        this.myAutoScrollEnabled = true;
        this.myProject = project;
    }

    public void init(StructureConfigurableContext context) {
        this.myContext = context;
        this.myContext.getDaemonAnalyzer().addListener(new ProjectStructureDaemonAnalyzerListener(){

            @Override
            public void problemsChanged(@NotNull ProjectStructureElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!BaseStructureConfigurable.this.myTree.isShowing()) {
                    return;
                }
                BaseStructureConfigurable.this.myTree.revalidate();
                BaseStructureConfigurable.this.myTree.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable$1", "problemsChanged"));
            }
        });
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        MasterDetailsComponent.MyNode nodeByName;
        if (place == null) {
            return ActionCallback.DONE;
        }
        Object object = place.getPath("treeObject");
        String byName = (String)place.getPath("treeName");
        if (object == null && byName == null) {
            return ActionCallback.DONE;
        }
        MasterDetailsComponent.MyNode node = object == null ? null : BaseStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)object);
        MasterDetailsComponent.MyNode myNode = nodeByName = byName == null ? null : BaseStructureConfigurable.findNodeByName((TreeNode)this.myRoot, (String)byName);
        if (node == null && nodeByName == null) {
            return ActionCallback.DONE;
        }
        NamedConfigurable config = node != null ? node.getConfigurable() : nodeByName.getConfigurable();
        ActionCallback result = new ActionCallback().doWhenDone(() -> {
            this.myAutoScrollEnabled = true;
        });
        this.myAutoScrollEnabled = false;
        this.myAutoScrollHandler.cancelAllRequests();
        MasterDetailsComponent.MyNode nodeToSelect = node != null ? node : nodeByName;
        this.selectNodeInTree((DefaultMutableTreeNode)nodeToSelect, requestFocus).doWhenDone(() -> {
            this.setSelectedNode(nodeToSelect);
            Place.goFurther((Object)config, (Place)place, (boolean)requestFocus).notifyWhenDone(result);
        });
        return result;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            BaseStructureConfigurable.$$$reportNull$$$0(1);
        }
        if (this.myCurrentConfigurable != null) {
            place.putPath("treeObject", this.myCurrentConfigurable.getEditableObject());
            Place.queryFurther((Object)this.myCurrentConfigurable, (Place)place);
        }
    }

    protected void initTree() {
        if (this.myWasTreeInitialized) {
            return;
        }
        this.myWasTreeInitialized = true;
        super.initTree();
        new TreeSpeedSearch(this.myTree, treePath -> this.getTextForSpeedSearch((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()), true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new ProjectStructureElementRenderer(this.myContext)));
    }

    @NotNull
    protected String getTextForSpeedSearch(MasterDetailsComponent.MyNode node) {
        String string = node.getDisplayName();
        if (string == null) {
            BaseStructureConfigurable.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void disposeUIResources() {
        if (this.myUiDisposed) {
            return;
        }
        super.disposeUIResources();
        this.myUiDisposed = true;
        this.myAutoScrollHandler.cancelAllRequests();
        this.myContext.getDaemonAnalyzer().clear();
        Disposer.dispose((Disposable)this);
    }

    public void checkCanApply() throws ConfigurationException {
    }

    protected void addCollapseExpandActions(List<? super AnAction> result) {
        DefaultTreeExpander expander = new DefaultTreeExpander((JTree)this.myTree);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        result.add((AnAction)actionsManager.createExpandAllAction((TreeExpander)expander, (JComponent)this.myTree));
        result.add((AnAction)actionsManager.createCollapseAllAction((TreeExpander)expander, (JComponent)this.myTree));
    }

    @Nullable
    public ProjectStructureElement getSelectedElement() {
        MasterDetailsComponent.MyNode node;
        NamedConfigurable configurable;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof MasterDetailsComponent.MyNode && (configurable = (node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent()).getConfigurable()) instanceof ProjectStructureElementConfigurable) {
            return ((ProjectStructureElementConfigurable)configurable).getProjectStructureElement();
        }
        return null;
    }

    public void reset() {
        this.myUiDisposed = false;
        if (!this.myWasTreeInitialized) {
            this.initTree();
            this.myTree.setShowsRootHandles(false);
            this.loadTreeNodes();
        } else {
            this.reloadTreeNodes();
        }
        super.reset();
    }

    private void loadTreeNodes() {
        this.loadTree();
        for (ProjectStructureElement projectStructureElement : this.getProjectStructureElements()) {
            this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement);
        }
    }

    protected final void reloadTreeNodes() {
        super.disposeUIResources();
        this.myTree.setShowsRootHandles(false);
        this.loadTreeNodes();
    }

    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        List list = Collections.emptyList();
        if (list == null) {
            BaseStructureConfigurable.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected abstract void loadTree();

    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        AbstractAddGroup addAction = this.createAddAction();
        if (addAction != null) {
            result.add((AnAction)addAction);
        }
        result.add((AnAction)new MyRemoveAction());
        List<? extends AnAction> copyActions = this.createCopyActions(fromPopup);
        result.addAll(copyActions);
        result.add((AnAction)Separator.getInstance());
        if (fromPopup) {
            result.add(new MyFindUsagesAction((JComponent)this.myTree));
        }
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            BaseStructureConfigurable.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean fromPopup) {
        List list = Collections.emptyList();
        if (list == null) {
            BaseStructureConfigurable.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void onStructureUnselected() {
    }

    public void onStructureSelected() {
    }

    @Nullable
    protected abstract AbstractAddGroup createAddAction();

    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.emptyList();
    }

    @NotNull
    private MultiMap<RemoveConfigurableHandler, MasterDetailsComponent.MyNode> groupNodes(List<? extends MasterDetailsComponent.MyNode> nodes) {
        List<? extends RemoveConfigurableHandler<?>> handlers = this.getRemoveHandlers();
        MultiMap grouped = MultiMap.createLinked();
        for (MasterDetailsComponent.MyNode myNode : nodes) {
            RemoveConfigurableHandler<?> handler;
            NamedConfigurable configurable = myNode.getConfigurable();
            if (configurable == null || (handler = BaseStructureConfigurable.findHandler(handlers, configurable.getClass())) == null) continue;
            grouped.putValue(handler, (Object)myNode);
        }
        MultiMap multiMap = grouped;
        if (multiMap == null) {
            BaseStructureConfigurable.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    private static RemoveConfigurableHandler<?> findHandler(List<? extends RemoveConfigurableHandler<?>> handlers, Class<? extends NamedConfigurable> configurableClass) {
        for (RemoveConfigurableHandler<?> handler : handlers) {
            if (!handler.getConfigurableClass().isAssignableFrom(configurableClass)) continue;
            return handler;
        }
        return null;
    }

    private static List<?> getEditableObjects(Collection<? extends MasterDetailsComponent.MyNode> value2) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (MasterDetailsComponent.MyNode myNode : value2) {
            objects.add(myNode.getConfigurable().getEditableObject());
        }
        return objects;
    }

    protected void removeFacetNodes(@NotNull List<? extends Facet> facets) {
        if (facets == null) {
            BaseStructureConfigurable.$$$reportNull$$$0(7);
        }
        for (Facet facet : facets) {
            MasterDetailsComponent.MyNode node = BaseStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)facet);
            if (node == null) continue;
            this.removePaths(new TreePath[]{TreeUtil.getPathFromRoot((TreeNode)node)});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForSpeedSearch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "groupNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeFacetNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class AbstractAddGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection {
        protected AbstractAddGroup(String text2, Icon icon) {
            super(text2, true);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(icon);
            KeymapManager keymapManager = KeymapManager.getInstance();
            if (keymapManager != null) {
                Keymap active = keymapManager.getActiveKeymap();
                Shortcut[] shortcuts = active.getShortcuts("NewElement");
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts));
            }
        }

        public AbstractAddGroup(@Nls String text2) {
            this(text2, IconUtil.getAddIcon());
        }

        public ActionGroup getActionGroup() {
            return this;
        }
    }

    protected class MyRemoveAction
    extends MasterDetailsComponent.MyDeleteAction {
        public MyRemoveAction() {
            super((MasterDetailsComponent)BaseStructureConfigurable.this, (Condition)new Condition<Object[]>(){

                public boolean value(Object[] objects) {
                    ArrayList<MasterDetailsComponent.MyNode> nodes = new ArrayList<MasterDetailsComponent.MyNode>();
                    for (Object object : objects) {
                        if (!(object instanceof MasterDetailsComponent.MyNode)) {
                            return false;
                        }
                        nodes.add((MasterDetailsComponent.MyNode)object);
                    }
                    MultiMap map2 = BaseStructureConfigurable.this.groupNodes(nodes);
                    for (Map.Entry entry : map2.entrySet()) {
                        if (((RemoveConfigurableHandler)entry.getKey()).canBeRemoved(BaseStructureConfigurable.getEditableObjects((Collection)entry.getValue()))) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreePath[] paths;
            if (e == null) {
                MyRemoveAction.$$$reportNull$$$0(0);
            }
            if ((paths = BaseStructureConfigurable.this.myTree.getSelectionPaths()) == null) {
                return;
            }
            List<MasterDetailsComponent.MyNode> removedNodes = this.removeFromModel(paths);
            BaseStructureConfigurable.this.removeNodes(removedNodes);
        }

        private List<MasterDetailsComponent.MyNode> removeFromModel(TreePath[] paths) {
            List nodes = ContainerUtil.mapNotNull((Object[])paths, path -> {
                Object node = path.getLastPathComponent();
                return node instanceof MasterDetailsComponent.MyNode ? (MasterDetailsComponent.MyNode)node : null;
            });
            MultiMap grouped = BaseStructureConfigurable.this.groupNodes(nodes);
            ArrayList<MasterDetailsComponent.MyNode> removedNodes = new ArrayList<MasterDetailsComponent.MyNode>();
            for (Map.Entry entry : grouped.entrySet()) {
                boolean removed = ((RemoveConfigurableHandler)entry.getKey()).remove(BaseStructureConfigurable.getEditableObjects((Collection)entry.getValue()));
                if (!removed) continue;
                removedNodes.addAll((Collection)entry.getValue());
            }
            return removedNodes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable$MyRemoveAction", "actionPerformed"));
        }
    }

    private class MyFindUsagesAction
    extends FindUsagesInProjectStructureActionBase {
        MyFindUsagesAction(JComponent parentComponent) {
            super(parentComponent, BaseStructureConfigurable.this.myProject);
        }

        @Override
        protected boolean isEnabled() {
            TreePath selectionPath = BaseStructureConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
                return !node.isDisplayInBold();
            }
            return false;
        }

        @Override
        protected StructureConfigurableContext getContext() {
            return BaseStructureConfigurable.this.myContext;
        }

        @Override
        protected ProjectStructureElement getSelectedElement() {
            return BaseStructureConfigurable.this.getSelectedElement();
        }

        @Override
        protected RelativePoint getPointToShowResults() {
            int selectedRow = BaseStructureConfigurable.this.myTree.getSelectionRows()[0];
            Rectangle rowBounds = BaseStructureConfigurable.this.myTree.getRowBounds(selectedRow);
            Point location = rowBounds.getLocation();
            location.x += rowBounds.width;
            return new RelativePoint((Component)BaseStructureConfigurable.this.myTree, location);
        }
    }
}

