/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandler;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrtFileSystemImpl
extends JrtFileSystem {
    private final Map<String, ArchiveHandler> myHandlers = Collections.synchronizedMap(new THashMap(FileUtil.PATH_HASHING_STRATEGY));
    private final AtomicBoolean mySubscribed = new AtomicBoolean(false);
    private final DiskQueryRelay<VirtualFile, FileAttributes> myAttrGetter = new DiskQueryRelay(x$0 -> super.getAttributes(x$0));
    private final DiskQueryRelay<VirtualFile, String[]> myChildrenGetter = new DiskQueryRelay(x$0 -> super.list(x$0));

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(0);
        }
        return (FileAttributes)this.myAttrGetter.accessDiskWithCheckCanceled((Object)file);
    }

    public String @NotNull [] list(@NotNull VirtualFile file) {
        if (file == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(1);
        }
        String[] stringArray = (String[])this.myChildrenGetter.accessDiskWithCheckCanceled((Object)file);
        if (stringArray == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        int separatorIndex;
        if (path == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(3);
        }
        return (separatorIndex = path.indexOf("!/")) > 0 ? FileUtil.normalize((String)path.substring(0, separatorIndex)) + path.substring(separatorIndex) : null;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(4);
        }
        String string = StringUtil.trimEnd((String)rootPath, (String)"!/");
        if (string == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(6);
        }
        String string = localPath + "!/";
        if (string == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        int separatorIndex;
        if (normalizedPath == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(8);
        }
        return (separatorIndex = normalizedPath.indexOf("!/")) > 0 ? normalizedPath.substring(0, separatorIndex + "!/".length()) : "";
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(9);
        }
        this.checkSubscription();
        String homePath = this.extractLocalPath(VfsUtilCore.getRootFile((VirtualFile)entryFile).getPath());
        ArchiveHandler archiveHandler = this.myHandlers.computeIfAbsent(homePath, key2 -> {
            JrtHandler handler = new JrtHandler((String)key2);
            ApplicationManager.getApplication().invokeLater(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(key2 + "/release"), ModalityState.defaultModalityState());
            return handler;
        });
        if (archiveHandler == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(10);
        }
        return archiveHandler;
    }

    private void checkSubscription() {
        if (this.mySubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDisposed()) {
            return;
        }
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashSet<VirtualFile> toRefresh = null;
                for (VFileEvent vFileEvent : events) {
                    ArchiveHandler handler;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem)) continue;
                    String homePath = null;
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        VirtualFile file = ((VFileContentChangeEvent)vFileEvent).getFile();
                        if ("release".equals(file.getName())) {
                            homePath = file.getParent().getPath();
                        }
                    } else if (vFileEvent instanceof VFileDeleteEvent) {
                        homePath = ((VFileDeleteEvent)vFileEvent).getFile().getPath();
                    }
                    if (homePath == null || (handler = (ArchiveHandler)JrtFileSystemImpl.this.myHandlers.remove(homePath)) == null) continue;
                    handler.dispose();
                    VirtualFile root = JrtFileSystemImpl.this.findFileByPath(JrtFileSystemImpl.this.composeRootPath(homePath));
                    if (root == null) continue;
                    ((NewVirtualFile)root).markDirtyRecursively();
                    if (toRefresh == null) {
                        toRefresh = new HashSet<VirtualFile>();
                    }
                    toRefresh.add(root);
                }
                if (toRefresh != null) {
                    boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                    RefreshQueue.getInstance().refresh(async, true, null, toRefresh);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl$1", "after"));
            }
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(11);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(12);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(13);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        String path;
        if (local == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(14);
        }
        return JdkUtil.isModularRuntime((String)(path = local.getPath())) && !JdkUtil.isExplodedModularRuntime((String)path);
    }

    public void release(@NotNull String localPath) {
        if (localPath == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(15);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        ArchiveHandler handler = this.myHandlers.remove(localPath);
        if (handler == null) {
            throw new IllegalArgumentException(localPath + " not in " + this.myHandlers.keySet());
        }
        handler.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectFileType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

