/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.ui.ArtifactElementPresentation;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactPackagingElement
extends ComplexPackagingElement<ArtifactPackagingElementState> {
    private static final Logger LOG = Logger.getInstance(ArtifactPackagingElement.class);
    private final Project myProject;
    private ArtifactPointer myArtifactPointer;
    @NonNls
    public static final String ARTIFACT_NAME_ATTRIBUTE = "artifact-name";

    public ArtifactPackagingElement(@NotNull Project project) {
        if (project == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(0);
        }
        super((PackagingElementType)ArtifactElementType.ARTIFACT_ELEMENT_TYPE);
        this.myProject = project;
    }

    public ArtifactPackagingElement(@NotNull Project project, @NotNull ArtifactPointer artifactPointer) {
        if (project == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(1);
        }
        if (artifactPointer == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(2);
        }
        this(project);
        this.myArtifactPointer = artifactPointer;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        Artifact artifact;
        if (context == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(3);
        }
        if (artifactType == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(4);
        }
        if ((artifact = this.findArtifact(context)) != null) {
            ArtifactType type2 = artifact.getArtifactType();
            List substitution = type2.getSubstitution(artifact, context, artifactType);
            if (substitution != null) {
                return substitution;
            }
            ArrayList<CompositePackagingElement> elements = new ArrayList<CompositePackagingElement>();
            CompositePackagingElement rootElement = artifact.getRootElement();
            if (rootElement instanceof ArtifactRootElement) {
                elements.addAll(rootElement.getChildren());
            } else {
                elements.add(rootElement);
            }
            return elements;
        }
        return null;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(5);
        }
        return new DelegatedPackagingElementPresentation(new ArtifactElementPresentation(this.myArtifactPointer, context));
    }

    public ArtifactPackagingElementState getState() {
        ArtifactPackagingElementState state = new ArtifactPackagingElementState();
        if (this.myArtifactPointer != null) {
            state.setArtifactName(this.myArtifactPointer.getArtifactName());
        }
        return state;
    }

    public void loadState(@NotNull ArtifactPackagingElementState state) {
        String name2;
        if (state == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(6);
        }
        this.myArtifactPointer = (name2 = state.getArtifactName()) != null ? ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(name2) : null;
    }

    public String toString() {
        return "artifact:" + this.getArtifactName();
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(7);
        }
        return element instanceof ArtifactPackagingElement && this.myArtifactPointer != null && this.myArtifactPointer.equals(((ArtifactPackagingElement)element).myArtifactPointer);
    }

    @Nullable
    public Artifact findArtifact(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            ArtifactPackagingElement.$$$reportNull$$$0(8);
        }
        return this.myArtifactPointer != null ? this.myArtifactPointer.findArtifact(context.getArtifactModel()) : null;
    }

    @Nullable
    public String getArtifactName() {
        return this.myArtifactPointer != null ? this.myArtifactPointer.getArtifactName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPointer";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/ArtifactPackagingElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSubstitution";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findArtifact";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ArtifactPackagingElementState {
        private String myArtifactName;

        @Attribute(value="artifact-name")
        public String getArtifactName() {
            return this.myArtifactName;
        }

        public void setArtifactName(String artifactName) {
            this.myArtifactName = artifactName;
        }
    }
}

